/*
 * Decompiled with CFR 0.152.
 */
package parser;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.parser.Parser;
import ca.uhn.hl7v2.parser.PipeParser;
import ca.uhn.hl7v2.util.Terser;
import ca.uhn.hl7v2.validation.impl.NoValidation;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import parser.DefaultGenericHandler;

public class HHSEmrDownloadHandler
extends DefaultGenericHandler {
    Logger logger = Logger.getLogger(HHSEmrDownloadHandler.class.getName());
    List<String> headerList = null;

    @Override
    public String getMsgType() {
        return "HHSEMR";
    }

    @Override
    public List<String> getHeaders() {
        String[] noms;
        this.headerList = new ArrayList<String>();
        for (String s : noms = this.msg.getNames()) {
            this.logger.log(Level.FINE, s);
        }
        for (int i = 0; i < this.getOBRCount(); ++i) {
            this.headerList.add(this.getOBRName(i));
            this.logger.log(Level.FINE, "ADDING to header " + this.getOBRName(i));
        }
        this.logger.log(Level.FINE, "AFTER");
        try {
            Structure[] strs;
            this.logger.log(Level.FINE, "Current Group " + this.terser.getFinder().getCurrentGroup().getName());
            for (Structure str : strs = this.terser.getFinder().getCurrentChildReps()) {
                Structure[] structChilds;
                this.logger.log(Level.FINE, str.getClass().getName() + "  " + str.getName());
                Group obrseg = (Group)str;
                for (Structure ss : structChilds = obrseg.getAll("OBX")) {
                    this.logger.log(Level.FINE, ss.getClass().getName() + " " + str.getName());
                }
            }
        }
        catch (Exception e) {
            this.logger.log(Level.FINE, "getHeaders", e);
        }
        return this.headerList;
    }

    @Override
    public String getObservationHeader(int i, int j) {
        return this.headerList.get(i);
    }

    private void findOBX(Group group, ArrayList<Segment> list) throws Exception {
        String[] noms;
        for (String nom : noms = group.getNames()) {
            Structure[] obxS;
            for (Structure ss : obxS = group.getAll(nom)) {
                if (ss instanceof Segment) {
                    if (!"OBX".equals(ss.getName())) continue;
                    list.add((Segment)ss);
                    continue;
                }
                this.findOBX((Group)ss, list);
            }
        }
    }

    @Override
    public void init(String hl7Body) throws HL7Exception {
        PipeParser p = new PipeParser();
        ((Parser)p).setValidationContext(new NoValidation());
        this.msg = ((Parser)p).parse(hl7Body.replaceAll("\n", "\r\n"));
        this.terser = new Terser(this.msg);
        this.obrGroups = new ArrayList();
        this.logger.log(Level.FINE, "Current Group " + this.terser.getFinder().getCurrentGroup().getName());
        try {
            Structure[] strs;
            for (Structure str : strs = ((Group)this.terser.getFinder().getRoot().get("RESPONSE")).getAll("ORDER_OBSERVATION")) {
                this.logger.log(Level.FINE, "NEW OBX");
                ArrayList<Segment> obrGroup = new ArrayList<Segment>();
                this.findOBX((Group)str, obrGroup);
                this.obrGroups.add(obrGroup);
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Error in adding OBX elements to obrGroup ", e);
            System.out.println("exception: " + e);
        }
        this.logger.log(Level.FINE, "END GROUP PRINT");
    }

    @Override
    public String getOBRName(int i) {
        String addToEnd = "";
        try {
            addToEnd = " " + this.getString(this.terser.get("/.OBR-19-2"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.getOBRName(i) + addToEnd;
    }

    @Override
    public String getOBXName(int i, int j) {
        return this.getOBXField(i, j, 3, 0, 2);
    }

    @Override
    public String getOBXReferenceRange(int i, int j) {
        return this.getOBXField(i, j, 7, 0, 3);
    }

    @Override
    public String getHealthNum() {
        try {
            String healthNum = this.getString(this.terser.get("/.PID-3-1"));
            return healthNum;
        }
        catch (Exception exception) {
            return "";
        }
    }

    @Override
    public String getAccessionNum() {
        try {
            String accessionNum = this.getString(this.terser.get("/.MSH-10-1"));
            return accessionNum;
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public ArrayList<String> getDocNums() {
        ArrayList<String> nums = new ArrayList<String>();
        try {
            String docNum = this.terser.get("/.Z01-1-1");
            if (docNum != null) {
                this.logger.log(Level.FINE, "Adding doc Num" + HHSEmrDownloadHandler.forwardZero(docNum, 6));
                nums.add(HHSEmrDownloadHandler.forwardZero(docNum, 6));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return nums;
    }

    public static String forwardZero(String y, int x) {
        String returnZeroValue = new String();
        y = HHSEmrDownloadHandler.safeString(y);
        for (int i = y.length(); i < x; ++i) {
            returnZeroValue = returnZeroValue + "0";
        }
        return HHSEmrDownloadHandler.cutFrontString(returnZeroValue + y, x);
    }

    public static String safeString(String str) {
        return null != str ? str : "";
    }

    public static String cutFrontString(String str, int len) {
        return str.substring(str.length() - len, str.length());
    }
}

