/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v28.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v28.datatype.CNE;
import ca.uhn.hl7v2.model.v28.datatype.EI;
import ca.uhn.hl7v2.model.v28.datatype.SI;
import ca.uhn.hl7v2.model.v28.datatype.ST;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class VND
extends AbstractSegment {
    public VND(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, true, 1, 4, new Object[]{this.getMessage()}, "Set Id - VND");
            this.add(EI.class, true, 1, 0, new Object[]{this.getMessage()}, "Vendor Identifier");
            this.add(ST.class, false, 1, 0, new Object[]{this.getMessage()}, "Vendor Name");
            this.add(EI.class, false, 1, 0, new Object[]{this.getMessage()}, "Vendor Catalog Number");
            this.add(CNE.class, false, 1, 0, new Object[]{this.getMessage()}, "Primary Vendor Indicator");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating VND - this is probably a bug in the source code generator.", e);
        }
    }

    public SI getSetIdVND() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getVnd1_SetIdVND() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public EI getVendorIdentifier() {
        EI retVal = (EI)this.getTypedField(2, 0);
        return retVal;
    }

    public EI getVnd2_VendorIdentifier() {
        EI retVal = (EI)this.getTypedField(2, 0);
        return retVal;
    }

    public ST getVendorName() {
        ST retVal = (ST)this.getTypedField(3, 0);
        return retVal;
    }

    public ST getVnd3_VendorName() {
        ST retVal = (ST)this.getTypedField(3, 0);
        return retVal;
    }

    public EI getVendorCatalogNumber() {
        EI retVal = (EI)this.getTypedField(4, 0);
        return retVal;
    }

    public EI getVnd4_VendorCatalogNumber() {
        EI retVal = (EI)this.getTypedField(4, 0);
        return retVal;
    }

    public CNE getPrimaryVendorIndicator() {
        CNE retVal = (CNE)this.getTypedField(5, 0);
        return retVal;
    }

    public CNE getVnd5_PrimaryVendorIndicator() {
        CNE retVal = (CNE)this.getTypedField(5, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new EI(this.getMessage());
            }
            case 2: {
                return new ST(this.getMessage());
            }
            case 3: {
                return new EI(this.getMessage());
            }
            case 4: {
                return new CNE(this.getMessage());
            }
        }
        return null;
    }
}

