/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v28.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v28.datatype.CP;
import ca.uhn.hl7v2.model.v28.datatype.CWE;
import ca.uhn.hl7v2.model.v28.datatype.NM;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class GP2
extends AbstractSegment {
    public GP2(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Revenue Code");
            this.add(NM.class, false, 1, 0, new Object[]{this.getMessage()}, "Number of Service Units");
            this.add(CP.class, false, 1, 0, new Object[]{this.getMessage()}, "Charge");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Reimbursement Action Code");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Denial or Rejection Code");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "OCE Edit Code");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Ambulatory Payment Classification Code");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Modifier Edit Code");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Payment Adjustment Code");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Packaging Status Code");
            this.add(CP.class, false, 1, 0, new Object[]{this.getMessage()}, "Expected CMS Payment Amount");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Reimbursement Type Code");
            this.add(CP.class, false, 1, 0, new Object[]{this.getMessage()}, "Co-Pay Amount");
            this.add(NM.class, false, 1, 0, new Object[]{this.getMessage()}, "Pay Rate per Service Unit");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating GP2 - this is probably a bug in the source code generator.", e);
        }
    }

    public CWE getRevenueCode() {
        CWE retVal = (CWE)this.getTypedField(1, 0);
        return retVal;
    }

    public CWE getGp21_RevenueCode() {
        CWE retVal = (CWE)this.getTypedField(1, 0);
        return retVal;
    }

    public NM getNumberOfServiceUnits() {
        NM retVal = (NM)this.getTypedField(2, 0);
        return retVal;
    }

    public NM getGp22_NumberOfServiceUnits() {
        NM retVal = (NM)this.getTypedField(2, 0);
        return retVal;
    }

    public CP getCharge() {
        CP retVal = (CP)this.getTypedField(3, 0);
        return retVal;
    }

    public CP getGp23_Charge() {
        CP retVal = (CP)this.getTypedField(3, 0);
        return retVal;
    }

    public CWE getReimbursementActionCode() {
        CWE retVal = (CWE)this.getTypedField(4, 0);
        return retVal;
    }

    public CWE getGp24_ReimbursementActionCode() {
        CWE retVal = (CWE)this.getTypedField(4, 0);
        return retVal;
    }

    public CWE getDenialOrRejectionCode() {
        CWE retVal = (CWE)this.getTypedField(5, 0);
        return retVal;
    }

    public CWE getGp25_DenialOrRejectionCode() {
        CWE retVal = (CWE)this.getTypedField(5, 0);
        return retVal;
    }

    public CWE[] getOCEEditCode() {
        CWE[] retVal = (CWE[])this.getTypedField(6, new CWE[0]);
        return retVal;
    }

    public CWE[] getGp26_OCEEditCode() {
        CWE[] retVal = (CWE[])this.getTypedField(6, new CWE[0]);
        return retVal;
    }

    public int getOCEEditCodeReps() {
        return this.getReps(6);
    }

    public CWE getOCEEditCode(int rep) {
        CWE retVal = (CWE)this.getTypedField(6, rep);
        return retVal;
    }

    public CWE getGp26_OCEEditCode(int rep) {
        CWE retVal = (CWE)this.getTypedField(6, rep);
        return retVal;
    }

    public int getGp26_OCEEditCodeReps() {
        return this.getReps(6);
    }

    public CWE insertOCEEditCode(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(6, rep);
    }

    public CWE insertGp26_OCEEditCode(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(6, rep);
    }

    public CWE removeOCEEditCode(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(6, rep);
    }

    public CWE removeGp26_OCEEditCode(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(6, rep);
    }

    public CWE getAmbulatoryPaymentClassificationCode() {
        CWE retVal = (CWE)this.getTypedField(7, 0);
        return retVal;
    }

    public CWE getGp27_AmbulatoryPaymentClassificationCode() {
        CWE retVal = (CWE)this.getTypedField(7, 0);
        return retVal;
    }

    public CWE[] getModifierEditCode() {
        CWE[] retVal = (CWE[])this.getTypedField(8, new CWE[0]);
        return retVal;
    }

    public CWE[] getGp28_ModifierEditCode() {
        CWE[] retVal = (CWE[])this.getTypedField(8, new CWE[0]);
        return retVal;
    }

    public int getModifierEditCodeReps() {
        return this.getReps(8);
    }

    public CWE getModifierEditCode(int rep) {
        CWE retVal = (CWE)this.getTypedField(8, rep);
        return retVal;
    }

    public CWE getGp28_ModifierEditCode(int rep) {
        CWE retVal = (CWE)this.getTypedField(8, rep);
        return retVal;
    }

    public int getGp28_ModifierEditCodeReps() {
        return this.getReps(8);
    }

    public CWE insertModifierEditCode(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(8, rep);
    }

    public CWE insertGp28_ModifierEditCode(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(8, rep);
    }

    public CWE removeModifierEditCode(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(8, rep);
    }

    public CWE removeGp28_ModifierEditCode(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(8, rep);
    }

    public CWE getPaymentAdjustmentCode() {
        CWE retVal = (CWE)this.getTypedField(9, 0);
        return retVal;
    }

    public CWE getGp29_PaymentAdjustmentCode() {
        CWE retVal = (CWE)this.getTypedField(9, 0);
        return retVal;
    }

    public CWE getPackagingStatusCode() {
        CWE retVal = (CWE)this.getTypedField(10, 0);
        return retVal;
    }

    public CWE getGp210_PackagingStatusCode() {
        CWE retVal = (CWE)this.getTypedField(10, 0);
        return retVal;
    }

    public CP getExpectedCMSPaymentAmount() {
        CP retVal = (CP)this.getTypedField(11, 0);
        return retVal;
    }

    public CP getGp211_ExpectedCMSPaymentAmount() {
        CP retVal = (CP)this.getTypedField(11, 0);
        return retVal;
    }

    public CWE getReimbursementTypeCode() {
        CWE retVal = (CWE)this.getTypedField(12, 0);
        return retVal;
    }

    public CWE getGp212_ReimbursementTypeCode() {
        CWE retVal = (CWE)this.getTypedField(12, 0);
        return retVal;
    }

    public CP getCoPayAmount() {
        CP retVal = (CP)this.getTypedField(13, 0);
        return retVal;
    }

    public CP getGp213_CoPayAmount() {
        CP retVal = (CP)this.getTypedField(13, 0);
        return retVal;
    }

    public NM getPayRatePerServiceUnit() {
        NM retVal = (NM)this.getTypedField(14, 0);
        return retVal;
    }

    public NM getGp214_PayRatePerServiceUnit() {
        NM retVal = (NM)this.getTypedField(14, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new CWE(this.getMessage());
            }
            case 1: {
                return new NM(this.getMessage());
            }
            case 2: {
                return new CP(this.getMessage());
            }
            case 3: {
                return new CWE(this.getMessage());
            }
            case 4: {
                return new CWE(this.getMessage());
            }
            case 5: {
                return new CWE(this.getMessage());
            }
            case 6: {
                return new CWE(this.getMessage());
            }
            case 7: {
                return new CWE(this.getMessage());
            }
            case 8: {
                return new CWE(this.getMessage());
            }
            case 9: {
                return new CWE(this.getMessage());
            }
            case 10: {
                return new CP(this.getMessage());
            }
            case 11: {
                return new CWE(this.getMessage());
            }
            case 12: {
                return new CP(this.getMessage());
            }
            case 13: {
                return new NM(this.getMessage());
            }
        }
        return null;
    }
}

