/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v28.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v28.group.RRG_O16_GIVE;
import ca.uhn.hl7v2.model.v28.group.RRG_O16_TIMING;
import ca.uhn.hl7v2.model.v28.segment.ORC;
import ca.uhn.hl7v2.model.v28.segment.PRT;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class RRG_O16_ORDER
extends AbstractGroup {
    public RRG_O16_ORDER(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ORC.class, true, false, false);
            this.add(PRT.class, false, true, false);
            this.add(RRG_O16_TIMING.class, false, true, false);
            this.add(RRG_O16_GIVE.class, false, false, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating RRG_O16_ORDER - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.8";
    }

    public ORC getORC() {
        ORC retVal = this.getTyped("ORC", ORC.class);
        return retVal;
    }

    public PRT getPRT() {
        PRT retVal = this.getTyped("PRT", PRT.class);
        return retVal;
    }

    public PRT getPRT(int rep) {
        PRT retVal = this.getTyped("PRT", rep, PRT.class);
        return retVal;
    }

    public int getPRTReps() {
        return this.getReps("PRT");
    }

    public List<PRT> getPRTAll() throws HL7Exception {
        return this.getAllAsList("PRT", PRT.class);
    }

    public void insertPRT(PRT structure, int rep) throws HL7Exception {
        super.insertRepetition("PRT", structure, rep);
    }

    public PRT insertPRT(int rep) throws HL7Exception {
        return (PRT)super.insertRepetition("PRT", rep);
    }

    public PRT removePRT(int rep) throws HL7Exception {
        return (PRT)super.removeRepetition("PRT", rep);
    }

    public RRG_O16_TIMING getTIMING() {
        RRG_O16_TIMING retVal = this.getTyped("TIMING", RRG_O16_TIMING.class);
        return retVal;
    }

    public RRG_O16_TIMING getTIMING(int rep) {
        RRG_O16_TIMING retVal = this.getTyped("TIMING", rep, RRG_O16_TIMING.class);
        return retVal;
    }

    public int getTIMINGReps() {
        return this.getReps("TIMING");
    }

    public List<RRG_O16_TIMING> getTIMINGAll() throws HL7Exception {
        return this.getAllAsList("TIMING", RRG_O16_TIMING.class);
    }

    public void insertTIMING(RRG_O16_TIMING structure, int rep) throws HL7Exception {
        super.insertRepetition("TIMING", structure, rep);
    }

    public RRG_O16_TIMING insertTIMING(int rep) throws HL7Exception {
        return (RRG_O16_TIMING)super.insertRepetition("TIMING", rep);
    }

    public RRG_O16_TIMING removeTIMING(int rep) throws HL7Exception {
        return (RRG_O16_TIMING)super.removeRepetition("TIMING", rep);
    }

    public RRG_O16_GIVE getGIVE() {
        RRG_O16_GIVE retVal = this.getTyped("GIVE", RRG_O16_GIVE.class);
        return retVal;
    }
}

