/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v27.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v27.group.RSP_Z90_OBSERVATION;
import ca.uhn.hl7v2.model.v27.group.RSP_Z90_TIMING;
import ca.uhn.hl7v2.model.v27.segment.CTD;
import ca.uhn.hl7v2.model.v27.segment.NTE;
import ca.uhn.hl7v2.model.v27.segment.OBR;
import ca.uhn.hl7v2.model.v27.segment.ORC;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class RSP_Z90_COMMON_ORDER
extends AbstractGroup {
    public RSP_Z90_COMMON_ORDER(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ORC.class, true, false, false);
            this.add(RSP_Z90_TIMING.class, false, true, false);
            this.add(OBR.class, true, false, false);
            this.add(NTE.class, false, true, false);
            this.add(CTD.class, false, false, false);
            this.add(RSP_Z90_OBSERVATION.class, true, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating RSP_Z90_COMMON_ORDER - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.7";
    }

    public ORC getORC() {
        ORC retVal = this.getTyped("ORC", ORC.class);
        return retVal;
    }

    public RSP_Z90_TIMING getTIMING() {
        RSP_Z90_TIMING retVal = this.getTyped("TIMING", RSP_Z90_TIMING.class);
        return retVal;
    }

    public RSP_Z90_TIMING getTIMING(int rep) {
        RSP_Z90_TIMING retVal = this.getTyped("TIMING", rep, RSP_Z90_TIMING.class);
        return retVal;
    }

    public int getTIMINGReps() {
        return this.getReps("TIMING");
    }

    public List<RSP_Z90_TIMING> getTIMINGAll() throws HL7Exception {
        return this.getAllAsList("TIMING", RSP_Z90_TIMING.class);
    }

    public void insertTIMING(RSP_Z90_TIMING structure, int rep) throws HL7Exception {
        super.insertRepetition("TIMING", structure, rep);
    }

    public RSP_Z90_TIMING insertTIMING(int rep) throws HL7Exception {
        return (RSP_Z90_TIMING)super.insertRepetition("TIMING", rep);
    }

    public RSP_Z90_TIMING removeTIMING(int rep) throws HL7Exception {
        return (RSP_Z90_TIMING)super.removeRepetition("TIMING", rep);
    }

    public OBR getOBR() {
        OBR retVal = this.getTyped("OBR", OBR.class);
        return retVal;
    }

    public NTE getNTE() {
        NTE retVal = this.getTyped("NTE", NTE.class);
        return retVal;
    }

    public NTE getNTE(int rep) {
        NTE retVal = this.getTyped("NTE", rep, NTE.class);
        return retVal;
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public CTD getCTD() {
        CTD retVal = this.getTyped("CTD", CTD.class);
        return retVal;
    }

    public RSP_Z90_OBSERVATION getOBSERVATION() {
        RSP_Z90_OBSERVATION retVal = this.getTyped("OBSERVATION", RSP_Z90_OBSERVATION.class);
        return retVal;
    }

    public RSP_Z90_OBSERVATION getOBSERVATION(int rep) {
        RSP_Z90_OBSERVATION retVal = this.getTyped("OBSERVATION", rep, RSP_Z90_OBSERVATION.class);
        return retVal;
    }

    public int getOBSERVATIONReps() {
        return this.getReps("OBSERVATION");
    }

    public List<RSP_Z90_OBSERVATION> getOBSERVATIONAll() throws HL7Exception {
        return this.getAllAsList("OBSERVATION", RSP_Z90_OBSERVATION.class);
    }

    public void insertOBSERVATION(RSP_Z90_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("OBSERVATION", structure, rep);
    }

    public RSP_Z90_OBSERVATION insertOBSERVATION(int rep) throws HL7Exception {
        return (RSP_Z90_OBSERVATION)super.insertRepetition("OBSERVATION", rep);
    }

    public RSP_Z90_OBSERVATION removeOBSERVATION(int rep) throws HL7Exception {
        return (RSP_Z90_OBSERVATION)super.removeRepetition("OBSERVATION", rep);
    }
}

