/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v27.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v27.group.RAS_O17_TIMING_ENCODED;
import ca.uhn.hl7v2.model.v27.segment.NTE;
import ca.uhn.hl7v2.model.v27.segment.PRT;
import ca.uhn.hl7v2.model.v27.segment.RXC;
import ca.uhn.hl7v2.model.v27.segment.RXE;
import ca.uhn.hl7v2.model.v27.segment.RXR;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class RAS_O17_ENCODING
extends AbstractGroup {
    public RAS_O17_ENCODING(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(RXE.class, true, false, false);
            this.add(PRT.class, false, true, false);
            this.add(NTE.class, false, true, false);
            this.add(RAS_O17_TIMING_ENCODED.class, true, true, false);
            this.add(RXR.class, true, true, false);
            this.add(RXC.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating RAS_O17_ENCODING - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.7";
    }

    public RXE getRXE() {
        RXE retVal = this.getTyped("RXE", RXE.class);
        return retVal;
    }

    public PRT getPRT() {
        PRT retVal = this.getTyped("PRT", PRT.class);
        return retVal;
    }

    public PRT getPRT(int rep) {
        PRT retVal = this.getTyped("PRT", rep, PRT.class);
        return retVal;
    }

    public int getPRTReps() {
        return this.getReps("PRT");
    }

    public List<PRT> getPRTAll() throws HL7Exception {
        return this.getAllAsList("PRT", PRT.class);
    }

    public void insertPRT(PRT structure, int rep) throws HL7Exception {
        super.insertRepetition("PRT", structure, rep);
    }

    public PRT insertPRT(int rep) throws HL7Exception {
        return (PRT)super.insertRepetition("PRT", rep);
    }

    public PRT removePRT(int rep) throws HL7Exception {
        return (PRT)super.removeRepetition("PRT", rep);
    }

    public NTE getNTE() {
        NTE retVal = this.getTyped("NTE", NTE.class);
        return retVal;
    }

    public NTE getNTE(int rep) {
        NTE retVal = this.getTyped("NTE", rep, NTE.class);
        return retVal;
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public RAS_O17_TIMING_ENCODED getTIMING_ENCODED() {
        RAS_O17_TIMING_ENCODED retVal = this.getTyped("TIMING_ENCODED", RAS_O17_TIMING_ENCODED.class);
        return retVal;
    }

    public RAS_O17_TIMING_ENCODED getTIMING_ENCODED(int rep) {
        RAS_O17_TIMING_ENCODED retVal = this.getTyped("TIMING_ENCODED", rep, RAS_O17_TIMING_ENCODED.class);
        return retVal;
    }

    public int getTIMING_ENCODEDReps() {
        return this.getReps("TIMING_ENCODED");
    }

    public List<RAS_O17_TIMING_ENCODED> getTIMING_ENCODEDAll() throws HL7Exception {
        return this.getAllAsList("TIMING_ENCODED", RAS_O17_TIMING_ENCODED.class);
    }

    public void insertTIMING_ENCODED(RAS_O17_TIMING_ENCODED structure, int rep) throws HL7Exception {
        super.insertRepetition("TIMING_ENCODED", structure, rep);
    }

    public RAS_O17_TIMING_ENCODED insertTIMING_ENCODED(int rep) throws HL7Exception {
        return (RAS_O17_TIMING_ENCODED)super.insertRepetition("TIMING_ENCODED", rep);
    }

    public RAS_O17_TIMING_ENCODED removeTIMING_ENCODED(int rep) throws HL7Exception {
        return (RAS_O17_TIMING_ENCODED)super.removeRepetition("TIMING_ENCODED", rep);
    }

    public RXR getRXR() {
        RXR retVal = this.getTyped("RXR", RXR.class);
        return retVal;
    }

    public RXR getRXR(int rep) {
        RXR retVal = this.getTyped("RXR", rep, RXR.class);
        return retVal;
    }

    public int getRXRReps() {
        return this.getReps("RXR");
    }

    public List<RXR> getRXRAll() throws HL7Exception {
        return this.getAllAsList("RXR", RXR.class);
    }

    public void insertRXR(RXR structure, int rep) throws HL7Exception {
        super.insertRepetition("RXR", structure, rep);
    }

    public RXR insertRXR(int rep) throws HL7Exception {
        return (RXR)super.insertRepetition("RXR", rep);
    }

    public RXR removeRXR(int rep) throws HL7Exception {
        return (RXR)super.removeRepetition("RXR", rep);
    }

    public RXC getRXC() {
        RXC retVal = this.getTyped("RXC", RXC.class);
        return retVal;
    }

    public RXC getRXC(int rep) {
        RXC retVal = this.getTyped("RXC", rep, RXC.class);
        return retVal;
    }

    public int getRXCReps() {
        return this.getReps("RXC");
    }

    public List<RXC> getRXCAll() throws HL7Exception {
        return this.getAllAsList("RXC", RXC.class);
    }

    public void insertRXC(RXC structure, int rep) throws HL7Exception {
        super.insertRepetition("RXC", structure, rep);
    }

    public RXC insertRXC(int rep) throws HL7Exception {
        return (RXC)super.insertRepetition("RXC", rep);
    }

    public RXC removeRXC(int rep) throws HL7Exception {
        return (RXC)super.removeRepetition("RXC", rep);
    }
}

