/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v27.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v27.group.CQU_I19_ROLE_PROBLEM;
import ca.uhn.hl7v2.model.v27.segment.OBX;
import ca.uhn.hl7v2.model.v27.segment.PRB;
import ca.uhn.hl7v2.model.v27.segment.VAR;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class CQU_I19_PROBLEM
extends AbstractGroup {
    public CQU_I19_PROBLEM(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(PRB.class, true, false, false);
            this.add(VAR.class, false, true, false);
            this.add(CQU_I19_ROLE_PROBLEM.class, false, true, false);
            this.add(OBX.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating CQU_I19_PROBLEM - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.7";
    }

    public PRB getPRB() {
        PRB retVal = this.getTyped("PRB", PRB.class);
        return retVal;
    }

    public VAR getVAR() {
        VAR retVal = this.getTyped("VAR", VAR.class);
        return retVal;
    }

    public VAR getVAR(int rep) {
        VAR retVal = this.getTyped("VAR", rep, VAR.class);
        return retVal;
    }

    public int getVARReps() {
        return this.getReps("VAR");
    }

    public List<VAR> getVARAll() throws HL7Exception {
        return this.getAllAsList("VAR", VAR.class);
    }

    public void insertVAR(VAR structure, int rep) throws HL7Exception {
        super.insertRepetition("VAR", structure, rep);
    }

    public VAR insertVAR(int rep) throws HL7Exception {
        return (VAR)super.insertRepetition("VAR", rep);
    }

    public VAR removeVAR(int rep) throws HL7Exception {
        return (VAR)super.removeRepetition("VAR", rep);
    }

    public CQU_I19_ROLE_PROBLEM getROLE_PROBLEM() {
        CQU_I19_ROLE_PROBLEM retVal = this.getTyped("ROLE_PROBLEM", CQU_I19_ROLE_PROBLEM.class);
        return retVal;
    }

    public CQU_I19_ROLE_PROBLEM getROLE_PROBLEM(int rep) {
        CQU_I19_ROLE_PROBLEM retVal = this.getTyped("ROLE_PROBLEM", rep, CQU_I19_ROLE_PROBLEM.class);
        return retVal;
    }

    public int getROLE_PROBLEMReps() {
        return this.getReps("ROLE_PROBLEM");
    }

    public List<CQU_I19_ROLE_PROBLEM> getROLE_PROBLEMAll() throws HL7Exception {
        return this.getAllAsList("ROLE_PROBLEM", CQU_I19_ROLE_PROBLEM.class);
    }

    public void insertROLE_PROBLEM(CQU_I19_ROLE_PROBLEM structure, int rep) throws HL7Exception {
        super.insertRepetition("ROLE_PROBLEM", structure, rep);
    }

    public CQU_I19_ROLE_PROBLEM insertROLE_PROBLEM(int rep) throws HL7Exception {
        return (CQU_I19_ROLE_PROBLEM)super.insertRepetition("ROLE_PROBLEM", rep);
    }

    public CQU_I19_ROLE_PROBLEM removeROLE_PROBLEM(int rep) throws HL7Exception {
        return (CQU_I19_ROLE_PROBLEM)super.removeRepetition("ROLE_PROBLEM", rep);
    }

    public OBX getOBX() {
        OBX retVal = this.getTyped("OBX", OBX.class);
        return retVal;
    }

    public OBX getOBX(int rep) {
        OBX retVal = this.getTyped("OBX", rep, OBX.class);
        return retVal;
    }

    public int getOBXReps() {
        return this.getReps("OBX");
    }

    public List<OBX> getOBXAll() throws HL7Exception {
        return this.getAllAsList("OBX", OBX.class);
    }

    public void insertOBX(OBX structure, int rep) throws HL7Exception {
        super.insertRepetition("OBX", structure, rep);
    }

    public OBX insertOBX(int rep) throws HL7Exception {
        return (OBX)super.insertRepetition("OBX", rep);
    }

    public OBX removeOBX(int rep) throws HL7Exception {
        return (OBX)super.removeRepetition("OBX", rep);
    }
}

