/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v27.datatype;

import ca.uhn.hl7v2.model.AbstractComposite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v27.datatype.CWE;
import ca.uhn.hl7v2.model.v27.datatype.ST;
import ca.uhn.hl7v2.model.v27.datatype.TX;

public class PRL
extends AbstractComposite {
    private Type[] data;

    public PRL(Message message) {
        super(message);
        this.init();
    }

    private void init() {
        this.data = new Type[3];
        this.data[0] = new CWE(this.getMessage());
        this.data[1] = new ST(this.getMessage());
        this.data[2] = new TX(this.getMessage());
    }

    @Override
    public Type[] getComponents() {
        return this.data;
    }

    @Override
    public Type getComponent(int number) throws DataTypeException {
        try {
            return this.data[number];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + this.getClass().getName() + " has only " + this.data.length + " components)");
        }
    }

    public CWE getParentObservationIdentifier() {
        return this.getTyped(0, CWE.class);
    }

    public CWE getPrl1_ParentObservationIdentifier() {
        return this.getTyped(0, CWE.class);
    }

    public ST getParentObservationSubIdentifier() {
        return this.getTyped(1, ST.class);
    }

    public ST getPrl2_ParentObservationSubIdentifier() {
        return this.getTyped(1, ST.class);
    }

    public TX getParentObservationValueDescriptor() {
        return this.getTyped(2, TX.class);
    }

    public TX getPrl3_ParentObservationValueDescriptor() {
        return this.getTyped(2, TX.class);
    }
}

