/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v26.datatype.CWE;
import ca.uhn.hl7v2.model.v26.datatype.DTM;
import ca.uhn.hl7v2.model.v26.datatype.ID;
import ca.uhn.hl7v2.model.v26.datatype.IS;
import ca.uhn.hl7v2.model.v26.datatype.NM;
import ca.uhn.hl7v2.model.v26.datatype.PL;
import ca.uhn.hl7v2.model.v26.datatype.ST;
import ca.uhn.hl7v2.model.v26.datatype.TX;
import ca.uhn.hl7v2.model.v26.datatype.XCN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class OM7
extends AbstractSegment {
    public OM7(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(NM.class, true, 1, 4, new Object[]{this.getMessage()}, "Sequence Number - Test/Observation Master File");
            this.add(CWE.class, true, 1, 705, new Object[]{this.getMessage()}, "Universal Service Identifier");
            this.add(CWE.class, false, 0, 250, new Object[]{this.getMessage()}, "Category Identifier");
            this.add(TX.class, false, 1, 200, new Object[]{this.getMessage()}, "Category Description");
            this.add(ST.class, false, 0, 200, new Object[]{this.getMessage()}, "Category Synonym");
            this.add(DTM.class, false, 1, 24, new Object[]{this.getMessage()}, "Effective Test/Service Start Date/Time");
            this.add(DTM.class, false, 1, 24, new Object[]{this.getMessage()}, "Effective Test/Service End Date/Time");
            this.add(NM.class, false, 1, 5, new Object[]{this.getMessage()}, "Test/Service Default Duration Quantity");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "Test/Service Default Duration Units");
            this.add(IS.class, false, 1, 60, new Object[]{this.getMessage(), new Integer(0)}, "Test/Service Default Frequency");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Consent Indicator");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "Consent Identifier");
            this.add(DTM.class, false, 1, 24, new Object[]{this.getMessage()}, "Consent Effective Start Date/Time");
            this.add(DTM.class, false, 1, 24, new Object[]{this.getMessage()}, "Consent Effective End Date/Time");
            this.add(NM.class, false, 1, 5, new Object[]{this.getMessage()}, "Consent Interval Quantity");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "Consent Interval Units");
            this.add(NM.class, false, 1, 5, new Object[]{this.getMessage()}, "Consent Waiting Period Quantity");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "Consent Waiting Period Units");
            this.add(DTM.class, false, 1, 24, new Object[]{this.getMessage()}, "Effective Date/Time of Change");
            this.add(XCN.class, false, 1, 3220, new Object[]{this.getMessage()}, "Entered By");
            this.add(PL.class, false, 0, 200, new Object[]{this.getMessage()}, "Orderable-at Location");
            this.add(IS.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(473)}, "Formulary Status");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Special Order Indicator");
            this.add(CWE.class, false, 0, 250, new Object[]{this.getMessage()}, "Primary Key Value - CDM");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating OM7 - this is probably a bug in the source code generator.", e);
        }
    }

    public NM getSequenceNumberTestObservationMasterFile() {
        NM retVal = (NM)this.getTypedField(1, 0);
        return retVal;
    }

    public NM getOm71_SequenceNumberTestObservationMasterFile() {
        NM retVal = (NM)this.getTypedField(1, 0);
        return retVal;
    }

    public CWE getUniversalServiceIdentifier() {
        CWE retVal = (CWE)this.getTypedField(2, 0);
        return retVal;
    }

    public CWE getOm72_UniversalServiceIdentifier() {
        CWE retVal = (CWE)this.getTypedField(2, 0);
        return retVal;
    }

    public CWE[] getCategoryIdentifier() {
        CWE[] retVal = (CWE[])this.getTypedField(3, new CWE[0]);
        return retVal;
    }

    public CWE[] getOm73_CategoryIdentifier() {
        CWE[] retVal = (CWE[])this.getTypedField(3, new CWE[0]);
        return retVal;
    }

    public int getCategoryIdentifierReps() {
        return this.getReps(3);
    }

    public CWE getCategoryIdentifier(int rep) {
        CWE retVal = (CWE)this.getTypedField(3, rep);
        return retVal;
    }

    public CWE getOm73_CategoryIdentifier(int rep) {
        CWE retVal = (CWE)this.getTypedField(3, rep);
        return retVal;
    }

    public int getOm73_CategoryIdentifierReps() {
        return this.getReps(3);
    }

    public CWE insertCategoryIdentifier(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(3, rep);
    }

    public CWE insertOm73_CategoryIdentifier(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(3, rep);
    }

    public CWE removeCategoryIdentifier(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(3, rep);
    }

    public CWE removeOm73_CategoryIdentifier(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(3, rep);
    }

    public TX getCategoryDescription() {
        TX retVal = (TX)this.getTypedField(4, 0);
        return retVal;
    }

    public TX getOm74_CategoryDescription() {
        TX retVal = (TX)this.getTypedField(4, 0);
        return retVal;
    }

    public ST[] getCategorySynonym() {
        ST[] retVal = (ST[])this.getTypedField(5, new ST[0]);
        return retVal;
    }

    public ST[] getOm75_CategorySynonym() {
        ST[] retVal = (ST[])this.getTypedField(5, new ST[0]);
        return retVal;
    }

    public int getCategorySynonymReps() {
        return this.getReps(5);
    }

    public ST getCategorySynonym(int rep) {
        ST retVal = (ST)this.getTypedField(5, rep);
        return retVal;
    }

    public ST getOm75_CategorySynonym(int rep) {
        ST retVal = (ST)this.getTypedField(5, rep);
        return retVal;
    }

    public int getOm75_CategorySynonymReps() {
        return this.getReps(5);
    }

    public ST insertCategorySynonym(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(5, rep);
    }

    public ST insertOm75_CategorySynonym(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(5, rep);
    }

    public ST removeCategorySynonym(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(5, rep);
    }

    public ST removeOm75_CategorySynonym(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(5, rep);
    }

    public DTM getEffectiveTestServiceStartDateTime() {
        DTM retVal = (DTM)this.getTypedField(6, 0);
        return retVal;
    }

    public DTM getOm76_EffectiveTestServiceStartDateTime() {
        DTM retVal = (DTM)this.getTypedField(6, 0);
        return retVal;
    }

    public DTM getEffectiveTestServiceEndDateTime() {
        DTM retVal = (DTM)this.getTypedField(7, 0);
        return retVal;
    }

    public DTM getOm77_EffectiveTestServiceEndDateTime() {
        DTM retVal = (DTM)this.getTypedField(7, 0);
        return retVal;
    }

    public NM getTestServiceDefaultDurationQuantity() {
        NM retVal = (NM)this.getTypedField(8, 0);
        return retVal;
    }

    public NM getOm78_TestServiceDefaultDurationQuantity() {
        NM retVal = (NM)this.getTypedField(8, 0);
        return retVal;
    }

    public CWE getTestServiceDefaultDurationUnits() {
        CWE retVal = (CWE)this.getTypedField(9, 0);
        return retVal;
    }

    public CWE getOm79_TestServiceDefaultDurationUnits() {
        CWE retVal = (CWE)this.getTypedField(9, 0);
        return retVal;
    }

    public IS getTestServiceDefaultFrequency() {
        IS retVal = (IS)this.getTypedField(10, 0);
        return retVal;
    }

    public IS getOm710_TestServiceDefaultFrequency() {
        IS retVal = (IS)this.getTypedField(10, 0);
        return retVal;
    }

    public ID getConsentIndicator() {
        ID retVal = (ID)this.getTypedField(11, 0);
        return retVal;
    }

    public ID getOm711_ConsentIndicator() {
        ID retVal = (ID)this.getTypedField(11, 0);
        return retVal;
    }

    public CWE getConsentIdentifier() {
        CWE retVal = (CWE)this.getTypedField(12, 0);
        return retVal;
    }

    public CWE getOm712_ConsentIdentifier() {
        CWE retVal = (CWE)this.getTypedField(12, 0);
        return retVal;
    }

    public DTM getConsentEffectiveStartDateTime() {
        DTM retVal = (DTM)this.getTypedField(13, 0);
        return retVal;
    }

    public DTM getOm713_ConsentEffectiveStartDateTime() {
        DTM retVal = (DTM)this.getTypedField(13, 0);
        return retVal;
    }

    public DTM getConsentEffectiveEndDateTime() {
        DTM retVal = (DTM)this.getTypedField(14, 0);
        return retVal;
    }

    public DTM getOm714_ConsentEffectiveEndDateTime() {
        DTM retVal = (DTM)this.getTypedField(14, 0);
        return retVal;
    }

    public NM getConsentIntervalQuantity() {
        NM retVal = (NM)this.getTypedField(15, 0);
        return retVal;
    }

    public NM getOm715_ConsentIntervalQuantity() {
        NM retVal = (NM)this.getTypedField(15, 0);
        return retVal;
    }

    public CWE getConsentIntervalUnits() {
        CWE retVal = (CWE)this.getTypedField(16, 0);
        return retVal;
    }

    public CWE getOm716_ConsentIntervalUnits() {
        CWE retVal = (CWE)this.getTypedField(16, 0);
        return retVal;
    }

    public NM getConsentWaitingPeriodQuantity() {
        NM retVal = (NM)this.getTypedField(17, 0);
        return retVal;
    }

    public NM getOm717_ConsentWaitingPeriodQuantity() {
        NM retVal = (NM)this.getTypedField(17, 0);
        return retVal;
    }

    public CWE getConsentWaitingPeriodUnits() {
        CWE retVal = (CWE)this.getTypedField(18, 0);
        return retVal;
    }

    public CWE getOm718_ConsentWaitingPeriodUnits() {
        CWE retVal = (CWE)this.getTypedField(18, 0);
        return retVal;
    }

    public DTM getEffectiveDateTimeOfChange() {
        DTM retVal = (DTM)this.getTypedField(19, 0);
        return retVal;
    }

    public DTM getOm719_EffectiveDateTimeOfChange() {
        DTM retVal = (DTM)this.getTypedField(19, 0);
        return retVal;
    }

    public XCN getEnteredBy() {
        XCN retVal = (XCN)this.getTypedField(20, 0);
        return retVal;
    }

    public XCN getOm720_EnteredBy() {
        XCN retVal = (XCN)this.getTypedField(20, 0);
        return retVal;
    }

    public PL[] getOrderableAtLocation() {
        PL[] retVal = (PL[])this.getTypedField(21, new PL[0]);
        return retVal;
    }

    public PL[] getOm721_OrderableAtLocation() {
        PL[] retVal = (PL[])this.getTypedField(21, new PL[0]);
        return retVal;
    }

    public int getOrderableAtLocationReps() {
        return this.getReps(21);
    }

    public PL getOrderableAtLocation(int rep) {
        PL retVal = (PL)this.getTypedField(21, rep);
        return retVal;
    }

    public PL getOm721_OrderableAtLocation(int rep) {
        PL retVal = (PL)this.getTypedField(21, rep);
        return retVal;
    }

    public int getOm721_OrderableAtLocationReps() {
        return this.getReps(21);
    }

    public PL insertOrderableAtLocation(int rep) throws HL7Exception {
        return (PL)super.insertRepetition(21, rep);
    }

    public PL insertOm721_OrderableAtLocation(int rep) throws HL7Exception {
        return (PL)super.insertRepetition(21, rep);
    }

    public PL removeOrderableAtLocation(int rep) throws HL7Exception {
        return (PL)super.removeRepetition(21, rep);
    }

    public PL removeOm721_OrderableAtLocation(int rep) throws HL7Exception {
        return (PL)super.removeRepetition(21, rep);
    }

    public IS getFormularyStatus() {
        IS retVal = (IS)this.getTypedField(22, 0);
        return retVal;
    }

    public IS getOm722_FormularyStatus() {
        IS retVal = (IS)this.getTypedField(22, 0);
        return retVal;
    }

    public ID getSpecialOrderIndicator() {
        ID retVal = (ID)this.getTypedField(23, 0);
        return retVal;
    }

    public ID getOm723_SpecialOrderIndicator() {
        ID retVal = (ID)this.getTypedField(23, 0);
        return retVal;
    }

    public CWE[] getPrimaryKeyValueCDM() {
        CWE[] retVal = (CWE[])this.getTypedField(24, new CWE[0]);
        return retVal;
    }

    public CWE[] getOm724_PrimaryKeyValueCDM() {
        CWE[] retVal = (CWE[])this.getTypedField(24, new CWE[0]);
        return retVal;
    }

    public int getPrimaryKeyValueCDMReps() {
        return this.getReps(24);
    }

    public CWE getPrimaryKeyValueCDM(int rep) {
        CWE retVal = (CWE)this.getTypedField(24, rep);
        return retVal;
    }

    public CWE getOm724_PrimaryKeyValueCDM(int rep) {
        CWE retVal = (CWE)this.getTypedField(24, rep);
        return retVal;
    }

    public int getOm724_PrimaryKeyValueCDMReps() {
        return this.getReps(24);
    }

    public CWE insertPrimaryKeyValueCDM(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(24, rep);
    }

    public CWE insertOm724_PrimaryKeyValueCDM(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(24, rep);
    }

    public CWE removePrimaryKeyValueCDM(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(24, rep);
    }

    public CWE removeOm724_PrimaryKeyValueCDM(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(24, rep);
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new NM(this.getMessage());
            }
            case 1: {
                return new CWE(this.getMessage());
            }
            case 2: {
                return new CWE(this.getMessage());
            }
            case 3: {
                return new TX(this.getMessage());
            }
            case 4: {
                return new ST(this.getMessage());
            }
            case 5: {
                return new DTM(this.getMessage());
            }
            case 6: {
                return new DTM(this.getMessage());
            }
            case 7: {
                return new NM(this.getMessage());
            }
            case 8: {
                return new CWE(this.getMessage());
            }
            case 9: {
                return new IS(this.getMessage(), new Integer(0));
            }
            case 10: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 11: {
                return new CWE(this.getMessage());
            }
            case 12: {
                return new DTM(this.getMessage());
            }
            case 13: {
                return new DTM(this.getMessage());
            }
            case 14: {
                return new NM(this.getMessage());
            }
            case 15: {
                return new CWE(this.getMessage());
            }
            case 16: {
                return new NM(this.getMessage());
            }
            case 17: {
                return new CWE(this.getMessage());
            }
            case 18: {
                return new DTM(this.getMessage());
            }
            case 19: {
                return new XCN(this.getMessage());
            }
            case 20: {
                return new PL(this.getMessage());
            }
            case 21: {
                return new IS(this.getMessage(), new Integer(473));
            }
            case 22: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 23: {
                return new CWE(this.getMessage());
            }
        }
        return null;
    }
}

