/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v25.group.MFN_Znn_MF_SITE_DEFINED;
import ca.uhn.hl7v2.model.v25.segment.MFI;
import ca.uhn.hl7v2.model.v25.segment.MSH;
import ca.uhn.hl7v2.model.v25.segment.SFT;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class MFN_Znn
extends AbstractMessage {
    public MFN_Znn() {
        this(new DefaultModelClassFactory());
    }

    public MFN_Znn(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(MFI.class, true, false);
            this.add(MFN_Znn_MF_SITE_DEFINED.class, true, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating MFN_Znn - this is probably a bug in the source code generator.", e);
        }
    }

    @Override
    public String getVersion() {
        return "2.5";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public MFI getMFI() {
        return this.getTyped("MFI", MFI.class);
    }

    public MFN_Znn_MF_SITE_DEFINED getMF_SITE_DEFINED() {
        return this.getTyped("MF_SITE_DEFINED", MFN_Znn_MF_SITE_DEFINED.class);
    }

    public MFN_Znn_MF_SITE_DEFINED getMF_SITE_DEFINED(int rep) {
        return this.getTyped("MF_SITE_DEFINED", rep, MFN_Znn_MF_SITE_DEFINED.class);
    }

    public int getMF_SITE_DEFINEDReps() {
        return this.getReps("MF_SITE_DEFINED");
    }

    public List<MFN_Znn_MF_SITE_DEFINED> getMF_SITE_DEFINEDAll() throws HL7Exception {
        return this.getAllAsList("MF_SITE_DEFINED", MFN_Znn_MF_SITE_DEFINED.class);
    }

    public void insertMF_SITE_DEFINED(MFN_Znn_MF_SITE_DEFINED structure, int rep) throws HL7Exception {
        super.insertRepetition("MF_SITE_DEFINED", structure, rep);
    }

    public MFN_Znn_MF_SITE_DEFINED insertMF_SITE_DEFINED(int rep) throws HL7Exception {
        return (MFN_Znn_MF_SITE_DEFINED)super.insertRepetition("MF_SITE_DEFINED", rep);
    }

    public MFN_Znn_MF_SITE_DEFINED removeMF_SITE_DEFINED(int rep) throws HL7Exception {
        return (MFN_Znn_MF_SITE_DEFINED)super.removeRepetition("MF_SITE_DEFINED", rep);
    }
}

