/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v23.datatype.CE;
import ca.uhn.hl7v2.model.v23.datatype.ID;
import ca.uhn.hl7v2.model.v23.datatype.ST;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class ODS
extends AbstractSegment {
    public ODS(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ID.class, true, 1, 1, new Object[]{this.getMessage(), new Integer(159)}, "Type");
            this.add(CE.class, false, 10, 60, new Object[]{this.getMessage()}, "Service Period");
            this.add(CE.class, true, 20, 60, new Object[]{this.getMessage()}, "Diet, Supplement, or Preference Code");
            this.add(ST.class, false, 1, 80, new Object[]{this.getMessage()}, "Text Instruction");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating ODS - this is probably a bug in the source code generator.", e);
        }
    }

    public ID getType() {
        ID retVal = (ID)this.getTypedField(1, 0);
        return retVal;
    }

    public ID getOds1_Type() {
        ID retVal = (ID)this.getTypedField(1, 0);
        return retVal;
    }

    public CE[] getServicePeriod() {
        CE[] retVal = (CE[])this.getTypedField(2, new CE[0]);
        return retVal;
    }

    public CE[] getOds2_ServicePeriod() {
        CE[] retVal = (CE[])this.getTypedField(2, new CE[0]);
        return retVal;
    }

    public int getServicePeriodReps() {
        return this.getReps(2);
    }

    public CE getServicePeriod(int rep) {
        CE retVal = (CE)this.getTypedField(2, rep);
        return retVal;
    }

    public CE getOds2_ServicePeriod(int rep) {
        CE retVal = (CE)this.getTypedField(2, rep);
        return retVal;
    }

    public int getOds2_ServicePeriodReps() {
        return this.getReps(2);
    }

    public CE insertServicePeriod(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(2, rep);
    }

    public CE insertOds2_ServicePeriod(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(2, rep);
    }

    public CE removeServicePeriod(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(2, rep);
    }

    public CE removeOds2_ServicePeriod(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(2, rep);
    }

    public CE[] getDietSupplementOrPreferenceCode() {
        CE[] retVal = (CE[])this.getTypedField(3, new CE[0]);
        return retVal;
    }

    public CE[] getOds3_DietSupplementOrPreferenceCode() {
        CE[] retVal = (CE[])this.getTypedField(3, new CE[0]);
        return retVal;
    }

    public int getDietSupplementOrPreferenceCodeReps() {
        return this.getReps(3);
    }

    public CE getDietSupplementOrPreferenceCode(int rep) {
        CE retVal = (CE)this.getTypedField(3, rep);
        return retVal;
    }

    public CE getOds3_DietSupplementOrPreferenceCode(int rep) {
        CE retVal = (CE)this.getTypedField(3, rep);
        return retVal;
    }

    public int getOds3_DietSupplementOrPreferenceCodeReps() {
        return this.getReps(3);
    }

    public CE insertDietSupplementOrPreferenceCode(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(3, rep);
    }

    public CE insertOds3_DietSupplementOrPreferenceCode(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(3, rep);
    }

    public CE removeDietSupplementOrPreferenceCode(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(3, rep);
    }

    public CE removeOds3_DietSupplementOrPreferenceCode(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(3, rep);
    }

    public ST getTextInstruction() {
        ST retVal = (ST)this.getTypedField(4, 0);
        return retVal;
    }

    public ST getOds4_TextInstruction() {
        ST retVal = (ST)this.getTypedField(4, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new ID(this.getMessage(), new Integer(159));
            }
            case 1: {
                return new CE(this.getMessage());
            }
            case 2: {
                return new CE(this.getMessage());
            }
            case 3: {
                return new ST(this.getMessage());
            }
        }
        return null;
    }
}

