/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v23.group.CRM_C05_PATIENT;
import ca.uhn.hl7v2.model.v23.segment.MSH;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class CRM_C05
extends AbstractMessage {
    public CRM_C05() {
        this(new DefaultModelClassFactory());
    }

    public CRM_C05(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(CRM_C05_PATIENT.class, true, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating CRM_C05 - this is probably a bug in the source code generator.", e);
        }
    }

    @Override
    public String getVersion() {
        return "2.3";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public CRM_C05_PATIENT getPATIENT() {
        return this.getTyped("PATIENT", CRM_C05_PATIENT.class);
    }

    public CRM_C05_PATIENT getPATIENT(int rep) {
        return this.getTyped("PATIENT", rep, CRM_C05_PATIENT.class);
    }

    public int getPATIENTReps() {
        return this.getReps("PATIENT");
    }

    public List<CRM_C05_PATIENT> getPATIENTAll() throws HL7Exception {
        return this.getAllAsList("PATIENT", CRM_C05_PATIENT.class);
    }

    public void insertPATIENT(CRM_C05_PATIENT structure, int rep) throws HL7Exception {
        super.insertRepetition("PATIENT", structure, rep);
    }

    public CRM_C05_PATIENT insertPATIENT(int rep) throws HL7Exception {
        return (CRM_C05_PATIENT)super.insertRepetition("PATIENT", rep);
    }

    public CRM_C05_PATIENT removePATIENT(int rep) throws HL7Exception {
        return (CRM_C05_PATIENT)super.removeRepetition("PATIENT", rep);
    }
}

