/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.readhl7;

import ca.infodata.readhl7.DataTypeUtils;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.time.DateFormatUtils;

public final class DateUtils {
    private static final Logger logger = Logger.getLogger(DataTypeUtils.class.getName());
    private static SimpleDateFormat sdf;
    private static String formatDate;

    public static String getISODateTimeFormatNoT(Calendar cal) {
        return DateFormatUtils.ISO_DATETIME_FORMAT.format(cal).replace('T', ' ');
    }

    public static SimpleDateFormat getDateFormatter() {
        if (sdf == null) {
            sdf = new SimpleDateFormat(formatDate);
        }
        return sdf;
    }

    public static void setDateFormatter(String pattern) {
        sdf = new SimpleDateFormat(pattern);
    }

    public static String getDate() {
        Date date = new Date();
        return DateFormat.getDateInstance().format(date);
    }

    public static String getDate(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat();
        return sdf.format(date);
    }

    public static String getDate(Date date, String format, Locale locale) {
        SimpleDateFormat sdf = new SimpleDateFormat(format, locale);
        return sdf.format(date);
    }

    public static String getDate(Date date, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(date);
    }

    public static String getDateTime() {
        Date date = new Date();
        return DateFormat.getDateTimeInstance().format(date);
    }

    public static String formatDate(String date, String format, String formatAtual) {
        try {
            DateUtils.setDateFormatter(formatAtual);
            Date data = DateUtils.getDateFormatter().parse(date);
            logger.log(Level.FINE, "[DateUtils] - formatDate: data formatada: " + DateUtils.getDateFormatter().format(data));
            DateUtils.setDateFormatter(format);
            return DateUtils.getDateFormatter().format(data);
        }
        catch (ParseException e) {
            logger.log(Level.SEVERE, "[DateUtils] - formatDate: ", e);
            return "";
        }
    }

    public static String formatDate(String date, String format) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat();
            Date data = sdf.parse(date);
            logger.log(Level.FINE, "[DateUtils] - formatDate: data formatada: " + sdf.format(data));
            DateUtils.setDateFormatter(format);
            return DateUtils.getDateFormatter().format(data);
        }
        catch (ParseException e) {
            logger.log(Level.SEVERE, "[DateUtils] - formatDate: ", e);
            return "";
        }
    }

    public static String sumDate(String format, String pSum) {
        int iSum = new Integer(pSum);
        logger.log(Level.FINE, "[DateUtils] - sumDate: iSum = " + iSum);
        GregorianCalendar calendar = new GregorianCalendar();
        Date now = new Date();
        calendar.setTime(now);
        ((Calendar)calendar).add(5, iSum);
        Date data = calendar.getTime();
        DateUtils.setDateFormatter(format);
        return DateUtils.getDateFormatter().format(data);
    }

    public String NextDay(int day, int month, int year) {
        switch (month) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: {
                if (day < 31) {
                    ++day;
                    break;
                }
                day = 1;
                ++month;
                break;
            }
            case 12: {
                if (day < 31) {
                    ++day;
                    break;
                }
                day = 1;
                month = 1;
                ++year;
                break;
            }
            case 2: {
                if (day < 28) {
                    ++day;
                    break;
                }
                boolean leapyear = year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
                if (leapyear) {
                    if (day == 28) {
                        ++day;
                        break;
                    }
                    day = 1;
                    ++month;
                    break;
                }
                day = 1;
                ++month;
                break;
            }
            default: {
                if (day < 30) {
                    ++day;
                    break;
                }
                day = 1;
                ++month;
            }
        }
        String nextDay = year + "-" + month + "-" + day;
        return nextDay;
    }

    public String NextDay(int day, int month, int year, int numDays) {
        int modValue = 28;
        while (numDays > 0) {
            int curNumDays = numDays % 28;
            if (curNumDays == 0) {
                curNumDays = 28;
            }
            switch (month) {
                case 1: 
                case 3: 
                case 5: 
                case 7: 
                case 8: 
                case 10: {
                    if (day + curNumDays < 31) {
                        day += curNumDays;
                        break;
                    }
                    if ((day + curNumDays) % 31 == 0) {
                        day = 31;
                        break;
                    }
                    day = (day + curNumDays) % 31;
                    ++month;
                    break;
                }
                case 12: {
                    if (day + curNumDays < 31) {
                        day += curNumDays;
                        break;
                    }
                    if ((day + curNumDays) % 31 == 0) {
                        day = 31;
                        break;
                    }
                    day = (day + curNumDays) % 31;
                    month = 1;
                    ++year;
                    break;
                }
                case 2: {
                    if (year % 4 == 0 && year % 100 != 0 || year % 400 == 0) {
                        if (day + curNumDays < 29) {
                            day += curNumDays;
                            break;
                        }
                        if ((day + curNumDays) % 29 == 0) {
                            day = 29;
                            break;
                        }
                        day = (day + curNumDays) % 29;
                        ++month;
                        break;
                    }
                    if (day + curNumDays < 28) {
                        day += curNumDays;
                        break;
                    }
                    if ((day + curNumDays) % 28 == 0) {
                        day = 28;
                        break;
                    }
                    day = (day + curNumDays) % 28;
                    ++month;
                    break;
                }
                default: {
                    if (day + curNumDays < 30) {
                        day += curNumDays;
                        break;
                    }
                    if ((day + curNumDays) % 30 == 0) {
                        day = 30;
                        break;
                    }
                    day = (day + curNumDays) % 30;
                    ++month;
                }
            }
            numDays -= curNumDays;
        }
        String nextDay = year + "-" + month + "-" + day;
        return nextDay;
    }

    public static long getDifDays(Date greater, Date lesser) {
        long timeInMillis = greater.getTime() - lesser.getTime();
        return timeInMillis / 86400000L;
    }

    public static long getNumberOfDaysBetweenTwoDates(Calendar cal1, Calendar cal2) {
        long timeInMillis = Math.abs(cal1.getTimeInMillis() - cal2.getTimeInMillis());
        return timeInMillis / 86400000L;
    }

    public static long getNumberOfDaysBetweenTwoDates(Date date1, Date date2) {
        long timeInMillis = Math.abs(date1.getTime() - date2.getTime());
        return timeInMillis / 86400000L;
    }

    public static String convertDate8Char(String oldDateString) {
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd");
        String sdate = "00000000";
        try {
            if (oldDateString != null) {
                Date tempDate = fmt.parse(oldDateString);
                sdate = new SimpleDateFormat("yyyyMMdd").format(tempDate);
            }
        }
        catch (ParseException ex) {
            logger.log(Level.SEVERE, "Error", ex);
        }
        return sdate;
    }

    public static GregorianCalendar toGregorianCalendarDate(String isoDateString) {
        if (isoDateString == null) {
            return null;
        }
        try {
            String[] split = isoDateString.split("-");
            int year = Integer.parseInt(split[0]);
            int month = Integer.parseInt(split[1]) - 1;
            int day = Integer.parseInt(split[2]);
            return new GregorianCalendar(year, month, day);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("The passed in string is not a valid ISO date");
        }
    }

    public static Date toDate(String isoDateString) {
        GregorianCalendar cal = DateUtils.toGregorianCalendarDate(isoDateString);
        if (cal != null) {
            return cal.getTime();
        }
        return null;
    }

    public static Integer yearDifference(Date date1, Date date2) {
        if (date1 == null || date2 == null) {
            return null;
        }
        GregorianCalendar cal1 = new GregorianCalendar();
        cal1.setTime(date1);
        GregorianCalendar cal2 = new GregorianCalendar();
        cal2.setTime(date2);
        return DateUtils.yearDifference(cal1, cal2);
    }

    public static Integer yearDifference(Calendar date1, Calendar date2) {
        if (date1 == null || date2 == null) {
            return null;
        }
        int yearDiff = date2.get(1) - date1.get(1);
        if (date2.get(6) > date1.get(6)) {
            --yearDiff;
        }
        return yearDiff;
    }

    public static Integer getAge(Calendar dateOfBirth, Calendar onThisDay) {
        return DateUtils.yearDifference(dateOfBirth, onThisDay);
    }

    public static Integer calculateDayDifference(Calendar date1, Calendar date2) {
        if (date1 == null || date2 == null) {
            return null;
        }
        long ms = date2.getTimeInMillis() - date1.getTimeInMillis();
        return (int)(ms / 86400000L);
    }

    public static Integer calculateDayDifference(Date date1, Date date2) {
        if (date1 == null || date2 == null) {
            return null;
        }
        GregorianCalendar cal1 = new GregorianCalendar();
        cal1.setTime(date1);
        GregorianCalendar cal2 = new GregorianCalendar();
        cal2.setTime(date2);
        return DateUtils.calculateDayDifference(cal1, cal2);
    }

    static {
        formatDate = "yyyy-mm-dd";
    }
}

