/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.readhl7;

import ca.infodata.readhl7.DateUtils;
import ca.infodata.readhl7.Gender;
import ca.infodata.readhl7.MessageHandler;
import ca.infodata.readhl7.tools.DataTypeUtils;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.v24.datatype.TS;
import ca.uhn.hl7v2.model.v24.segment.MSH;
import ca.uhn.hl7v2.model.v24.segment.PID;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class ChainnedMessageAdapter<T extends AbstractMessage>
implements MessageHandler {
    private static final Logger logger = Logger.getLogger(ChainnedMessageAdapter.class.getName());
    protected T hl7Message;

    @Override
    public void init(String hl7Body) throws HL7Exception {
        throw new UnsupportedOperationException("Don't use this method, use init(Message) instead.");
    }

    public ChainnedMessageAdapter(T hl7Message) {
        this.hl7Message = hl7Message;
    }

    public abstract MSH getMsh();

    public abstract PID getPid();

    public String getMessageStructureType() {
        return this.getMsh().getMessageType().getMessageStructure().getValue();
    }

    @Override
    public String getMsgType() {
        return "OSCAR_TO_OSCAR_HL7_V2";
    }

    @Override
    public String getMsgDate() {
        try {
            TS dtm = this.getMsh().getDateTimeOfMessage();
            GregorianCalendar cal = DataTypeUtils.getCalendarFromDTM(dtm);
            return this.getISODateTimeFormatNoT(cal);
        }
        catch (DataTypeException e) {
            logger.log(Level.SEVERE, "Unexpected error.", e);
            return null;
        }
    }

    @Override
    public String getMsgPriority() {
        return "";
    }

    @Override
    public int getOBRCount() {
        return 0;
    }

    @Override
    public int getOBXCount(int i) {
        return 0;
    }

    @Override
    public String getOBRName(int i) {
        return null;
    }

    @Override
    public String getTimeStamp(int i, int j) {
        return null;
    }

    @Override
    public boolean isOBXAbnormal(int i, int j) {
        return false;
    }

    @Override
    public String getOBXAbnormalFlag(int i, int j) {
        return null;
    }

    @Override
    public String getObservationHeader(int i, int j) {
        return this.getMessageStructureType();
    }

    @Override
    public String getOBXIdentifier(int i, int j) {
        return null;
    }

    @Override
    public String getOBXValueType(int i, int j) {
        return null;
    }

    @Override
    public String getOBXName(int i, int j) {
        return null;
    }

    @Override
    public String getOBXResult(int i, int j) {
        return null;
    }

    @Override
    public String getOBXReferenceRange(int i, int j) {
        return null;
    }

    @Override
    public String getOBXUnits(int i, int j) {
        return null;
    }

    @Override
    public String getOBXResultStatus(int i, int j) {
        return null;
    }

    @Override
    public List<String> getHeaders() {
        ArrayList<String> headers = new ArrayList<String>();
        headers.add(this.getMessageStructureType());
        return headers;
    }

    @Override
    public int getOBRCommentCount(int i) {
        return 0;
    }

    @Override
    public String getOBRComment(int i, int j) {
        return null;
    }

    @Override
    public int getOBXCommentCount(int i, int j) {
        return 0;
    }

    @Override
    public String getOBXComment(int i, int j, int k) {
        return null;
    }

    @Override
    public String getPatientName() {
        return this.getFirstName() + ' ' + this.getLastName();
    }

    @Override
    public String getFirstName() {
        return this.getPid().getPatientName()[0].getGivenName().getValue();
    }

    @Override
    public String getLastName() {
        return this.getPid().getPatientName()[0].getFamilyName().getSurname().getValue();
    }

    @Override
    public String getDOB() {
        try {
            TS dtm = this.getPid().getDateTimeOfBirth();
            GregorianCalendar cal = DataTypeUtils.getCalendarFromDTM(dtm);
            if (cal == null) {
                return null;
            }
            return this.getISODateTimeFormatNoT(cal);
        }
        catch (DataTypeException e) {
            logger.log(Level.SEVERE, "Unexpected Error.", e);
            return null;
        }
    }

    @Override
    public String getAge() {
        try {
            TS dtm = this.getPid().getDateTimeOfBirth();
            GregorianCalendar cal = DataTypeUtils.getCalendarFromDTM(dtm);
            if (cal == null) {
                return null;
            }
            int age = DateUtils.getAge(cal, new GregorianCalendar());
            return String.valueOf(age);
        }
        catch (DataTypeException e) {
            logger.log(Level.SEVERE, "Unexpected Error.", e);
            return null;
        }
    }

    @Override
    public String getSex() {
        String hl7Gender = this.getPid().getAdministrativeSex().getValue();
        Gender oscarGender = DataTypeUtils.getOscarGenderFromHl7Gender(hl7Gender);
        if (oscarGender == null) {
            return null;
        }
        return oscarGender.name();
    }

    @Override
    public String getHealthNum() {
        return this.getPid().getPatientIdentifierList(0).getID().getValue();
    }

    @Override
    public String getHomePhone() {
        return this.getPid().getPhoneNumberHome(0).getPhoneNumber().getValue();
    }

    @Override
    public String getWorkPhone() {
        return null;
    }

    @Override
    public String getPatientLocation() {
        return this.getMsh().getSendingFacility().getNamespaceID().getValue();
    }

    @Override
    public String getServiceDate() {
        return null;
    }

    @Override
    public String getOrderStatus() {
        return "F";
    }

    @Override
    public int getOBXFinalResultCount() {
        return 0;
    }

    @Override
    public String getClientRef() {
        return null;
    }

    @Override
    public String getAccessionNum() {
        return null;
    }

    @Override
    public abstract String getDocName();

    @Override
    public String getCCDocs() {
        return null;
    }

    @Override
    public ArrayList<String> getDocNums() {
        return null;
    }

    @Override
    public String audit() {
        return "";
    }

    private String getISODateTimeFormatNoT(GregorianCalendar dtm) {
        if (dtm.getTime().getYear() == 0 || dtm.getTime().getMonth() == 0 || dtm.getTime().getDay() == 0) {
            return null;
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeInMillis(0L);
        cal.set(1, dtm.getTime().getYear());
        cal.set(2, dtm.getTime().getMonth() - 1);
        cal.set(5, dtm.getTime().getDay());
        cal.set(11, dtm.getTime().getHours());
        cal.set(12, dtm.getTime().getMinutes());
        cal.set(13, dtm.getTime().getSeconds());
        cal.getTimeInMillis();
        return cal.toString();
    }
}

