/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.scan.singleview;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.AppointmentAccessorClient;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.callback.JobCallback;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XCompletionProposalType;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointment;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XPatientStatus;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.scan.XPatientImage;
import ca.infodata.ofys.data.middle.dataobjects.scan.XPatientImageProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.scan.XPatientImageProfessionnalStatus;
import ca.infodata.ofys.ui.controls.BaseEditor;
import ca.infodata.ofys.ui.controls.ControlDecorator;
import ca.infodata.ofys.ui.controls.ControlsPlugin;
import ca.infodata.ofys.ui.controls.EditorModifyListener;
import ca.infodata.ofys.ui.controls.IBaseEditor;
import ca.infodata.ofys.ui.controls.IBaseEditor2;
import ca.infodata.ofys.ui.controls.IProposalListener;
import ca.infodata.ofys.ui.controls.form.MyButton;
import ca.infodata.ofys.ui.controls.template.completion.TemplateAssistText;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.scan.singleview.BaseScanSingleViewSection;
import ca.infodata.ofys.ui.scan.singleview.XAppointmentFormatter;
import ca.infodata.util1.date.DateUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class NoteSection
extends BaseScanSingleViewSection {
    private static final Logger logger = Logger.getLogger(NoteSection.class.getName());
    private static final String A_REGLER = Messages.getString((String)"BaseScanEditor.A_REGLER", (String[])new String[0]);
    private static final String NOTE_HISTORIC = String.valueOf(Messages.getString((String)"NOTES", (String[])new String[0])) + " - " + Messages.getString((String)"BaseScanEditor.PROCHAIN_RDVS", (String[])new String[0]);
    private static final String OPEN_WITH_FILE = Messages.getString((String)"OPEN_WITH_FILE", (String[])new String[0]);
    private static final String OPEN_WITH_FILE_TTT = Messages.getString((String)"OPEN_WITH_FILE_TTT", (String[])new String[0]);
    private static final String SIGNER = Messages.getString((String)"BaseScanEditor.SIGNER", (String[])new String[0]);
    private static final String SIGNE_RETIRE_RESULTAT_LISTE = Messages.getString((String)"BaseScanEditor.SIGNE_RETIRE_RESULTAT_LISTE", (String[])new String[0]);
    private static final Pattern patternStringToExtract = Pattern.compile("~(.*?)~");
    private static final Pattern patternNormalStart = Pattern.compile("([<][p][>])");
    private static final Pattern patternNormalEnd = Pattern.compile("([<][/][p][>])");
    private static final Pattern patternBoldNormalStart = Pattern.compile("([<][b][p][>])");
    private static final Pattern patternBoldNormalEnd = Pattern.compile("([<][/][b][p][>])");
    private static final Pattern patternItalicStart = Pattern.compile("([<][i][>])");
    private static final Pattern patternItalicEnd = Pattern.compile("([<][/][i][>])");
    private static final Pattern patternBoldItalicStart = Pattern.compile("([<][b][i][>])");
    private static final Pattern patternBoldItalicEnd = Pattern.compile("([<][/][b][i][>])");
    private Font fontArial;
    private Font fontArialBold;
    private Font fontTimesItalique;
    private Font fontTimesBoldItalique;
    private Color black;
    protected IProposalListener proposalListener;
    protected IProposalListener proposalListenerNote;
    private FormToolkit toolkit;
    private Section section;
    private BaseEditor editor;
    protected SourceViewer viewerNotesAndHistoric;
    protected TemplateAssistText txtNote;
    protected Composite compNote;
    protected MyButton chkToResolve;
    protected MyButton chkOpenWithFile;
    protected MyButton cmdSign;
    protected String initialNote;

    public NoteSection(BaseEditor editor, Composite parent, FormToolkit toolkit) {
        this.editor = editor;
        this.toolkit = toolkit;
        this.section = toolkit.createSection(parent, 66);
        this.section.setText(NOTE_HISTORIC);
        this.toolkit.createCompositeSeparator((Composite)this.section);
        this.compNote = this.toolkit.createComposite((Composite)this.section, 0);
        this.section.setClient((Control)this.compNote);
        this.txtNote = new TemplateAssistText(this.compNote, 2626, this.toolkit);
        this.txtNote.setType(XCompletionProposalType.SCAN_NOTE);
        ControlDecorator.decorateWithEditProposal((TemplateAssistText)this.txtNote, (int)16512);
        this.cmdSign = new MyButton(this.compNote, SIGNER, 8, this.toolkit);
        this.cmdSign.setToolTipText(SIGNE_RETIRE_RESULTAT_LISTE);
        this.chkToResolve = new MyButton(this.compNote, A_REGLER, 32, this.toolkit);
        this.chkOpenWithFile = new MyButton(this.compNote, OPEN_WITH_FILE, 32, this.toolkit);
        this.chkOpenWithFile.setToolTipText(OPEN_WITH_FILE_TTT);
        this.viewerNotesAndHistoric = new SourceViewer(this.compNote, null, 2626);
        this.viewerNotesAndHistoric.setEditable(false);
        this.fontArial = ResourceGetter.getFont((String)"Arial", (int)12, (int)0, (boolean)true);
        this.fontArialBold = ResourceGetter.getFont((String)"Arial", (int)12, (int)1, (boolean)true);
        this.fontTimesItalique = ResourceGetter.getFont((String)"Times", (int)12, (int)2, (boolean)true);
        this.fontTimesBoldItalique = ResourceGetter.getFont((String)"Times", (int)12, (int)3, (boolean)true);
        this.black = ResourceGetter.getColor((int)0, (int)0, (int)0);
        ResourceGetter.linkResourceWithWidgetLife((Object)this.fontArial, (Widget)this.section);
        ResourceGetter.linkResourceWithWidgetLife((Object)this.fontArialBold, (Widget)this.section);
        ResourceGetter.linkResourceWithWidgetLife((Object)this.fontTimesItalique, (Widget)this.section);
        ResourceGetter.linkResourceWithWidgetLife((Object)this.fontTimesBoldItalique, (Widget)this.section);
        ResourceGetter.linkResourceWithWidgetLife((Object)this.black, (Widget)this.section);
        Point ptOpen = this.chkOpenWithFile.getControl().computeSize(-1, -1);
        Point ptRegler = this.chkToResolve.getControl().computeSize(-1, -1);
        Point ptSign = this.cmdSign.getControl().computeSize(-1, -1);
        FormLayout layout = new FormLayout();
        layout.spacing = 2;
        this.compNote.setLayout((Layout)layout);
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(50, -100);
        data.bottom = new FormAttachment(100);
        this.txtNote.getControl().setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(this.txtNote.getControl(), 3);
        data.width = ptOpen.x;
        data.height = ptSign.y;
        this.cmdSign.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.cmdSign.getControl(), 0);
        data.left = new FormAttachment(this.txtNote.getControl(), 3);
        data.right = new FormAttachment(this.cmdSign.getControl(), 0, 131072);
        data.height = ptRegler.y;
        this.chkToResolve.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.chkToResolve.getControl(), 0);
        data.left = new FormAttachment(this.txtNote.getControl(), 3);
        data.right = new FormAttachment(this.cmdSign.getControl(), 0, 131072);
        data.height = ptOpen.y;
        this.chkOpenWithFile.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(this.cmdSign.getControl(), 3);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(100, 0);
        this.viewerNotesAndHistoric.getControl().setLayoutData((Object)data);
        this.txtNote.getStyledText().addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (StringUtils.isNotBlank((CharSequence)NoteSection.this.initialNote)) {
                    e.doit = e.start >= NoteSection.this.initialNote.length();
                }
            }
        });
        this.txtNote.getStyledText().addModifyListener((ModifyListener)new EditorModifyListener((IBaseEditor2)this.getEditor()){

            public void edited(Event e) {
                XPatientImageProfessionnal s = NoteSection.this.getSessionProfessionnalPatientImageProfessionnal();
                if (s != null) {
                    s.setNote(NoteSection.this.txtNote.getText());
                }
            }
        });
        this.chkToResolve.addSelectionListener((SelectionListener)new EditorModifyListener((IBaseEditor2)this.getEditor()){

            public void edited(Event e) {
                XPatientImageProfessionnal s = NoteSection.this.getSessionProfessionnalPatientImageProfessionnal();
                if (s != null) {
                    if (NoteSection.this.chkToResolve.getSelection()) {
                        s.addXPatientImageProfessionnalStatus(XPatientImageProfessionnalStatus.TO_RESOLVE);
                    } else {
                        s.removeXPatientImageProfessionnalStatus(XPatientImageProfessionnalStatus.TO_RESOLVE);
                    }
                }
            }
        });
        this.chkOpenWithFile.addSelectionListener((SelectionListener)new EditorModifyListener((IBaseEditor2)this.getEditor()){

            public void edited(Event e) {
                XPatientImageProfessionnal s = NoteSection.this.getSessionProfessionnalPatientImageProfessionnal();
                if (s != null) {
                    if (NoteSection.this.chkOpenWithFile.getSelection()) {
                        s.addXPatientImageProfessionnalStatus(XPatientImageProfessionnalStatus.OPEN_WITH_FILE);
                    } else {
                        s.removeXPatientImageProfessionnalStatus(XPatientImageProfessionnalStatus.OPEN_WITH_FILE);
                    }
                }
            }
        });
        this.cmdSign.addSelectionListener((SelectionListener)new EditorModifyListener((IBaseEditor2)this.getEditor(), 13){

            public void edited(Event e) {
                XPatientImageProfessionnal pip = NoteSection.this.getSessionProfessionnalPatientImageProfessionnal();
                if (pip != null) {
                    pip.setSignedDatetime(Long.valueOf(DateUtil.nowUTC()));
                    NoteSection.this.getEditor().doSave(null);
                }
            }
        });
    }

    @Override
    public void showDataObject() {
        XPatientImage patientImage = this.getPatientImage();
        if (patientImage == null) {
            this.txtNote.setText(null);
            this.txtNote.setEnabled(false);
            this.cmdSign.setEnabled(false);
            this.chkToResolve.setSelection(false);
            this.chkToResolve.setEnabled(false);
            this.chkOpenWithFile.setSelection(false);
            this.chkOpenWithFile.setEnabled(false);
            this.viewerNotesAndHistoric.setDocument(null);
        } else {
            this.section.setText(String.valueOf(NOTE_HISTORIC) + " ...");
            this.showFuturAppointments(this.getPatient(), this.section);
            XPatientImageProfessionnal pip = this.getSessionProfessionnalPatientImageProfessionnal();
            if (pip == null) {
                this.txtNote.setText(null);
                this.chkToResolve.setSelection(false);
                this.txtNote.setEnabled(false);
                this.chkToResolve.setEnabled(false);
                this.chkOpenWithFile.setEnabled(false);
                this.cmdSign.setEnabled(false);
            } else {
                this.txtNote.setEnabled(true);
                this.chkToResolve.setEnabled(true);
                this.chkToResolve.setSelection(pip.getStatus().contains(XPatientImageProfessionnalStatus.TO_RESOLVE));
                this.chkOpenWithFile.setEnabled(true);
                this.chkOpenWithFile.setSelection(pip.getStatus().contains(XPatientImageProfessionnalStatus.OPEN_WITH_FILE));
                this.txtNote.setText(pip.getNote());
                this.cmdSign.setEnabled(pip.getSignedDatetime() == null);
            }
            String texte = patientImage.notesHistory;
            Matcher matcher = patternStringToExtract.matcher(texte);
            while (matcher.find()) {
                String extractedStringKey = matcher.group(1);
                texte = StringUtils.replace((String)texte, (String)("~" + extractedStringKey + "~"), (String)Messages.getString((String)extractedStringKey, (String[])new String[0]));
            }
            try {
                StringBuilder newTexte = new StringBuilder();
                TextStyle style = new TextStyle();
                ArrayList<StyleRange> l = new ArrayList<StyleRange>();
                int newStart = 0;
                Matcher mns = patternNormalStart.matcher(texte);
                Matcher mne = patternNormalEnd.matcher(texte);
                Matcher mbns = patternBoldNormalStart.matcher(texte);
                Matcher mbne = patternBoldNormalEnd.matcher(texte);
                Matcher mis = patternItalicStart.matcher(texte);
                Matcher mie = patternItalicEnd.matcher(texte);
                Matcher mbis = patternBoldItalicStart.matcher(texte);
                Matcher mbie = patternBoldItalicEnd.matcher(texte);
                StyleRange sra = new StyleRange(style);
                int lastSrEnd = 0;
                HashMap<Integer, String> mapText = new HashMap<Integer, String>();
                HashMap<Integer, Font> mapFont = new HashMap<Integer, Font>();
                String temp = "";
                while (mns.find(newStart)) {
                    mne.find(newStart);
                    temp = texte.substring(mns.end(), mne.start());
                    mapText.put(new Integer(mne.start()), temp);
                    mapFont.put(new Integer(mne.start()), this.fontArial);
                    newStart = mne.end();
                }
                newStart = 0;
                while (mbns.find(newStart)) {
                    mbne.find(newStart);
                    temp = texte.substring(mbns.end(), mbne.start());
                    mapText.put(new Integer(mbne.start()), temp);
                    mapFont.put(new Integer(mbne.start()), this.fontArialBold);
                    newStart = mbne.end();
                }
                newStart = 0;
                while (mis.find(newStart)) {
                    mie.find(newStart);
                    temp = texte.substring(mis.end(), mie.start());
                    mapText.put(new Integer(mie.start()), temp);
                    mapFont.put(new Integer(mie.start()), this.fontTimesItalique);
                    newStart = mie.end();
                }
                newStart = 0;
                while (mbis.find(newStart)) {
                    mbie.find(newStart);
                    temp = texte.substring(mbis.end(), mbie.start());
                    mapText.put(new Integer(mbie.start()), temp);
                    mapFont.put(new Integer(mbie.start()), this.fontTimesBoldItalique);
                    newStart = mbie.end();
                }
                ArrayList keys = new ArrayList(mapText.keySet());
                Collections.sort(keys);
                for (Integer ii : keys) {
                    temp = (String)mapText.get(ii);
                    newTexte.append(String.valueOf(temp) + "\n");
                    sra = new StyleRange(lastSrEnd, newTexte.length() - lastSrEnd, this.black, null);
                    sra.font = (Font)mapFont.get(ii);
                    l.add(sra);
                    lastSrEnd = newTexte.length();
                }
                StyleRange[] srs = new StyleRange[l.size()];
                int i = 0;
                Iterator iterator = l.iterator();
                while (iterator.hasNext()) {
                    StyleRange sr1;
                    srs[i] = sr1 = (StyleRange)iterator.next();
                    ++i;
                }
                Document doc = new Document(newTexte.toString());
                this.viewerNotesAndHistoric.setDocument((IDocument)doc);
                this.viewerNotesAndHistoric.getTextWidget().setStyleRanges(srs);
            }
            catch (Exception e) {
                Document doc = new Document(texte);
                this.viewerNotesAndHistoric.setDocument((IDocument)doc);
                this.viewerNotesAndHistoric.getTextWidget().setStyleRanges(null);
                logger.log(Level.SEVERE, "ERREUR", e);
            }
        }
    }

    private void showFuturAppointments(IPatient patient, final Section section) {
        block6: {
            if (patient != null && patient.getId() != null) {
                JobCallback callback = new JobCallback(Messages.getString((String)"RECHERCHE", (String[])new String[0]), ControlsPlugin.getDefaultStatusHandler()){

                    public void responseReceived(final ReturnObject response) {
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (!section.isDisposed()) {
                                    if (response == null || response.getObj() == null) {
                                        section.setText(String.valueOf(NOTE_HISTORIC) + Messages.getString((String)"Print.AUCUN", (String[])new String[0]));
                                    } else {
                                        List appointments = (List)response.getObj();
                                        if (appointments == null) {
                                            section.setText(String.valueOf(NOTE_HISTORIC) + Messages.getString((String)"Print.AUCUN", (String[])new String[0]));
                                        } else {
                                            Iterator iterator = appointments.iterator();
                                            while (iterator.hasNext()) {
                                                XAppointment a = (XAppointment)iterator.next();
                                                if (!Boolean.TRUE.equals(a.getIsDeleted()) && a.getPatientStatus() != XPatientStatus.CANCEL && a.getPatientStatus() != XPatientStatus.CANCEL_LESS_24H) continue;
                                                iterator.remove();
                                            }
                                            if (appointments.isEmpty()) {
                                                section.setText(String.valueOf(NOTE_HISTORIC) + Messages.getString((String)"Print.AUCUN", (String[])new String[0]));
                                            } else {
                                                section.setText(String.valueOf(NOTE_HISTORIC) + XAppointmentFormatter.format((XAppointment)appointments.get(0), true, true, false, false, true));
                                            }
                                        }
                                    }
                                }
                            }
                        });
                    }
                };
                try {
                    AppointmentAccessorClient.getInstance().findFutureAppointmentsByPatient(this.hashCode(), Application.get().getGlobalInstances().getSession(), (ICallback)callback, patient.getId().intValue());
                }
                catch (CannotConnectToServerException cannotConnectToServerException) {
                    if (callback != null && !callback.killed()) {
                        callback.kill();
                    }
                    break block6;
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Failed to find futures appointments for patient " + patient.getId(), e);
                    if (callback != null && !callback.killed()) {
                        callback.kill();
                    }
                    break block6;
                }
            }
            section.setText(String.valueOf(NOTE_HISTORIC) + Messages.getString((String)"Print.AUCUN", (String[])new String[0]));
        }
    }

    private IBaseEditor getEditor() {
        return this.editor;
    }

    @Override
    public void setPatientImage(XPatientImage patientImage) {
        super.setPatientImage(patientImage);
        XPatientImageProfessionnal pip = this.getSessionProfessionnalPatientImageProfessionnal();
        this.initialNote = pip == null ? null : pip.getNote();
        this.txtNote.getStyledText().setFocus();
        this.txtNote.getStyledText().setSelection(this.txtNote.getStyledText().getText().length());
    }

    @Override
    public Control getControl() {
        return this.section;
    }
}

