/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.scan.singleview;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.CommonAccessorClient;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XCompletionProposalType;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.label.XLabelDef;
import ca.infodata.ofys.data.middle.dataobjects.label.XLabelResType;
import ca.infodata.ofys.data.middle.dataobjects.scan.XPatientImage;
import ca.infodata.ofys.data.middle.dataobjects.scan.XPatientImageResultType;
import ca.infodata.ofys.ui.controls.BaseEditor;
import ca.infodata.ofys.ui.controls.ControlDecorator;
import ca.infodata.ofys.ui.controls.DateText;
import ca.infodata.ofys.ui.controls.EditorModifyListener;
import ca.infodata.ofys.ui.controls.FontAwareGroup;
import ca.infodata.ofys.ui.controls.FontAwareTable;
import ca.infodata.ofys.ui.controls.IBaseEditor;
import ca.infodata.ofys.ui.controls.IBaseEditor2;
import ca.infodata.ofys.ui.controls.ReceiveEvent;
import ca.infodata.ofys.ui.controls.calendarcombo.MyCalendarText;
import ca.infodata.ofys.ui.controls.form.ISearchTextListener;
import ca.infodata.ofys.ui.controls.form.MyButton;
import ca.infodata.ofys.ui.controls.template.completion.TemplateAssistText;
import ca.infodata.ofys.ui.person.patient.PatientSearchText;
import ca.infodata.ofys.ui.person.patient.PatientUtil;
import ca.infodata.ofys.ui.scan.ProfessionnalControl;
import ca.infodata.ofys.ui.scan.singleview.BaseScanSingleViewSection;
import ca.infodata.util1.date.IPartialDate;
import ca.infodata.util1.date.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class InfoSection
extends BaseScanSingleViewSection {
    private static final String PROFESSIONNEL_TRAITANT__ = Messages.getString((String)"BaseScanEditor.PROFESSIONNEL_TRAITANT", (String[])new String[0]);
    private static final String PATIENT = Messages.getString((String)"BaseScanEditor.PATIENT", (String[])new String[0]);
    private static final String RESULTAT = Messages.getString((String)"BaseScanEditor.RESULTAT", (String[])new String[0]);
    private static final String TYPE_DE_DOCUMENT = Messages.getString((String)"BaseScanEditor.TYPE_DE_DOCUMENT", (String[])new String[0]);
    private static final String NOM = Messages.getString((String)"BaseScanEditor.NOM", (String[])new String[0]);
    private FormToolkit toolkit;
    private Section section;
    private FontAwareGroup grpInfo;
    protected PatientSearchText txtPatient;
    protected ProfessionnalControl profControl;
    protected FontAwareGroup grpResult;
    protected BaseEditor editor;
    protected MyButton btnSOResult;
    protected MyButton btnNormalResult;
    protected MyButton btnAnormalResult;
    protected MyButton btnVeryAnormalResult;
    protected FontAwareGroup grpLabel;
    protected FontAwareTable listLabels;
    protected TemplateAssistText txtName;
    protected MyCalendarText txtDocumentDate;
    protected String strLblTreatingProfessionnalName = PROFESSIONNEL_TRAITANT__;

    public InfoSection(BaseEditor editor, Composite parent, FormToolkit toolkit) {
        this.editor = editor;
        this.toolkit = toolkit;
        this.section = this.toolkit.createSection(parent, 2);
        this.section.setText("Informations");
        this.toolkit.createCompositeSeparator((Composite)this.section);
        this.grpInfo = new FontAwareGroup((Composite)this.section, 0, this.toolkit);
        this.grpInfo.setLayout((Layout)this.getFormLayoutNoSpacing());
        this.section.setClient((Control)this.grpInfo);
        this.txtPatient = new PatientSearchText((Composite)this.grpInfo, 81920, this.toolkit, PATIENT);
        this.profControl = new ProfessionnalControl((Composite)this.grpInfo, (IBaseEditor)editor, this.toolkit, true);
        this.grpResult = new FontAwareGroup((Composite)this.grpInfo, 0, this.toolkit);
        this.grpResult.setText(RESULTAT);
        this.grpResult.setLayout((Layout)this.getFormLayoutNoSpacing());
        this.btnSOResult = new MyButton((Composite)this.grpResult, XPatientImageResultType.SO.toString(), 16, this.toolkit);
        this.btnSOResult.setData((Object)XPatientImageResultType.SO);
        this.btnNormalResult = new MyButton((Composite)this.grpResult, XPatientImageResultType.NORMAL.toString(), 16, this.toolkit);
        this.btnNormalResult.setData((Object)XPatientImageResultType.NORMAL);
        this.btnAnormalResult = new MyButton((Composite)this.grpResult, XPatientImageResultType.ANORMAL.toString(), 16, this.toolkit);
        this.btnAnormalResult.setData((Object)XPatientImageResultType.ANORMAL);
        this.btnVeryAnormalResult = new MyButton((Composite)this.grpResult, XPatientImageResultType.VERY_ANORMAL.toString(), 16, this.toolkit);
        this.btnVeryAnormalResult.setData((Object)XPatientImageResultType.VERY_ANORMAL);
        this.grpLabel = new FontAwareGroup((Composite)this.grpInfo, 0, this.toolkit);
        this.grpLabel.setText(TYPE_DE_DOCUMENT);
        this.grpLabel.setLayout((Layout)this.getFormLayoutNoSpacing());
        this.listLabels = new FontAwareTable((Composite)this.grpLabel, 546);
        try {
            List labels = CommonAccessorClient.getInstance().findLabelDef(XLabelResType.PATIENT_IMAGE, false, Application.get().getGlobalInstances().getSession());
            Collections.sort(labels, XLabelDef.sortLabels);
            this.listLabels.setData((Object)labels);
            for (XLabelDef label : labels) {
                TableItem item = new TableItem((Table)this.listLabels, -1);
                item.setData((Object)label);
                item.setText(label.getName());
            }
        }
        catch (CannotConnectToServerException cannotConnectToServerException) {}
        FormLayout layout = new FormLayout();
        layout.marginTop = 5;
        layout.marginLeft = 5;
        layout.marginBottom = 5;
        layout.marginRight = 5;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.spacing = 2;
        Composite compName = this.toolkit.createComposite((Composite)this.grpInfo);
        compName.setLayout((Layout)layout);
        this.txtName = new TemplateAssistText(compName, 2048, this.toolkit);
        this.txtName.getStyledText().setToolTipText(NOM);
        this.txtName.setType(XCompletionProposalType.SCAN_IMAGE_NAME);
        this.txtName.getStyledText().setTextLimit(100);
        ControlDecorator.decorateWithEditProposal((TemplateAssistText)this.txtName, (int)16512);
        this.txtDocumentDate = new MyCalendarText(compName, toolkit);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 5);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(45);
        this.txtPatient.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(45, 10);
        data.right = new FormAttachment(65);
        this.grpResult.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.grpResult);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(55);
        this.profControl.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.profControl);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(65);
        compName.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(60);
        data.bottom = new FormAttachment(this.txtDocumentDate.getControl(), 0, 1024);
        this.txtName.getControl().setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(60, 5);
        data.right = new FormAttachment(100);
        this.txtDocumentDate.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.left = new FormAttachment(65, 5);
        data.bottom = new FormAttachment((Control)compName, 0, 1024);
        this.grpLabel.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(100);
        this.listLabels.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(90);
        this.btnSOResult.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.btnSOResult.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(90);
        this.btnNormalResult.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.btnNormalResult.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(90);
        this.btnAnormalResult.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.btnAnormalResult.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(90);
        this.btnVeryAnormalResult.setLayoutData((Object)data);
        this.txtDocumentDate.addDateListener((DateText.IDateListener)new EditorModifyListener((IBaseEditor2)this.getEditor(), 16384){

            public void edited(Event e) {
                InfoSection.this.getPatientImage().setDocumentDate((LocalDate)e.data);
            }
        });
        this.txtPatient.addSearchTextListener((ISearchTextListener)new EditorModifyListener((IBaseEditor2)this.getEditor(), 4096){

            public void edited(Event e) {
                ReceiveEvent e2 = (ReceiveEvent)e;
                XPatientImage patientImage = InfoSection.this.getPatientImage();
                patientImage.setPatient((IPatient)PatientUtil.getXPatient((Object)e2.data));
            }
        });
        this.txtName.getStyledText().addModifyListener((ModifyListener)new EditorModifyListener((IBaseEditor2)this.getEditor()){

            public void edited(Event e) {
                InfoSection.this.getPatientImage().setName(InfoSection.this.txtName.getText());
            }
        });
        this.listLabels.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                List<XLabelDef> lstLabels = InfoSection.this.getSelectedLabels();
                int nb = lstLabels.size();
                String gpName = TYPE_DE_DOCUMENT;
                String toolTip = "";
                if (nb > 0) {
                    gpName = String.valueOf(gpName) + "(" + nb + ")";
                    for (XLabelDef xLabelDef : lstLabels) {
                        String string = toolTip = toolTip.length() == 0 ? xLabelDef.getName() : String.valueOf(toolTip) + "\n" + xLabelDef.getName();
                    }
                }
                InfoSection.this.grpLabel.setText(gpName);
                InfoSection.this.grpLabel.setToolTipText(toolTip);
                InfoSection.this.grpLabel.update();
            }
        });
        this.listLabels.addSelectionListener((SelectionListener)new EditorModifyListener((IBaseEditor2)this.getEditor()){

            public void edited(Event e) {
                TableItem[] selection = InfoSection.this.listLabels.getItems();
                InfoSection.this.getPatientImage().getLabels().clear();
                TableItem[] tableItemArray = selection;
                int n = selection.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    if (item.getChecked()) {
                        InfoSection.this.getPatientImage().getLabels().add((XLabelDef)item.getData());
                    }
                    ++n2;
                }
                InfoSection.this.getPatientImage().setUpdated();
            }
        });
        EditorModifyListener resultTypesListener = new EditorModifyListener((IBaseEditor2)this.getEditor()){

            public void edited(Event e) {
                InfoSection.this.getPatientImage().setResult((XPatientImageResultType)e.widget.getData());
            }
        };
        this.btnSOResult.addSelectionListener((SelectionListener)resultTypesListener);
        this.btnNormalResult.addSelectionListener((SelectionListener)resultTypesListener);
        this.btnAnormalResult.addSelectionListener((SelectionListener)resultTypesListener);
        this.btnVeryAnormalResult.addSelectionListener((SelectionListener)resultTypesListener);
    }

    @Override
    public void showDataObject() {
        XPatientImage patientImage = this.getPatientImage();
        if (patientImage == null) {
            this.profControl.fillProfessionnalList(patientImage);
            this.profControl.setEnabled(false);
            this.txtPatient.setDataObject(null);
            this.txtPatient.setEnabled(false);
            this.txtName.setText(null);
            this.txtName.setEnabled(false);
            this.txtDocumentDate.setDate(null);
            this.txtDocumentDate.setEnabled(false);
            this.grpResult.setEnabled(false);
            this.btnSOResult.setSelection(false);
            this.btnNormalResult.setSelection(false);
            this.btnAnormalResult.setSelection(false);
            this.btnVeryAnormalResult.setSelection(false);
            TableItem[] tableItemArray = this.listLabels.getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                item.setChecked(false);
                ++n2;
            }
        } else {
            this.profControl.fillProfessionnalList(patientImage);
            this.txtPatient.setDataObject((IDataObject)patientImage.getPatient());
            this.txtName.setText(patientImage.getName());
            this.txtDocumentDate.setDate((IPartialDate)patientImage.getDocumentDate());
            this.btnSOResult.setSelection(patientImage.getResult() == XPatientImageResultType.SO);
            this.btnNormalResult.setSelection(patientImage.getResult() == XPatientImageResultType.NORMAL);
            this.btnAnormalResult.setSelection(patientImage.getResult() == XPatientImageResultType.ANORMAL);
            this.btnVeryAnormalResult.setSelection(patientImage.getResult() == XPatientImageResultType.VERY_ANORMAL);
            List labels = this.getPatientImage().getLabels();
            TableItem[] tableItemArray = this.listLabels.getItems();
            int n = tableItemArray.length;
            int n3 = 0;
            while (n3 < n) {
                TableItem item = tableItemArray[n3];
                item.setChecked(labels.contains(item.getData()));
                ++n3;
            }
        }
        this.listLabels.notifyListeners(13, new Event());
    }

    private IBaseEditor getEditor() {
        return this.editor;
    }

    private FormLayout getFormLayoutNoSpacing() {
        return this.editor.getFormLayoutNoSpacing();
    }

    public List<XLabelDef> getSelectedLabels() {
        ArrayList<XLabelDef> list = new ArrayList<XLabelDef>();
        TableItem[] tableItemArray = this.listLabels.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getChecked()) {
                list.add((XLabelDef)item.getData());
            }
            ++n2;
        }
        return list;
    }

    @Override
    public Control getControl() {
        return this.section;
    }
}

