/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.preferences.completioncombo;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.CompletionComboAccessorClient;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.callback.IStatusHandler;
import ca.infodata.ofys.data.dataaccess.callback.JobCallback;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XCompletionComboType;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ICompletionComboItem;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.ui.controls.actions.IRefreshable;
import ca.infodata.ofys.ui.intro.DefaultStatusHandler;
import ca.infodata.ofys.ui.library.log.Log;
import ca.infodata.ofys.ui.preferences.completioncombo.BaseCompletionComboControl;
import ca.infodata.ofys.ui.preferences.completioncombo.CompletionComboEditor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class CompletionComboControl
extends BaseCompletionComboControl
implements IRefreshable {
    public CompletionComboControl(Composite parent, FormToolkit toolkit, CompletionComboEditor parentEditor) {
        super(parent, toolkit, parentEditor);
    }

    public void showDataObject() {
        XCompletionComboType type = this.getComboType();
        if (type == null) {
            this.lblComboName.setText(null);
            this.tblComboItems.removeAll();
            this.tblComboItems.setEnabled(false);
            this.tblComboItems2.removeAll();
            this.tblComboItems2.setEnabled(false);
            this.cmdCleanAll.setEnabled(false);
            this.cmdReplace.setEnabled(false);
            this.cmdDeactivate.setEnabled(false);
        } else {
            this.lblComboName.setText(type.getText());
            this.tblComboItems.removeAll();
            this.tblComboItems.setEnabled(true);
            this.tblComboItems2.removeAll();
            this.tblComboItems2.setEnabled(true);
            this.cmdCleanAll.setEnabled(true);
            this.cmdReplace.setEnabled(true);
            this.cmdDeactivate.setEnabled(true);
        }
        this.fillCompletionComboList();
    }

    @Override
    public void fillCompletionComboList() {
        block6: {
            XSession session = Application.get().getGlobalInstances().getSession();
            XCompletionComboType type = this.getComboType();
            if (session == null || type == null) {
                this.fillCompletionComboList(null);
            } else {
                JobCallback callback = new JobCallback(Messages.getString((String)"DONNEES", (String[])new String[0]), (IStatusHandler)DefaultStatusHandler.getInstance()){

                    public void responseReceived(final ReturnObject response) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (response == null || response.getObj() == null) {
                                    CompletionComboControl.this.fillCompletionComboList(null);
                                } else {
                                    CompletionComboControl.this.fillCompletionComboList((List)response.getObj());
                                }
                            }
                        });
                    }
                };
                try {
                    CompletionComboAccessorClient.getInstance().findAllAsync(session, (ICallback)callback, type.getType());
                }
                catch (CannotConnectToServerException cannotConnectToServerException) {
                    MessageUtil.cannotConnectToServerExceptionMsg();
                    if (callback != null && !callback.killed()) {
                        callback.kill();
                    }
                }
                catch (Exception e) {
                    Log.severe((Throwable)e);
                    if (callback == null || callback.killed()) break block6;
                    callback.kill();
                }
            }
        }
    }

    public void fillCompletionComboList(List<ICompletionComboItem> items) {
        this.tblComboItems.removeAll();
        this.tblComboItems2.removeAll();
        TableItem tblItem = null;
        if (items != null) {
            Collections.sort(items, new Comparator<ICompletionComboItem>(){

                @Override
                public int compare(ICompletionComboItem o1, ICompletionComboItem o2) {
                    return o1.getText().compareTo(o2.getText());
                }
            });
            for (ICompletionComboItem item : items) {
                if (!item.isActive()) continue;
                tblItem = new TableItem(this.tblComboItems, 0);
                tblItem.setText(item.getText());
                tblItem.setData((Object)item);
                tblItem = new TableItem(this.tblComboItems2, 0);
                tblItem.setText(item.getText());
                tblItem.setData((Object)item);
            }
        }
    }

    @Override
    protected void btnCleanAllSelected() {
        block5: {
            XCompletionComboType type;
            XSession session = Application.get().getGlobalInstances().getSession();
            if (session != null & (type = this.getComboType()) != null) {
                JobCallback callback = new JobCallback(Messages.getString((String)"NETTOYER", (String[])new String[0]), (IStatusHandler)DefaultStatusHandler.getInstance()){

                    public void responseReceived(ReturnObject response) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                CompletionComboControl.this.refresh();
                            }
                        });
                    }
                };
                try {
                    CompletionComboAccessorClient.getInstance().cleanType(((Object)((Object)this.getParentEditor())).hashCode(), session, (ICallback)callback, type.getType());
                }
                catch (CannotConnectToServerException cannotConnectToServerException) {
                    MessageUtil.cannotConnectToServerExceptionMsg();
                    if (callback != null && !callback.killed()) {
                        callback.kill();
                    }
                }
                catch (Exception e) {
                    Log.severe((Throwable)e);
                    if (callback == null || callback.killed()) break block5;
                    callback.kill();
                }
            }
        }
    }

    @Override
    protected void btnReplaceSelected() {
        block6: {
            XCompletionComboType type;
            XSession session = Application.get().getGlobalInstances().getSession();
            if (session != null & (type = this.getComboType()) != null && this.tblComboItems.getSelectionIndex() != -1 && this.tblComboItems2.getSelectionIndex() != -1) {
                ArrayList<ICompletionComboItem> source = new ArrayList<ICompletionComboItem>();
                TableItem[] items = this.tblComboItems.getSelection();
                int i = 0;
                while (i < items.length) {
                    source.add((ICompletionComboItem)items[i].getData());
                    ++i;
                }
                ICompletionComboItem by = (ICompletionComboItem)this.tblComboItems2.getSelection()[0].getData();
                JobCallback callback = new JobCallback(Messages.getString((String)"REMPLACER", (String[])new String[0]), (IStatusHandler)DefaultStatusHandler.getInstance()){

                    public void responseReceived(ReturnObject response) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                CompletionComboControl.this.refresh();
                            }
                        });
                    }
                };
                try {
                    CompletionComboAccessorClient.getInstance().replaceComboItem(((Object)((Object)this.getParentEditor())).hashCode(), session, (ICallback)callback, type.getType(), source, by);
                }
                catch (CannotConnectToServerException cannotConnectToServerException) {
                    MessageUtil.cannotConnectToServerExceptionMsg();
                    if (callback != null && !callback.killed()) {
                        callback.kill();
                    }
                }
                catch (Exception e) {
                    Log.severe((Throwable)e);
                    if (callback == null || callback.killed()) break block6;
                    callback.kill();
                }
            }
        }
    }

    @Override
    protected void btnDeactivateSelected() {
        block6: {
            XCompletionComboType type;
            XSession session = Application.get().getGlobalInstances().getSession();
            if (session != null & (type = this.getComboType()) != null && this.tblComboItems.getSelectionIndex() != -1) {
                ArrayList<ICompletionComboItem> source = new ArrayList<ICompletionComboItem>();
                TableItem[] items = this.tblComboItems.getSelection();
                int i = 0;
                while (i < items.length) {
                    source.add((ICompletionComboItem)items[i].getData());
                    ++i;
                }
                JobCallback callback = new JobCallback(Messages.getString((String)"DESACTIVER", (String[])new String[0]), (IStatusHandler)DefaultStatusHandler.getInstance()){

                    public void responseReceived(ReturnObject response) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                CompletionComboControl.this.refresh();
                            }
                        });
                    }
                };
                try {
                    CompletionComboAccessorClient.getInstance().desactiveComboItem(((Object)((Object)this.getParentEditor())).hashCode(), session, (ICallback)callback, type.getType(), source);
                }
                catch (CannotConnectToServerException cannotConnectToServerException) {
                    MessageUtil.cannotConnectToServerExceptionMsg();
                    if (callback != null && !callback.killed()) {
                        callback.kill();
                    }
                }
                catch (Exception e) {
                    Log.severe((Throwable)e);
                    if (callback == null || callback.killed()) break block6;
                    callback.kill();
                }
            }
        }
    }

    public void refresh() {
        this.showDataObject();
    }
}

