/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.encounter.medication.editor;

import ca.infodata.ofys.client.modules.encounter.XPrescriptionFormatter;
import ca.infodata.ofys.data.middle.dataobjects.medication.XPrescription;
import ca.infodata.ofys.data.middle.dataobjects.medication.XPrescriptionDrugNameFormat;
import ca.infodata.ofys.util.MiscUtil;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.IPartialDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.map.MultiValueMap;
import org.apache.commons.lang3.ObjectUtils;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class PrescriptionByGroupContentProvider
implements ITreeContentProvider {
    private XPrescriptionDrugNameFormat nameFormat = XPrescriptionFormatter.getDrugNameFormat();

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof List) {
            List list = (List)inputElement;
            Collections.sort(list, new Comparator<XPrescription>(){

                @Override
                public int compare(XPrescription o1, XPrescription o2) {
                    if (o1.getStrength() != null && o2.getStrength() != null) {
                        String generic1 = o1.getStrength().getGenericName();
                        String generic2 = o2.getStrength().getGenericName();
                        String commercial1 = o1.getStrength().getCommercialName();
                        String commercial2 = o2.getStrength().getCommercialName();
                        if (PrescriptionByGroupContentProvider.areSamePrescription(o1, o2)) {
                            return -o1.getStartDate().compareTo((IPartialDate)o2.getStartDate());
                        }
                        int i = ObjectUtils.compare((Comparable)((Object)(generic1 == null ? null : generic1.toLowerCase())), (Comparable)((Object)(generic2 == null ? null : generic2.toLowerCase())));
                        if (i == 0) {
                            i = ObjectUtils.compare((Comparable)((Object)(commercial1 == null ? null : commercial1.toLowerCase())), (Comparable)((Object)(commercial2 == null ? null : commercial2.toLowerCase())));
                        }
                        if (i == 0) {
                            i = -o1.getStartDate().compareTo((IPartialDate)o2.getStartDate());
                        }
                        return i;
                    }
                    if (o1.getDevice() != null && o2.getDevice() != null) {
                        String generic1 = o1.getDevice().getName();
                        String generic2 = o2.getDevice().getName();
                        if (PrescriptionByGroupContentProvider.areSamePrescription(o1, o2)) {
                            return -o1.getStartDate().compareTo((IPartialDate)o2.getStartDate());
                        }
                        int i = ObjectUtils.compare((Comparable)((Object)(generic1 == null ? null : generic1.toLowerCase())), (Comparable)((Object)(generic2 == null ? null : generic2.toLowerCase())));
                        if (i == 0) {
                            i = -o1.getStartDate().compareTo((IPartialDate)o2.getStartDate());
                        }
                    }
                    return -o1.getStartDate().compareTo((IPartialDate)o2.getStartDate());
                }
            });
            MultiValueMap lstMM = new MultiValueMap();
            for (XPrescription xx : list) {
                String generic = null;
                String commercial = null;
                String strength = null;
                String key = null;
                if (xx.getStrength() != null) {
                    generic = xx.getStrength().getGenericName();
                    commercial = xx.getStrength().getCommercialName();
                    strength = xx.getStrength().getText();
                    key = StringUtils.replace((String)(String.valueOf(generic) + commercial + strength), (String)"[ //-/(/)]", (String)"");
                } else if (xx.getDevice() != null) {
                    generic = xx.getDevice().getName();
                    key = StringUtils.replace((String)generic, (String)"[ //-/(/)]", (String)"");
                }
                if (key == null) continue;
                lstMM.put(key, (Object)xx);
            }
            ArrayList<GroupItem> groups = new ArrayList<GroupItem>();
            Set keys = lstMM.keySet();
            for (Object k : keys) {
                GroupItem group = null;
                List l = (List)lstMM.get(k);
                for (Object o : l) {
                    XPrescription p = (XPrescription)o;
                    if (group == null) {
                        group = new GroupItem(p);
                        groups.add(group);
                    }
                    group.children.add(new PrescriptionItem(p, group));
                }
            }
            final boolean sortGeneric = XPrescriptionDrugNameFormat.GENERIC.equals((Object)this.nameFormat) || XPrescriptionDrugNameFormat.GENERIC_AND_COMMERCIAL.equals((Object)this.nameFormat);
            Collections.sort(groups, new Comparator<GroupItem>(){

                @Override
                public int compare(GroupItem o1, GroupItem o2) {
                    if (o1.xPresription.getStrength() != null && o2.xPresription.getStrength() != null) {
                        if (sortGeneric) {
                            return o1.xPresription.getStrength().getGenericName().compareTo(o2.xPresription.getStrength().getGenericName());
                        }
                        return o1.xPresription.getStrength().getCommercialName().compareTo(o2.xPresription.getStrength().getCommercialName());
                    }
                    if (o1.xPresription.getDevice() != null && o2.xPresription.getDevice() != null) {
                        return o1.xPresription.getDevice().getName().compareTo(o2.xPresription.getDevice().getName());
                    }
                    return 0;
                }
            });
            return groups.toArray();
        }
        return null;
    }

    private static boolean areSamePrescription(XPrescription xRx1, XPrescription xRx2) {
        if (xRx1 == xRx2) {
            return true;
        }
        if (xRx1 == null || xRx2 == null) {
            return false;
        }
        String generic1 = null;
        String commercial1 = "";
        String generic2 = null;
        String commercial2 = "";
        if (xRx1.getStrength() != null && xRx2.getStrength() != null) {
            generic1 = xRx1.getStrength().getGenericName();
            generic2 = xRx2.getStrength().getGenericName();
            commercial1 = xRx1.getStrength().getCommercialName();
            commercial2 = xRx2.getStrength().getCommercialName();
        } else if (xRx1.getDevice() != null && xRx2.getDevice() != null) {
            generic1 = xRx1.getDevice().getName();
            generic2 = xRx2.getDevice().getName();
        }
        return MiscUtil.areObjectsEquals((Object)StringUtils.toLowerCase(generic1), (Object)StringUtils.toLowerCase(generic2)) && MiscUtil.areObjectsEquals((Object)StringUtils.toLowerCase((String)commercial1), (Object)StringUtils.toLowerCase((String)commercial2)) && MiscUtil.areObjectsEquals((Object)xRx1.getStrength(), (Object)xRx2.getStrength());
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getChildren(Object element) {
        if (element instanceof GroupItem) {
            return ((GroupItem)element).children.toArray();
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        if (element instanceof PrescriptionItem) {
            return ((PrescriptionItem)element).group;
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof GroupItem;
    }

    public static class GroupItem {
        public XPrescription xPresription;
        public List<PrescriptionItem> children = new ArrayList<PrescriptionItem>();

        public GroupItem(XPrescription medication) {
            this.xPresription = medication;
        }

        public String toString() {
            return String.format("GroupItem [children=%s]", this.children);
        }
    }

    public static class PrescriptionItem {
        public XPrescription prescription;
        public GroupItem group;

        public PrescriptionItem(XPrescription prescription, GroupItem group) {
            this.prescription = prescription;
            this.group = group;
        }

        public String toString() {
            return String.valueOf(this.prescription);
        }
    }
}

