/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person.patient.simpleview;

import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.identifiers.XPatientIdentifier;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IEditableDataObjectListReader;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.ui.controls.CallbackControlDecorator;
import ca.infodata.ofys.ui.controls.FontAwareHyperlink;
import ca.infodata.ofys.ui.controls.ICallbackControl;
import ca.infodata.ofys.util.MiscUtil;
import ca.infodata.util1.JoinList;
import ca.infodata.util1.StringUtils;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class PatientRecordNumberLink
extends FontAwareHyperlink
implements ICallbackControl<IPatient> {
    private static final Logger logger = Logger.getLogger(PatientRecordNumberLink.class.getName());
    private IPatient patient;
    private final CallbackControlDecorator<IPatient> callbackControlDecorator = new CallbackControlDecorator((ICallbackControl)this);

    public PatientRecordNumberLink(Composite parent, int style) {
        super(parent, style);
    }

    public void setEnabled(boolean v) {
        this.setEnabled(v);
    }

    public Control getControl() {
        return this;
    }

    public void showAsLoading(IPatient arg) throws Exception {
        String baseText = this.getBaseText();
        if (StringUtils.isNotBlank((String)baseText)) {
            baseText = String.valueOf(baseText) + " (...)";
        }
        this.setText(baseText);
    }

    private String getBaseText() {
        String text = this.getPatient() == null ? "" : this.get(this.getPatient().getPatientRecordNumber(), "1");
        return text;
    }

    private String get(Object o, String defaultIfNull) {
        if (o == null) {
            return defaultIfNull;
        }
        return o.toString();
    }

    public void showAsLoaded(IPatient arg, ReturnObject response) throws Exception {
        if (MiscUtil.areObjectsEquals((Object)arg, (Object)this.getPatient())) {
            String text;
            if (arg == null) {
                text = "";
            } else {
                IEditableDataObjectListReader identifiers = arg.getLstPatientIdentifier();
                JoinList joinList = new JoinList(", ");
                joinList.setAllowBlank(false);
                joinList.setNoDuplicate(true);
                int i = 0;
                while (i < identifiers.size()) {
                    joinList.add((CharSequence)((XPatientIdentifier)identifiers.get(0)).getIdentifier());
                    ++i;
                }
                text = joinList.size() > 0 ? String.valueOf(this.getBaseText()) + " (" + joinList.toString() + ")" : this.getBaseText();
            }
            this.setText(text);
        }
    }

    public void showAsError(IPatient arg) {
        if (MiscUtil.areObjectsEquals((Object)arg, (Object)this.getPatient())) {
            this.setText(String.valueOf(this.getBaseText()) + " (" + Messages.getString((String)"ERREUR", (String[])new String[0]) + ")");
        }
    }

    public IPatient getPatient() {
        return this.patient;
    }

    public void setPatient(IPatient patient) {
        try {
            this.patient = patient;
            this.callbackControlDecorator.showAsLoadedInSwtThread((Object)patient, null);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error", e);
            this.callbackControlDecorator.showErrorInSwtThread((Object)patient, null, (Throwable)e);
        }
    }
}

