/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person.patient.search.editor;

import apple.finder.search.ui.AbstractRow;
import apple.finder.search.ui.AppleFinderGrid;
import apple.finder.search.ui.GroupRow;
import apple.finder.search.ui.IAppleFinderGridFactory;
import apple.finder.search.ui.ICriteriaField;
import apple.finder.search.ui.ICriteriaRowFactory;
import apple.finder.search.ui.IGetFactory;
import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.PatientAccessorClient;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.search.Group;
import ca.infodata.ofys.data.middle.dataobjects.search.XSearchOrder;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.status.StatusException;
import ca.infodata.ofys.ui.controls.BaseEditor;
import ca.infodata.ofys.ui.controls.BaseView;
import ca.infodata.ofys.ui.controls.EditorInput;
import ca.infodata.ofys.ui.controls.EditorPart2;
import ca.infodata.ofys.ui.controls.MyProgressMonitorDialog;
import ca.infodata.ofys.ui.controls.form.MyButton;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.ofys.ui.person.patient.search.AbstractCriteria;
import ca.infodata.ofys.ui.person.patient.search.CriteriaGetFactory;
import ca.infodata.ofys.ui.person.patient.search.IAppleFinderGridFactory2;
import ca.infodata.ofys.ui.person.patient.search.XmlGetFactory;
import ca.infodata.ofys.ui.person.patient.search.editor.SearchOrderEditor;
import ca.infodata.ofys.ui.person.patient.search.editor.SearchResultView;
import ca.infodata.util1.StringUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class DirectSearchEditor
extends EditorPart2
implements IAppleFinderGridFactory2 {
    private static final Logger logger = Logger.getLogger(SearchOrderEditor.class.getName());
    public static final String PATIENT_SEARCH_CRITERIA_ID = "ca.infodata.ofys.ui.person.patientSearchCriteria";
    private Map<ICriteriaField, ICriteriaRowFactory> fields;
    private Map<ICriteriaField, AbstractCriteria> fields2;
    private AppleFinderGrid grid;
    private MyButton btnClear;
    private MyButton btnSearch;
    private MyButton btnConvertToDifferedSearch;

    public void createPartControl(Composite parent) {
        FormToolkit toolkit = UI.createToolKit((Widget)parent);
        this.btnClear = new MyButton(parent, "Effacer", 8, toolkit);
        this.btnSearch = new MyButton(parent, "Rechercher maintenant", 8, toolkit);
        this.btnConvertToDifferedSearch = new MyButton(parent, "Convertir en recherche diff\u00e9r\u00e9e", 8, toolkit);
        this.grid = new AppleFinderGrid(parent, 2048){

            public void layoutRows() {
                super.layoutRows();
                this.isDeferRowLayout();
            }
        };
        this.grid.setFactory((IAppleFinderGridFactory)this);
        this.btnClear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectSearchEditor.this.doClear();
            }
        });
        this.btnSearch.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectSearchEditor.this.doSearch();
            }
        });
        this.btnConvertToDifferedSearch.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectSearchEditor.this.doConvertToDifferedSearch();
            }
        });
        FormLayout layout = new FormLayout();
        layout.spacing = 5;
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        parent.setLayout((Layout)layout);
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.right = new FormAttachment(100);
        this.btnClear.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        this.btnSearch.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(this.btnSearch.getControl());
        this.btnConvertToDifferedSearch.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.btnClear.getControl());
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(100);
        this.grid.setLayoutData((Object)data);
        this.setPartName("Recherche instantan\u00e9e");
        this.doClear();
    }

    public Set<ICriteriaField> getFields() {
        if (this.fields == null) {
            this.fields2 = new HashMap<ICriteriaField, AbstractCriteria>();
            this.fields = new TreeMap<ICriteriaField, ICriteriaRowFactory>(new Comparator<ICriteriaField>(){

                @Override
                public int compare(ICriteriaField o1, ICriteriaField o2) {
                    return StringUtils.compareAscii((String)o1.getText(), (String)o2.getText());
                }
            });
            IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor(PATIENT_SEARCH_CRITERIA_ID);
            try {
                IConfigurationElement[] iConfigurationElementArray = config;
                int n = config.length;
                int n2 = 0;
                while (n2 < n) {
                    AbstractCriteria factory;
                    IConfigurationElement e = iConfigurationElementArray[n2];
                    AbstractCriteria field = factory = (AbstractCriteria)e.createExecutableExtension("factory");
                    this.fields.put(field, factory);
                    this.fields2.put(field, factory);
                    ++n2;
                }
            }
            catch (CoreException ex) {
                logger.log(Level.WARNING, "Failed to load patient search criteria extensions for " + this.getClass().getName(), ex);
            }
        }
        return this.fields.keySet();
    }

    public ICriteriaRowFactory get(ICriteriaField field) {
        return this.fields.get(field);
    }

    @Override
    public AbstractCriteria getCriteria(ICriteriaField field) {
        return this.fields2.get(field);
    }

    protected void doClear() {
        this.grid.deleteAll();
        try {
            this.grid.setDeferRowLayout(true);
            GroupRow g = this.grid.addGroup(null);
            this.grid.addCriteria((AbstractRow)g);
        }
        finally {
            this.grid.setDeferRowLayout(false);
        }
        this.grid.setDirty(false);
    }

    protected void doSearch() {
        final MyProgressMonitorDialog dialog2 = new MyProgressMonitorDialog(this.getSite().getShell());
        try {
            CriteriaGetFactory groupFactory = new CriteriaGetFactory(this.fields2);
            this.grid.getGroup((IGetFactory)groupFactory);
            final Group group = groupFactory.toGroup();
            dialog2.setInterruptOnCancel(true);
            dialog2.run(true, true, new IRunnableWithProgress(){

                /*
                 * Loose catch block
                 */
                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        try {
                            List<Integer> list = DirectSearchEditor.this.doSearch2(monitor, group);
                            DirectSearchEditor.this.openSearchResultView(list);
                        }
                        catch (InterruptedException interruptedException) {
                            monitor.done();
                        }
                        catch (StatusException e) {
                            block11: {
                                if (e.getStatus().getStatus("RequestTimeoutException") != null) {
                                    MessageUtil.show((Shell)dialog2.getShell(), (IStatus)e.getStatus());
                                    break block11;
                                }
                                logger.log(Level.SEVERE, "Error", e);
                                MessageUtil.show((Shell)dialog2.getShell(), (IStatus)e.getStatus());
                            }
                            monitor.done();
                        }
                        catch (Exception e) {
                            logger.log(Level.SEVERE, "Error", e);
                            MessageUtil.show((Shell)dialog2.getShell(), (Exception)e);
                            {
                                catch (Throwable throwable) {
                                    throw throwable;
                                }
                            }
                            monitor.done();
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Error", ex);
        }
    }

    protected void doConvertToDifferedSearch() {
        try {
            XmlGetFactory xmlFactory = new XmlGetFactory(this.fields2);
            this.grid.getGroup((IGetFactory)xmlFactory);
            String xml = xmlFactory.toXml();
            this.doConvertToDifferedSearch(xml);
        }
        catch (Exception e) {
            MessageUtil.show((Shell)this.getSite().getShell(), (Exception)e);
        }
    }

    protected void doConvertToDifferedSearch(String xml) {
        XSearchOrder order = new XSearchOrder();
        order.setTemplateXml(xml);
        order.setNew();
        BaseEditor.openEditorSafe((IEditorInput)new EditorInput((IDataObject)order), (String)"ca.infodata.ofys.ui.person.patient.search.editor.SearchOrderEditor");
    }

    protected void openSearchResultView(final List<Integer> list) {
        if (list != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    SearchResultView view = (SearchResultView)BaseView.findView(SearchResultView.class);
                    if (view == null) {
                        view = (SearchResultView)BaseView.openView(SearchResultView.class, (int)1);
                    }
                    view.setIds(list);
                }
            });
        }
    }

    protected List<Integer> doSearch2(IProgressMonitor monitor, Group group) throws Exception {
        monitor.beginTask("Recherche", 1);
        ReturnObject ret = PatientAccessorClient.getInstance().find(Application.get().getGlobalInstances().getSession(), group);
        if (ret != null) {
            if (ret.getStatus() != null && ret.getStatus().isOK()) {
                List idPatients = (List)ret.getObj();
                return idPatients;
            }
            throw new StatusException((IStatus)ret.getStatus());
        }
        throw new Exception("call returned null");
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.setSite((IWorkbenchPartSite)site);
        super.setInput(input);
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void setFocus() {
    }
}

