/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person.patient;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.BaseAccessorClient;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.PatientAccessorClient;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XPatient;
import ca.infodata.ofys.data.middle.dataobjects.XPatientListContainer;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.preferences.FormatDateProvider;
import ca.infodata.ofys.ui.controls.EditorInput;
import ca.infodata.ofys.ui.controls.IPrintable;
import ca.infodata.ofys.ui.controls.plugins.searchview.BaseSearchView;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.ofys.ui.person.IPatientReport;
import ca.infodata.ofys.ui.person.patient.BasePatientListEditor;
import ca.infodata.ofys.ui.person.patient.PatientUtil;
import ca.infodata.ofys.ui.person.print.PatientPrintDialog;
import ca.infodata.ofys.ui.person.search.PatientSearchView;
import ca.infodata.util1.JoinList;
import ca.infodata.util1.ProviderAR;
import ca.infodata.util1.date.LocalDate;
import ca.infodata.util1.date.LocalDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TableItem;

public class PatientListEditor
extends BasePatientListEditor
implements IPatientReport,
IPrintable {
    private static final String NO_NAME = Messages.getString((String)"AUCUN_NOM", (String[])new String[0]);
    private static final String NO_BIRTHDATE = Messages.getString((String)"AUCUNE_DATE_DE_NAISSANCE", (String[])new String[0]);
    private static final String NO_RECORD_NUMBER = Messages.getString((String)"AUCUN_NUMERO_DE_DOSSIER", (String[])new String[0]);
    private static final ProviderAR<IPatient, String> labelProvider = new ProviderAR<IPatient, String>(){

        public String get(IPatient patient) {
            if (patient != null) {
                String nam = patient.getHealthInsuranceNumber();
                String rec = patient.getPatientRecordNumber() == null ? NO_RECORD_NUMBER : patient.getPatientRecordNumber();
                String ddn = NO_BIRTHDATE;
                if (patient.getBirthDate() != null) {
                    ddn = LocalDateFormat.format((LocalDate)patient.getBirthDate(), (String)FormatDateProvider.getFormatDate().toString());
                }
                String name = patient.getName() == null ? NO_NAME : patient.getName();
                String sex = patient.getGender();
                if (Application.get().getGlobalInstances().inDebugMode()) {
                    return new JoinList(", ", new Object[]{patient.getId(), name, ddn, sex, rec, nam}).toString();
                }
                return new JoinList(", ", new Object[]{patient.getId(), name, ddn, sex, rec, nam}).toString();
            }
            return "";
        }
    };

    @Override
    protected void btnSearchPatientSelected() {
        BaseSearchView.openView(PatientSearchView.class, (Object)this);
    }

    @Override
    protected void btnClearListSelected() {
        this.getContainer().setPatientList(new ArrayList());
        this.tblPatients.removeAll();
    }

    @Override
    protected void btnExportToCsv() {
    }

    public void setToolBarStatus() {
    }

    public boolean isDataDirty() {
        return false;
    }

    public void initDataOverride() {
        if (((EditorInput)this.getEditorInput()).getDataObject() instanceof XPatientListContainer) {
            this.initializeCompleteDataObject((EditableDataObject)((EditorInput)this.getEditorInput()).getDataObject());
        }
    }

    public void showDataObject() {
        this.tblPatients.removeAll();
        for (IPatient patient : this.getContainer().getPatientList()) {
            this.addPatient(patient);
        }
    }

    public boolean isPrintAllowed() {
        return true;
    }

    public void print() {
        ArrayList<XPatient> list = this.getSelectedPatients();
        PatientPrintDialog dialog = new PatientPrintDialog(this.getSite().getShell(), list);
        UI.centerComposite((Composite)dialog.getShell(), (Composite)this.getEditorSite().getShell());
        dialog.open();
    }

    private ArrayList<XPatient> getSelectedPatients() {
        ArrayList<XPatient> list = new ArrayList<XPatient>(this.tblPatients.getItems().length);
        TableItem[] tableItemArray = this.tblPatients.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getChecked()) {
                list.add(PatientUtil.getSimplePatient(item.getData()));
            }
            ++n2;
        }
        return list;
    }

    public BaseAccessorClient getAccessor() throws CannotConnectToServerException {
        return PatientAccessorClient.getInstance();
    }

    @Override
    public void addPatient(IPatient patient) {
        List patientList = this.getContainer().getPatientList();
        if (!patientList.contains(patient)) {
            TableItem tableItem = new TableItem(this.tblPatients, 0);
            tableItem.setText((String)labelProvider.get((Object)patient));
            tableItem.setData((Object)patient);
            tableItem.setChecked(true);
            patientList.add(patient);
        }
    }

    public Image getEditorTitleImage() {
        return ResourceGetter.getImage((String)"images/persons-icon32.png");
    }
}

