/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.person.menu;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.LoginAccessorClient;
import ca.infodata.ofys.data.dataaccess.callback.Callback;
import ca.infodata.ofys.data.middle.dataobjects.XActiveSession;
import ca.infodata.ofys.data.middle.dataobjects.XBaseUser;
import ca.infodata.ofys.data.middle.dataobjects.XImageDecorator;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.ui.controls.ITreeElements;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.person.PersonUiPlugin;
import ca.infodata.ofys.ui.person.menu.ListActiveSessionsElement;
import ca.infodata.util1.JoinList;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.LocaleProvider;
import ca.infodata.util1.date.TimeZoneProvider;
import java.util.Locale;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.time.FastDateFormat;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IEditorInput;

public class ActiveSessionElement
implements ITreeElements {
    private static final Logger logger = Logger.getLogger(ActiveSessionElement.class.getName());
    private ListActiveSessionsElement parent;
    private XActiveSession activeSession;

    public ActiveSessionElement(ListActiveSessionsElement parent, XActiveSession activeSession) {
        this.parent = parent;
        this.activeSession = activeSession;
    }

    public Object[] getChildren() {
        return null;
    }

    public Object getParent() {
        return this.parent;
    }

    public boolean hasChildren() {
        return false;
    }

    public String getText() {
        XBaseUser user = PersonUiPlugin.getDefault().getUser(this.activeSession.userId);
        FastDateFormat fastDateFormat = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss", (TimeZone)TimeZoneProvider.getTimeZone(), (Locale)LocaleProvider.getLocale());
        String lastActivityTime = this.activeSession.lastActivityTime == null ? "inc" : fastDateFormat.format((Object)this.activeSession.lastActivityTime);
        String lastLoginTime = this.activeSession.lastLoginTime == null ? "" : fastDateFormat.format((Object)this.activeSession.lastLoginTime);
        String s = String.format("%s %s, %s (%s - %s)", StringUtils.defaultString((String)user.getPersonName()), StringUtils.isEmpty((String)user.getText()) ? "" : "(" + user.getText() + ")", this.activeSession.sessionType, lastLoginTime, lastActivityTime);
        return s;
    }

    public String getTooltipText() {
        XBaseUser user = PersonUiPlugin.getDefault().getUser(this.activeSession.userId);
        FastDateFormat fastDateFormat = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss", (TimeZone)TimeZoneProvider.getTimeZone(), (Locale)LocaleProvider.getLocale());
        String lastActivityTime = this.activeSession.lastActivityTime == null ? "inconnue" : fastDateFormat.format((Object)this.activeSession.lastActivityTime);
        String lastLoginTime = this.activeSession.lastLoginTime == null ? "inconnue" : fastDateFormat.format((Object)this.activeSession.lastLoginTime);
        JoinList list = new JoinList("\n");
        list.add("Utilisateur: ", user.getText());
        list.add("Derni\u00e8re connexion: ", lastLoginTime);
        list.add("Personne: ", StringUtils.defaultString((String)user.getPersonName()));
        list.add("Derni\u00e8re activit\u00e9e: ", lastActivityTime);
        return list.toString();
    }

    public Image getImage() {
        return ResourceGetter.getImage((String)"images/person_lock.gif");
    }

    public String getEditorClass() {
        return null;
    }

    public IEditorInput getEditorInput() {
        return null;
    }

    public void showContextMenu(Control control) {
        Menu menu = control.getMenu();
        if (menu == null || menu.isDisposed()) {
            menu = new Menu(control);
            menu.setVisible(true);
        }
        MenuItem item = new MenuItem(menu, 8);
        item.setText("Fermer la session");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    Callback callback = new Callback(){

                        public void responseReceived(ReturnObject response) {
                            Display.getDefault().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    ActiveSessionElement.this.dispose();
                                }
                            });
                        }

                        public void exception(Exception e) {
                            super.exception(e);
                        }
                    };
                    LoginAccessorClient.getInstance().logOut(Application.get().getGlobalInstances().getSession(), (ICallback)callback, ((ActiveSessionElement)ActiveSessionElement.this).activeSession.id);
                }
                catch (CannotConnectToServerException e1) {
                    logger.log(Level.INFO, "Failed to logout " + ActiveSessionElement.this.activeSession, e1);
                }
                catch (Exception e1) {
                    logger.log(Level.SEVERE, "Failed to logout " + ActiveSessionElement.this.activeSession, e1);
                }
            }
        });
    }

    protected void dispose() {
        this.parent.removeFromChildren(this);
    }

    public int hashCode() {
        return this.parent.hashCode() + super.hashCode();
    }

    public boolean equals(Object toCompare) {
        boolean ret = false;
        if (toCompare instanceof ActiveSessionElement && toCompare.hashCode() == this.hashCode()) {
            ret = true;
        }
        return ret;
    }

    public void doKeyListener(Control control, KeyEvent ke) {
    }

    public XImageDecorator getDecorators() {
        return null;
    }

    public int getChildrenNumberForPastille() {
        return 0;
    }
}

