/*
 * Decompiled with CFR 0.152.
 */
package org.nightlabs.util.ds;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import org.nightlabs.util.ds.CycleException;
import org.nightlabs.util.ds.DirectedGraphNode;
import org.nightlabs.util.ds.IDirectedGraphNode;

public class DirectedGraph<T> {
    private Map<T, DirectedGraphNode<T>> nodes = new HashMap<T, DirectedGraphNode<T>>();

    public DirectedGraph(Collection<? extends IDirectedGraphNode<T>> elems) {
        for (IDirectedGraphNode<T> elem : elems) {
            this.nodes.put(elem.getValue(), new DirectedGraphNode<T>(elem.getValue()));
        }
        for (IDirectedGraphNode<T> elem : elems) {
            for (T dep : elem.getChildren()) {
                this.nodes.get(elem).addChild(this.nodes.get(dep));
            }
        }
    }

    public List<DirectedGraphNode<T>> sortNodesTopologically() throws CycleException {
        return this.sortNodesTopologically(null);
    }

    public List<DirectedGraphNode<T>> sortNodesTopologically(final Comparator<T> comparator) throws CycleException {
        AbstractCollection inDegreeZeroQueue;
        ArrayList<DirectedGraphNode<T>> remainingNodes = new ArrayList<DirectedGraphNode<T>>();
        ArrayList<DirectedGraphNode<T>> sortedNodes = new ArrayList<DirectedGraphNode<T>>();
        if (comparator != null) {
            Comparator nodeComparator = new Comparator<DirectedGraphNode<T>>(){

                @Override
                public int compare(DirectedGraphNode<T> o1, DirectedGraphNode<T> o2) {
                    return comparator.compare(o1.getElement(), o2.getElement());
                }
            };
            inDegreeZeroQueue = new PriorityQueue(10, nodeComparator);
        } else {
            inDegreeZeroQueue = new LinkedList();
        }
        for (DirectedGraphNode<T> node : this.nodes.values()) {
            node.storeInDegree();
            if (node.getInDegree() == 0) {
                inDegreeZeroQueue.add(node);
                continue;
            }
            remainingNodes.add(node);
        }
        while (!inDegreeZeroQueue.isEmpty()) {
            DirectedGraphNode source = (DirectedGraphNode)inDegreeZeroQueue.poll();
            sortedNodes.add(source);
            for (DirectedGraphNode depNode : source.getChildren()) {
                depNode.decrementInDegree();
                if (depNode.getInDegree() != 0) continue;
                inDegreeZeroQueue.add(depNode);
                remainingNodes.remove(depNode);
            }
        }
        for (DirectedGraphNode<T> node : this.nodes.values()) {
            node.restoreInDegree();
        }
        if (!remainingNodes.isEmpty()) {
            throw new CycleException(((Object)remainingNodes).toString());
        }
        return sortedNodes;
    }

    public List<T> sortElementsTopologically(Comparator<T> comparator) throws CycleException {
        List<DirectedGraphNode<T>> sortedNodes = this.sortNodesTopologically(comparator);
        ArrayList<T> sortedElements = new ArrayList<T>();
        for (DirectedGraphNode<T> node : sortedNodes) {
            sortedElements.add(node.getElement());
        }
        return sortedElements;
    }

    public List<T> sortElementsTopologically() throws CycleException {
        return this.sortElementsTopologically(null);
    }

    public String toString() {
        String toReturn = "";
        for (DirectedGraphNode<T> node : this.nodes.values()) {
            toReturn = String.valueOf(toReturn) + node.toString() + " {";
            for (DirectedGraphNode<T> child : node.getChildren()) {
                toReturn = String.valueOf(toReturn) + child.toString() + ",";
            }
            toReturn = String.valueOf(toReturn) + "}\n";
        }
        return toReturn;
    }
}

