/*
 * Decompiled with CFR 0.152.
 */
package org.nightlabs.util.bean.propertyeditor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.nightlabs.util.bean.BeanUtil;
import org.nightlabs.util.bean.DefaultPropertyEditorContext;
import org.nightlabs.util.bean.PropertyEditorMan;
import org.nightlabs.util.bean.propertyeditor.PaintableEditor;
import org.nightlabs.util.bean.propertyeditor.PropertyEditorUIException;

public class PropertyEditorUI
extends JPanel {
    private boolean differentValues = false;
    private boolean saveAllValues = false;
    private boolean readOnly = false;
    private Object firstBean;
    private Object firstValue;
    private Method getMethod;
    private Method setMethod;
    private PropertyEditor editor;
    private int editorType;
    private Component component;
    private String propertyName;
    static final int EDITOR_CUSTOM = 0;
    static final int EDITOR_PAINTABLE = 1;
    static final int EDITOR_STRING = 2;

    public boolean isDifferentValues() {
        return this.differentValues;
    }

    public boolean isSaveAllValues() {
        return this.saveAllValues;
    }

    public void setSaveAllValues(boolean b) {
        this.saveAllValues = b;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public PropertyEditor getPropertyEditor() {
        return this.editor;
    }

    public Component getComponent() {
        return this.component;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String getPropertyName(String methodName) {
        return BeanUtil.getPropertyName(methodName, false);
    }

    public PropertyEditorUI(PropertyDescriptor pd) {
        this.editor = PropertyEditorMan.getPropertyEditor(DefaultPropertyEditorContext.class, pd.getPropertyType());
        this.getMethod = pd.getReadMethod();
        this.setMethod = pd.getWriteMethod();
        this.propertyName = pd.getName();
        this.init();
    }

    public PropertyEditorUI(PropertyEditor editor, Method getMethod, Method setMethod) {
        if (editor == null || getMethod == null) {
            throw new IllegalArgumentException();
        }
        this.editor = editor;
        this.getMethod = getMethod;
        this.setMethod = setMethod;
        this.propertyName = this.getPropertyName(getMethod.getName());
        this.init();
    }

    private void init() {
        this.editorType = this.editor.supportsCustomEditor() ? 0 : (this.editor.isPaintable() ? 1 : 2);
        if (this.setMethod == null) {
            this.readOnly = true;
        }
        switch (this.editorType) {
            case 0: {
                this.component = this.editor.getCustomEditor();
                if (!this.readOnly) break;
                this.component.setEnabled(false);
                break;
            }
            case 1: {
                this.component = new PaintableEditor(this.editor);
                if (!this.readOnly) break;
                this.component.setEnabled(false);
                break;
            }
            case 2: {
                this.component = new JTextField();
                if (!this.readOnly) break;
                this.component.setEnabled(false);
            }
        }
        this.setLayout(new BorderLayout());
        this.add(this.component);
    }

    public int getEditorType() {
        return this.editorType;
    }

    public void load(List beans) throws PropertyEditorUIException {
        int i = 0;
        while (i < beans.size()) {
            Object bean = beans.get(i);
            try {
                Object value = this.getMethod.invoke(bean, null);
                if (this.firstValue == null) {
                    this.firstValue = value;
                    this.firstBean = bean;
                    this.editor.setValue(this.firstValue);
                    if (this.editorType == 2) {
                        ((JTextField)this.component).setText(this.editor.getAsText());
                    }
                    this.component.repaint();
                } else if (!this.firstValue.equals(value)) {
                    this.differentValues = true;
                }
            }
            catch (IllegalAccessException e1) {
                throw new PropertyEditorUIException(e1);
            }
            catch (IllegalArgumentException e2) {
                throw new PropertyEditorUIException(e2);
            }
            catch (InvocationTargetException e3) {
                throw new PropertyEditorUIException(e3);
            }
            ++i;
        }
    }

    public void load(Object bean) throws PropertyEditorUIException {
        try {
            Object value = this.getMethod.invoke(bean, null);
            if (this.firstValue == null) {
                this.firstValue = value;
                this.firstBean = bean;
                this.editor.setValue(this.firstValue);
                if (this.editorType == 2) {
                    ((JTextField)this.component).setText(this.editor.getAsText());
                }
                this.component.repaint();
            }
        }
        catch (IllegalAccessException e1) {
            throw new PropertyEditorUIException(e1);
        }
        catch (IllegalArgumentException e2) {
            throw new PropertyEditorUIException(e2);
        }
        catch (InvocationTargetException e3) {
            throw new PropertyEditorUIException(e3);
        }
    }

    public void save(List beans) throws PropertyEditorUIException {
        boolean commitValue = false;
        if (this.editorType == 2) {
            this.editor.setAsText(((JTextField)this.component).getText());
        }
        Object value = this.editor.getValue();
        if (this.firstValue == null) {
            throw new IllegalStateException("you must first load values before you can save!");
        }
        commitValue = !this.firstValue.equals(value);
        try {
            if (commitValue) {
                if (this.saveAllValues) {
                    for (Object bean : beans) {
                        if (this.setMethod == null) continue;
                        this.setMethod.invoke(bean, value);
                    }
                } else if (this.setMethod != null) {
                    this.setMethod.invoke(this.firstBean, value);
                }
            }
        }
        catch (IllegalAccessException e1) {
            throw new PropertyEditorUIException(e1);
        }
        catch (IllegalArgumentException e2) {
            throw new PropertyEditorUIException(e2);
        }
        catch (InvocationTargetException e3) {
            throw new PropertyEditorUIException(e3);
        }
    }

    public void save(Object bean) throws PropertyEditorUIException {
        if (this.editorType == 2) {
            this.editor.setAsText(((JTextField)this.component).getText());
        }
        Object value = this.editor.getValue();
        boolean commitValue = false;
        if (this.firstValue == null) {
            throw new IllegalStateException("you must first load values before you can save!");
        }
        commitValue = !this.firstValue.equals(value);
        try {
            if (commitValue && this.setMethod != null) {
                this.setMethod.invoke(bean, value);
            }
        }
        catch (IllegalAccessException e1) {
            throw new PropertyEditorUIException(e1);
        }
        catch (IllegalArgumentException e2) {
            throw new PropertyEditorUIException(e2);
        }
        catch (InvocationTargetException e3) {
            throw new PropertyEditorUIException(e3);
        }
    }
}

