/*
 * Decompiled with CFR 0.152.
 */
package org.nightlabs.config;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.nightlabs.config.ConfigException;
import org.nightlabs.config.ConfigFactory;
import org.nightlabs.config.ConfigInclude;
import org.nightlabs.config.ConfigIncludes;
import org.nightlabs.config.ConfigModule;
import org.nightlabs.config.ConfigModuleNotFoundException;

public class Config {
    private static final Logger logger = Logger.getLogger(Config.class);
    public static final char beforeIdentifier = '-';
    public static final char beforeMidfix = '-';
    public static final char beforeClassName = '-';
    private static Config sharedInstance;
    public static final String PROPERTY_KEY_CONFIG_FACTORY;
    private static ConfigFactory configFactory;
    private File configFile;
    private File configDir;
    private String includeFileMidfix;
    private boolean loaded = false;
    private HashMap<String, ConfigModule> configModules = new HashMap();
    private HashMap<String, ConfigModule> includedCfModsByFileName = new HashMap();
    private HashMap<ConfigModule, String> includedCfModsByCfMod = new HashMap();
    protected Object saveMutex = new Object();
    private HashSet<String> _lazyConfigModules = null;
    private Set<String> loadedConfigModuleClassNames = new HashSet<String>();

    static {
        PROPERTY_KEY_CONFIG_FACTORY = ConfigFactory.class.getName();
        configFactory = null;
    }

    private static synchronized ConfigFactory getConfigFactory() {
        if (configFactory == null) {
            Class<?> configFactoryClass;
            String configFactoryClassName = System.getProperty(PROPERTY_KEY_CONFIG_FACTORY);
            if (configFactoryClassName == null) {
                return null;
            }
            try {
                configFactoryClass = Class.forName(configFactoryClassName);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("The system-property '" + PROPERTY_KEY_CONFIG_FACTORY + "' was specified as '" + configFactoryClassName + "' but this class cannot be found!", e);
            }
            try {
                configFactory = (ConfigFactory)configFactoryClass.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("Instantiating the class '" + configFactoryClassName + "' specified by the system-property '" + PROPERTY_KEY_CONFIG_FACTORY + "' was found, but it could not be instantiated!", e);
            }
        }
        return configFactory;
    }

    public static boolean isSharedInstanceExisting() {
        ConfigFactory configFactory = Config.getConfigFactory();
        if (configFactory != null) {
            return configFactory.isSharedInstanceExisting();
        }
        return sharedInstance != null;
    }

    @Deprecated
    public static boolean isConfigExisting() {
        return Config.isSharedInstanceExisting();
    }

    @Deprecated
    public static Config createSharedInstance(String configFile, boolean loadConfFile, String configDir) throws ConfigException {
        ConfigFactory configFactory = Config.getConfigFactory();
        if (configFactory != null) {
            throw new IllegalStateException("This deprecated method is not supported when using a ConfigFactory!");
        }
        sharedInstance = new Config(configFile, loadConfFile, configDir);
        return sharedInstance;
    }

    public static Config createSharedInstance(File configFile) throws ConfigException {
        ConfigFactory configFactory = Config.getConfigFactory();
        if (configFactory != null) {
            return configFactory.createSharedInstance(configFile);
        }
        return Config.createSharedInstance(configFile, true);
    }

    public static Config createSharedInstance(File configFile, boolean loadConfFile) throws ConfigException {
        ConfigFactory configFactory = Config.getConfigFactory();
        if (configFactory != null) {
            return configFactory.createSharedInstance(configFile, loadConfFile);
        }
        sharedInstance = new Config(configFile, loadConfFile);
        return sharedInstance;
    }

    public static Config sharedInstance(boolean throwExceptionIfNotExisting) {
        ConfigFactory configFactory = Config.getConfigFactory();
        if (configFactory != null) {
            return configFactory.sharedInstance(throwExceptionIfNotExisting);
        }
        if (sharedInstance == null && throwExceptionIfNotExisting) {
            throw new IllegalStateException("Shared instance of Config was not yet created! You have to execute createSharedInstance() before using sharedInstance()!");
        }
        return sharedInstance;
    }

    public static Config sharedInstance() {
        return Config.sharedInstance(true);
    }

    protected void assertLoaded() {
        if (!this.loaded) {
            throw new IllegalStateException("load(...) has not been called!");
        }
    }

    protected boolean isLazyConfigModule(ConfigModule cfMod) {
        return this._lazyConfigModules != null && this._lazyConfigModules.contains(Config.getConfigModuleIdentifyingName(cfMod));
    }

    protected void registerLazyConfigModule(ConfigModule cfMod) {
        if (this._lazyConfigModules == null) {
            this._lazyConfigModules = new HashSet();
        }
        this._lazyConfigModules.add(Config.getConfigModuleIdentifyingName(cfMod));
    }

    protected void removeLazyConfigModule(ConfigModule cfMod) {
        if (this._lazyConfigModules == null) {
            return;
        }
        this._lazyConfigModules.remove(Config.getConfigModuleIdentifyingName(cfMod));
    }

    public Config(InputStream configStream) throws ConfigException {
        this.readFromInputStream(configStream);
    }

    @Deprecated
    public Config(String configFile, boolean loadConfFile, String configDir) throws ConfigException {
        this(new File(configDir, configFile), loadConfFile);
    }

    public Config(File configFile) throws ConfigException {
        this(configFile, true);
    }

    public Config(File configFile, boolean loadConfFile) throws ConfigException {
        this.setConfigFile(configFile);
        if (loadConfFile) {
            this.load(null);
        }
    }

    public File getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(File configFile) {
        this.loaded = false;
        this.configFile = configFile;
        this.configDir = configFile.getParentFile();
        this.loadedConfigModuleClassNames.clear();
        this.configModules.clear();
        if (this._lazyConfigModules != null) {
            this._lazyConfigModules.clear();
        }
    }

    public File getConfigDir() {
        return this.configDir;
    }

    public void load() throws ConfigException {
        this.load(null);
    }

    public void load(String includeFileMidfix) throws ConfigException {
        try {
            ConfigIncludes configIncludes;
            logger.info((Object)("Loading config with includeFileMidfix=\"" + includeFileMidfix + "\""));
            this.loaded = true;
            this.configModules.clear();
            this.loadedConfigModuleClassNames.clear();
            this.loadedConfigModuleClassNames.add(ConfigIncludes.class.getName());
            if (this._lazyConfigModules != null) {
                this._lazyConfigModules.clear();
            }
            if (this.configFile.exists()) {
                FileInputStream fin = new FileInputStream(this.configFile);
                this.readFromInputStream(fin);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Config file read: " + this.configFile.getAbsolutePath()));
                }
            }
            if ((configIncludes = (ConfigIncludes)this.getConfigModule(ConfigIncludes.class, false)) == null) {
                configIncludes = new ConfigIncludes();
                configIncludes._setConfig(this);
                configIncludes.init();
                this.putConfigModule(configIncludes);
            }
        }
        catch (ConfigException x) {
            this.loaded = false;
            throw x;
        }
        catch (Throwable x) {
            this.loaded = false;
            throw new ConfigException(x);
        }
    }

    private void loadConfigModulesForClass(String configModuleClassName) {
        this.assertLoaded();
        if (this.loadedConfigModuleClassNames.contains(configModuleClassName)) {
            return;
        }
        this.loadedConfigModuleClassNames.add(configModuleClassName);
        ConfigIncludes configIncludes = (ConfigIncludes)this.getConfigModule(ConfigIncludes.class, true);
        List<ConfigInclude> configIncludeList = configIncludes.getConfigIncludeListForConfigModuleClass(configModuleClassName);
        if (configIncludeList == null) {
            return;
        }
        for (ConfigInclude configInclude : configIncludeList) {
            String relativeIncludeFileNameOrg = configInclude.getIncludeFile();
            String relativeIncludeFileNameWithMidfix = Config.createIncludeFileName(relativeIncludeFileNameOrg, null, this.includeFileMidfix);
            try {
                URL includeFileURL;
                File includeFile = new File(this.configDir, relativeIncludeFileNameWithMidfix);
                if (includeFile.exists()) {
                    includeFileURL = includeFile.toURI().toURL();
                } else {
                    URL url = null;
                    if (configInclude.getSearchClass() != null) {
                        url = Class.forName(configInclude.getSearchClass()).getResource(relativeIncludeFileNameWithMidfix);
                    }
                    if (url == null && (url = Class.forName(configInclude.getIncludeClass()).getResource(relativeIncludeFileNameWithMidfix)) == null) {
                        throw new ConfigException("Configuration file " + relativeIncludeFileNameWithMidfix + " cannot be found. File does not exist in ConfigDir or class resource directory.");
                    }
                    includeFileURL = url;
                }
                try (InputStream in = includeFileURL.openStream();){
                    ConfigModule cfMod;
                    try (XMLDecoder d = new XMLDecoder(in);){
                        cfMod = (ConfigModule)d.readObject();
                        cfMod.setChanged(false);
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Config file read: " + includeFileURL));
                        }
                    }
                    cfMod._setConfig(this);
                    cfMod.init();
                    this.putIncludedCfMod(relativeIncludeFileNameWithMidfix, cfMod);
                    this.configModules.put(Config.getConfigModuleIdentifyingName(cfMod), cfMod);
                }
            }
            catch (Exception x) {
                logger.warn((Object)("Unable to load config module file: " + relativeIncludeFileNameWithMidfix), (Throwable)x);
            }
        }
    }

    @Deprecated
    public void loadConfFile() throws ConfigException {
        this.load(null);
    }

    @Deprecated
    public void loadConfFile(String includeFileMidfix) throws ConfigException {
        this.load(includeFileMidfix);
    }

    public void save() throws ConfigException {
        this.save(null, false);
    }

    public void save(boolean forceSaveAllModules) throws ConfigException {
        this.save(null, forceSaveAllModules);
    }

    public void save(String includeFileMidfix) throws ConfigException {
        this.save(includeFileMidfix, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(String includeFileMidfix, boolean forceSaveAllModules) throws ConfigException {
        Object object = this.saveMutex;
        synchronized (object) {
            logger.info((Object)("Saving config with includeFileMidfix=\"" + includeFileMidfix + "\""));
            try {
                ArrayList<ConfigModule> internalConfigModules = new ArrayList<ConfigModule>(this.configModules.size());
                ConfigIncludes configIncludes = null;
                HashSet<ConfigInclude> origIncludes = null;
                configIncludes = (ConfigIncludes)this.getConfigModule(ConfigIncludes.class, false);
                if (configIncludes == null) {
                    configIncludes = new ConfigIncludes();
                    configIncludes._setConfig(this);
                    configIncludes.init();
                    this.putConfigModule(configIncludes);
                } else {
                    origIncludes = new HashSet<ConfigInclude>(configIncludes.getConfigIncludes());
                    configIncludes.getConfigIncludes().clear();
                }
                HashMap<String, ConfigModule> changedIncludedConfigModules = new HashMap<String, ConfigModule>();
                for (Map.Entry<String, ConfigModule> entry : this.configModules.entrySet()) {
                    ConfigModule cfMod = entry.getValue();
                    String relativeCfIncFileName = this.getIncludedCfModFileName(cfMod);
                    ConfigInclude cfInc = new ConfigInclude(cfMod, relativeCfIncFileName);
                    if (origIncludes != null) {
                        origIncludes.remove(cfInc);
                    }
                    if (relativeCfIncFileName == null) {
                        internalConfigModules.add(cfMod);
                        continue;
                    }
                    if (!this.isLazyConfigModule(cfMod) || cfMod._isChanged() || forceSaveAllModules) {
                        configIncludes.getConfigIncludes().add(new ConfigInclude(cfMod, relativeCfIncFileName));
                    }
                    if (!cfMod._isChanged() && !forceSaveAllModules) continue;
                    changedIncludedConfigModules.put(relativeCfIncFileName, this.includedCfModsByFileName.get(relativeCfIncFileName));
                }
                if (origIncludes != null) {
                    for (ConfigInclude configInclude : origIncludes) {
                        configIncludes.getConfigIncludes().add(configInclude);
                    }
                }
                String tmpCf = String.valueOf(this.configFile.getAbsolutePath()) + ".new";
                FileOutputStream fileOutputStream = new FileOutputStream(tmpCf);
                XMLEncoder encoder = new XMLEncoder(fileOutputStream);
                encoder.writeObject(internalConfigModules);
                encoder.close();
                fileOutputStream.close();
                if (!changedIncludedConfigModules.isEmpty()) {
                    for (Map.Entry entry : changedIncludedConfigModules.entrySet()) {
                        String includedConfigModuleFilename = (String)entry.getKey();
                        ConfigModule includedConfigModule = (ConfigModule)entry.getValue();
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("waiting for readLock of configModule \"" + includedConfigModuleFilename + "\"..."));
                        }
                        includedConfigModule.acquireReadLock();
                        try {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("got readLock of configModule \"" + includedConfigModuleFilename + "\". Opening file..."));
                            }
                            File tmpCfModFile = new File(this.configDir, String.valueOf(includedConfigModuleFilename) + ".new");
                            FileOutputStream fileOutputStream2 = new FileOutputStream(tmpCfModFile);
                            encoder = new XMLEncoder(fileOutputStream2);
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("opened file for configModule \"" + includedConfigModuleFilename + "\". writing object..."));
                            }
                            encoder.writeObject(includedConfigModule);
                            includedConfigModule.setChanged(false);
                            encoder.close();
                            fileOutputStream2.close();
                            if (this.isLazyConfigModule(includedConfigModule)) {
                                this.removeLazyConfigModule(includedConfigModule);
                            }
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("configModule \"" + includedConfigModuleFilename + "\" written."));
                            }
                        }
                        finally {
                            includedConfigModule.releaseLock();
                        }
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug((Object)("read lock of configModule \"" + includedConfigModuleFilename + "\" released."));
                    }
                }
                this.configFile.delete();
                File nf = new File(tmpCf);
                nf.renameTo(this.configFile);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Config file written: " + this.configFile.getAbsolutePath()));
                }
                if (!changedIncludedConfigModules.isEmpty()) {
                    for (String includedConfigModuleFilename : changedIncludedConfigModules.keySet()) {
                        File tmpCfModFile = new File(this.configDir, String.valueOf(includedConfigModuleFilename) + ".new");
                        File cfModFile = new File(this.configDir, includedConfigModuleFilename);
                        cfModFile.delete();
                        tmpCfModFile.renameTo(cfModFile);
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug((Object)("Config file written: " + cfModFile.getAbsolutePath()));
                    }
                }
            }
            catch (Exception x) {
                throw new ConfigException(x);
            }
        }
    }

    @Deprecated
    public void saveConfFile() throws ConfigException {
        this.save();
    }

    @Deprecated
    public void saveConfFile(boolean forceSaveAllModules) throws ConfigException {
        this.save(forceSaveAllModules);
    }

    @Deprecated
    public void saveConfFile(String includeFileMidfix) throws ConfigException {
        this.save(includeFileMidfix);
    }

    @Deprecated
    public void saveConfFile(String includeFileMidfix, boolean forceSaveAllModules) throws ConfigException {
        this.save(includeFileMidfix, forceSaveAllModules);
    }

    public ConfigModule createConfigModule(Class configModuleClass) throws ConfigException {
        return this.createConfigModule(configModuleClass, null);
    }

    public ConfigModule createConfigModule(Class configModuleClass, String identifier) throws ConfigException {
        this.loadConfigModulesForClass(configModuleClass.getName());
        try {
            ConfigModule cfMod = this.configModules.get(Config.getConfigModuleIdentifyingName(configModuleClass, identifier));
            if (cfMod == null) {
                cfMod = (ConfigModule)configModuleClass.newInstance();
                cfMod._setConfig(this);
                cfMod.setIdentifier(identifier);
                cfMod.init();
                this.configModules.put(Config.getConfigModuleIdentifyingName(cfMod), cfMod);
                this.registerLazyConfigModule(cfMod);
            }
            StringBuffer sbPrefix = new StringBuffer(this.configFile.getName());
            int lastSlashPos = sbPrefix.lastIndexOf(File.separator);
            sbPrefix.delete(0, lastSlashPos + 1);
            int lastDotPos = sbPrefix.lastIndexOf(".");
            if (lastDotPos == -1) {
                lastDotPos = sbPrefix.length();
            }
            String suffix = sbPrefix.substring(lastDotPos);
            sbPrefix.delete(lastDotPos, sbPrefix.length());
            this.putIncludedCfMod(String.valueOf(sbPrefix.toString()) + '-' + Config.getConfigModuleIdentifyingName(cfMod) + suffix, cfMod);
            return cfMod;
        }
        catch (Throwable t) {
            throw new ConfigException(t);
        }
    }

    public ConfigModule getConfigModule(String configModuleClassName) {
        return this.getConfigModule(configModuleClassName, null, true);
    }

    public ConfigModule getConfigModule(String configModuleClassName, String identifier) {
        return this.getConfigModule(configModuleClassName, identifier, true);
    }

    public ConfigModule getConfigModule(String configModuleClassName, boolean throwExceptionIfNotExistent) {
        return this.getConfigModule(configModuleClassName, null, throwExceptionIfNotExistent);
    }

    public ConfigModule getConfigModule(String configModuleClassName, String identifier, boolean throwExceptionIfNotExistent) {
        this.loadConfigModulesForClass(configModuleClassName);
        ConfigModule cfMod = this.configModules.get(Config.getConfigModuleIdentifyingName(configModuleClassName, identifier));
        if (cfMod == null && throwExceptionIfNotExistent) {
            throw new ConfigModuleNotFoundException("No ConfigModule of type \"" + configModuleClassName + "\" existent!");
        }
        return cfMod;
    }

    public ConfigModule getConfigModule(Class configModuleClass) {
        return this.getConfigModule(configModuleClass.getName(), null, true);
    }

    public ConfigModule getConfigModule(Class configModuleClass, String identifier) {
        return this.getConfigModule(configModuleClass.getName(), identifier, true);
    }

    public ConfigModule getConfigModule(Class configModuleClass, boolean throwExceptionIfNotExistent) {
        return this.getConfigModule(configModuleClass.getName(), null, throwExceptionIfNotExistent);
    }

    public ConfigModule getConfigModule(Class configModuleClass, String identifier, boolean throwExceptionIfNotExistent) {
        return this.getConfigModule(configModuleClass.getName(), identifier, throwExceptionIfNotExistent);
    }

    public void putConfigModule(ConfigModule configModule) {
        String cfModFileName = this.getIncludedCfModFileName(configModule);
        if (cfModFileName != null) {
            this.includedCfModsByFileName.remove(cfModFileName);
            this.includedCfModsByCfMod.remove(configModule);
        }
        this.configModules.put(Config.getConfigModuleIdentifyingName(configModule), configModule);
    }

    private void readFromInputStream(InputStream fin) throws ConfigException {
        try {
            XMLDecoder d = new XMLDecoder(fin);
            List ls = (List)d.readObject();
            d.close();
            fin.close();
            this.configModules.clear();
            for (ConfigModule cfMod : ls) {
                cfMod._setConfig(this);
                cfMod.init();
                this.configModules.put(Config.getConfigModuleIdentifyingName(cfMod), cfMod);
                this.loadedConfigModuleClassNames.add(cfMod.getClass().getName());
            }
        }
        catch (Exception x) {
            throw new ConfigException(x);
        }
    }

    protected void putIncludedCfMod(String relativeCfModFileName, ConfigModule cfMod) {
        this.includedCfModsByFileName.put(relativeCfModFileName, cfMod);
        this.includedCfModsByCfMod.put(cfMod, relativeCfModFileName);
    }

    protected ConfigModule getIncludedCfMod(String relativeCfModFileName) {
        return this.includedCfModsByFileName.get(relativeCfModFileName);
    }

    protected String getIncludedCfModFileName(ConfigModule cfMod) {
        return this.includedCfModsByCfMod.get(cfMod);
    }

    private static String createIncludeFileName(String orgFileName, String identifier, String midfix) {
        String ext;
        boolean haveMidfix;
        boolean haveIdentifier = identifier != null && !identifier.equals("");
        boolean bl = haveMidfix = midfix != null && !midfix.equals("");
        if (!haveMidfix && !haveIdentifier) {
            return orgFileName;
        }
        StringBuffer sb = new StringBuffer(orgFileName);
        int lastDotPos = sb.lastIndexOf(".");
        if (lastDotPos != -1) {
            ext = sb.substring(lastDotPos);
            sb.delete(lastDotPos, sb.length());
        } else {
            ext = "";
        }
        if (haveIdentifier) {
            sb.append('-');
            sb.append(identifier);
            sb.append(ext);
        }
        if (haveMidfix) {
            sb.append('-');
            sb.append(midfix);
            sb.append(ext);
        }
        return sb.toString();
    }

    private static String getConfigModuleIdentifyingName(ConfigModule module) {
        return Config.getConfigModuleIdentifyingName(module.getClass(), module.getIdentifier());
    }

    private static String getConfigModuleIdentifyingName(Class moduleClass, String identifier) {
        return Config.getConfigModuleIdentifyingName(moduleClass.getName(), identifier);
    }

    private static String getConfigModuleIdentifyingName(String moduleClassName, String identifier) {
        StringBuffer result = new StringBuffer(moduleClassName);
        if (identifier != null && !identifier.equals("")) {
            result.append('-');
            result.append(identifier);
        }
        return result.toString();
    }
}

