/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.library.log;

import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import org.apache.commons.lang3.time.FastDateFormat;
import org.eclipse.core.runtime.Platform;

public class MedoStatsLogFormatter
extends Formatter {
    private static final String SESSION = "!SESSION";
    private static final String MESSAGE = "!MESSAGE";
    private static final String LINE_SEPARATOR = "\n";
    private FastDateFormat simpleDateFormat;
    private SimpleFormatter logFormatter = new SimpleFormatter();

    public MedoStatsLogFormatter() {
        this.simpleDateFormat = FastDateFormat.getInstance((String)"yyyy/MM/dd HH:mm:ss.SS");
    }

    @Override
    public String format(LogRecord record) {
        StringBuilder b = new StringBuilder(2000);
        b.append(this.getHeader());
        b.append(LINE_SEPARATOR);
        b.append(MESSAGE);
        b.append(LINE_SEPARATOR);
        b.append(this.logFormatter.format(record));
        b.append("\n\nContext\n\n");
        b.append(this.formatParameters(record));
        return b.toString();
    }

    private String formatParameters(LogRecord record) {
        Object[] parameters = record.getParameters();
        if (parameters != null && parameters.length > 0) {
            StringBuilder b = new StringBuilder(parameters.length * 50);
            Object[] objectArray = parameters;
            int n = parameters.length;
            int n2 = 0;
            while (n2 < n) {
                Object p = objectArray[n2];
                try {
                    b.append(String.valueOf(p));
                    b.append(LINE_SEPARATOR);
                }
                catch (Exception exception) {
                    b.append("Failed to print parameters");
                    b.append(LINE_SEPARATOR);
                }
                ++n2;
            }
            return b.toString();
        }
        return "";
    }

    private String getHeader() {
        StringBuilder sb = new StringBuilder();
        sb.append(SESSION).append(" ").append(this.getDate()).append(LINE_SEPARATOR);
        try {
            String key = "java.fullversion";
            String value = System.getProperty(key);
            if (value == null) {
                key = "java.version";
                value = System.getProperty(key);
                sb.append(String.valueOf(key) + "=" + value).append(LINE_SEPARATOR);
                key = "java.vendor";
                value = System.getProperty(key);
                sb.append(String.valueOf(key) + "=" + value).append(LINE_SEPARATOR);
            } else {
                sb.append(String.valueOf(key) + "=" + value).append(LINE_SEPARATOR);
            }
        }
        catch (Exception exception) {}
        try {
            sb.append("BootLoader constants: OS=" + Platform.getOS());
        }
        catch (Exception exception) {}
        try {
            sb.append(", ARCH=" + Platform.getOSArch());
        }
        catch (Exception exception) {}
        try {
            sb.append(", WS=" + Platform.getWS());
        }
        catch (Exception exception) {}
        try {
            sb.append(", NL=" + Platform.getNL()).append(LINE_SEPARATOR);
        }
        catch (Exception exception) {}
        try {
            String[] args = Platform.getApplicationArgs();
            if (args != null && args.length > 0) {
                sb.append("Command-line arguments:");
                String[] stringArray = args;
                int n = args.length;
                int n2 = 0;
                while (n2 < n) {
                    String arg = stringArray[n2];
                    sb.append(" " + arg);
                    ++n2;
                }
                sb.append(LINE_SEPARATOR);
            }
        }
        catch (Exception exception) {}
        return sb.toString();
    }

    private synchronized String getDate() {
        try {
            return this.simpleDateFormat.format(new Date());
        }
        catch (Exception exception) {
            return Long.toString(System.currentTimeMillis());
        }
    }
}

