/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.library;

import ca.infodata.ofys.ui.library.LibPlugin;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class MyAbstractHandler
extends AbstractHandler {
    private static final Logger logger = Logger.getLogger(MyAbstractHandler.class.getName());

    protected IWorkbenchWindow getOrOpenActiveWorkbenchWindow(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow activeWorkbenchWindow = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        if (activeWorkbenchWindow == null) {
            int count = LibPlugin.getDefault().getWorkbench().getWorkbenchWindowCount();
            if (count == 0) {
                try {
                    Exception e = new Exception();
                    e.fillInStackTrace();
                    logger.log(Level.SEVERE, "Opening new workbent window, this should not happen", e);
                    LibPlugin.getDefault().getWorkbench().openWorkbenchWindow(null);
                }
                catch (WorkbenchException e) {
                    logger.log(Level.SEVERE, "Failed to open new workbench window", e);
                    throw new ExecutionException("Failed to open new workbench window", (Throwable)e);
                }
            } else {
                activeWorkbenchWindow = LibPlugin.getDefault().getWorkbench().getWorkbenchWindows()[0];
            }
        }
        if (activeWorkbenchWindow != null) {
            return activeWorkbenchWindow;
        }
        return HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
    }

    protected IWorkbenchPage getOrOpenActivePage(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = this.getOrOpenActiveWorkbenchWindow(event);
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            System.out.println("Active page is null");
            IWorkbenchPage[] pages = window.getPages();
            if (pages != null && pages.length > 0) {
                page = pages[0];
            }
        }
        if (page == null) {
            Exception e2 = new Exception();
            e2.fillInStackTrace();
            logger.log(Level.SEVERE, "Opening new active page, this should not happen", e2);
            try {
                page = window.openPage(null);
            }
            catch (WorkbenchException e) {
                throw new ExecutionException("Failed to open new workbench page", (Throwable)e);
            }
        }
        return page;
    }

    protected <T> T getServiceChecked(ExecutionEvent event, Class<T> serviceClass) throws ExecutionException {
        IWorkbenchWindow window = this.getOrOpenActiveWorkbenchWindow(event);
        Object service = window.getService(serviceClass);
        if (service == null) {
            throw new ExecutionException("Failed to get service " + serviceClass + ". maybe service was not registered");
        }
        return (T)service;
    }
}

