/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.eform;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.modules.eform.EformController;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.eform.XBaseEform;
import ca.infodata.ofys.data.middle.dataobjects.eform.XEform;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.status.MultiStatus;
import ca.infodata.ofys.status.StatusException;
import ca.infodata.ofys.ui.controls.ControlWrapper;
import ca.infodata.ofys.ui.controls.IControl;
import ca.infodata.ofys.ui.controls.form.MyButton;
import ca.infodata.ofys.ui.controls.form.MyLabel;
import ca.infodata.ofys.ui.controls.windows.AbstractSingleInputWindows;
import ca.infodata.ofys.ui.eform.EFormBrowserComposite;
import ca.infodata.ofys.ui.eform.EFormPlugin;
import ca.infodata.ofys.ui.eform.EformTreeContentProvider;
import ca.infodata.ofys.ui.library.UI;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.lang.reflect.InvocationTargetException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class EformManageDialog
extends AbstractSingleInputWindows {
    private static final Logger logger = Logger.getLogger(EformManageDialog.class.getName());
    protected ArrayList<XBaseEform> allForms = new ArrayList();
    protected ArrayList<XBaseEform> checkedEforms = new ArrayList();
    protected CheckboxTreeViewer list;
    protected EformController controller;

    public EformManageDialog(EformController controller) {
        super(UI.getWorkbenchShell(), Messages.getString((String)"GESTION_EFORMS_DU_CLIENT", (String[])new String[0]), null);
        this.controller = controller;
    }

    protected boolean btnPressed(int btnId) {
        if (btnId == 0) {
            this.save();
            EFormPlugin.getDefault().getFormCache().reload(true);
            EFormPlugin.getDefault().getFormFavCache().reload(true);
        }
        return true;
    }

    private void save() {
        final StatusException[] statusException = new StatusException[1];
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(UI.getWorkbenchShell());
        try {
            dialog.run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(Messages.getString((String)"GESTION_EFORMS_DU_CLIENT", (String[])new String[0]), -1);
                    try {
                        try {
                            ArrayList activeClientEForms = new ArrayList();
                            ArrayList<XBaseEform> formsToAdd = new ArrayList<XBaseEform>();
                            ArrayList<XBaseEform> formsToRemove = new ArrayList<XBaseEform>();
                            activeClientEForms.addAll(EformManageDialog.this.controller.getForms());
                            if (EformManageDialog.this.checkedEforms != null) {
                                for (XBaseEform eForm : EformManageDialog.this.checkedEforms) {
                                    if (activeClientEForms.contains(eForm)) continue;
                                    formsToAdd.add(eForm);
                                }
                                for (XBaseEform eForm : activeClientEForms) {
                                    if (EformManageDialog.this.checkedEforms.contains(eForm)) continue;
                                    formsToRemove.add(eForm);
                                }
                            }
                            IntArrayList listToAdd = new IntArrayList(formsToAdd.size());
                            for (XBaseEform f : formsToAdd) {
                                listToAdd.add(f.getId().intValue());
                            }
                            IntArrayList listRemove = new IntArrayList(formsToRemove.size());
                            for (XBaseEform f : formsToRemove) {
                                listRemove.add(f.getId().intValue());
                            }
                            EformManageDialog.this.controller.setActiveList(listToAdd.toIntArray());
                            EformManageDialog.this.controller.setInactiveList(listRemove.toIntArray());
                            monitor.done();
                        }
                        catch (StatusException e) {
                            statusException[0] = e;
                            monitor.done();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            MultiStatus status = new MultiStatus();
                            status.setSeverity(IStatus.Severity.ERROR);
                            status.setException((Throwable)e);
                            MultiStatus status2 = new MultiStatus();
                            status2.add((IStatus)status);
                            statusException[0] = new StatusException((IStatus)status2);
                            monitor.done();
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {}
        if (statusException[0] != null) {
            MessageUtil.show((Shell)UI.getWorkbenchShell(), (IStatus)statusException[0].getStatus());
        }
    }

    protected IControl createControlOverride(Composite parent, FormToolkit toolkit) {
        MyLabel lblInfo = new MyLabel(parent, 64);
        lblInfo.setText(Messages.getString((String)"GESTION_EFORMS_DU_CLIENT_INFO", (String[])new String[0]));
        this.allForms.addAll(this.controller.getAllFormsForAdmin());
        this.checkedEforms.addAll(this.controller.getForms());
        this.list = new CheckboxTreeViewer(parent, 2048){

            protected void handleDoubleSelect(SelectionEvent event) {
                if (event.item != null && event.item.getData() != null && event.item.getData() instanceof XBaseEform) {
                    XBaseEform e = (XBaseEform)event.item.getData();
                    try {
                        final XEform eform = EformManageDialog.this.controller.getFullEForm(e);
                        AbstractSingleInputWindows formWindow = new AbstractSingleInputWindows(UI.getWorkbenchShell(), eform.getName(), null){
                            private EFormBrowserComposite browser;

                            protected boolean btnPressed(int btnId) {
                                return true;
                            }

                            protected IControl createControlOverride(Composite parent, FormToolkit toolkit) {
                                if (toolkit == null) {
                                    toolkit = UI.createToolKit((Widget)parent);
                                }
                                toolkit.adapt(parent);
                                this.browser = new EFormBrowserComposite(parent, toolkit);
                                FormData data = new FormData();
                                data.top = new FormAttachment(0);
                                data.bottom = new FormAttachment(100);
                                data.left = new FormAttachment(0);
                                data.right = new FormAttachment(100);
                                data.height = 800;
                                data.width = 1024;
                                this.browser.setLayoutData(data);
                                this.browser.viewEForm(eform);
                                ControlWrapper control = new ControlWrapper((Control)this.browser);
                                return control;
                            }
                        };
                        formWindow.open();
                    }
                    catch (Exception e2) {
                        logger.log(Level.SEVERE, "Failed to open eform " + e, e2);
                    }
                }
            }
        };
        this.list.setContentProvider((IContentProvider)new EformTreeContentProvider());
        this.list.setLabelProvider((IBaseLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                XBaseEform x = (XBaseEform)element;
                return String.format("%s (%s) ", x.getName(), x.getLanguage());
            }
        });
        ViewerFilter filter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return true;
            }
        };
        this.list.setFilters(new ViewerFilter[]{filter});
        this.sortEForms(this.allForms);
        this.list.setInput(this.allForms);
        this.list.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isChecked(Object element) {
                XBaseEform x = (XBaseEform)element;
                return EformManageDialog.this.checkedEforms.contains(x);
            }

            public boolean isGrayed(Object element) {
                return false;
            }
        });
        this.list.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                XBaseEform x = (XBaseEform)event.getElement();
                if (event.getChecked()) {
                    EformManageDialog.this.checkedEforms.add(x);
                } else {
                    EformManageDialog.this.checkedEforms.remove(x);
                }
            }
        });
        parent.setLayout((Layout)new FormLayout());
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        lblInfo.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(lblInfo.getControl(), 5);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.height = 300;
        this.list.getTree().setLayoutData((Object)data);
        if (Application.get().getGlobalInstances().inDebugMode()) {
            MyButton button = new MyButton(parent, "Recharger la liste des formulaires favoris et disponibles", 8, toolkit);
            data = new FormData();
            data.top = new FormAttachment((Control)this.list.getTree(), 5);
            data.left = new FormAttachment(0);
            data.right = new FormAttachment(100);
            button.setLayoutData((Object)data);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    EFormPlugin.getDefault().getFormCache().reload(true);
                    EFormPlugin.getDefault().getFormFavCache().reload(true);
                }
            });
        }
        ControlWrapper control = new ControlWrapper((Control)this.list.getTree());
        return control;
    }

    private void sortEForms(List<XBaseEform> list) {
        final Collator collator = Collator.getInstance(Locale.CANADA_FRENCH);
        collator.setStrength(2);
        Collections.sort(list, new Comparator<XBaseEform>(){

            @Override
            public int compare(XBaseEform o1, XBaseEform o2) {
                return collator.compare(o1.getName(), o2.getName());
            }
        });
    }
}

