/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.eform;

import ca.infodata.ofys.data.middle.dataobjects.eform.XBaseEformData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class EFormDataContentProvider
implements ITreeContentProvider {
    private static final Object[] EMPTY = new Object[0];
    private List<XBaseEformData> list;
    private List<XBaseEformData> lastVersions;

    public EFormDataContentProvider(List<XBaseEformData> source) {
        if (source == null) {
            throw new NullPointerException("source");
        }
        this.list = source;
        this.lastVersions = new ArrayList<XBaseEformData>();
    }

    public boolean isLastVersion(XBaseEformData data) {
        return this.lastVersions.contains(data);
    }

    public Object[] getElements(Object input) {
        this.lastVersions.clear();
        if (this.list.isEmpty()) {
            return EMPTY;
        }
        Collections.sort(this.list, new Comparator<XBaseEformData>(){

            @Override
            public int compare(XBaseEformData o1, XBaseEformData o2) {
                if (o1.getIdAnchor() == null && o2.getIdAnchor() == null) {
                    return 0;
                }
                if (o1.getIdAnchor() == null) {
                    return -1;
                }
                if (o2.getIdAnchor() == null) {
                    return 1;
                }
                int i = o1.getIdAnchor().compareTo(o2.getIdAnchor());
                if (i == 0) {
                    if (o1.getId() == null && o2.getId() == null) {
                        return 0;
                    }
                    if (o1.getId() == null) {
                        return -1;
                    }
                    if (o2.getId() == null) {
                        return 1;
                    }
                    i = o1.getId().compareTo(o2.getId());
                }
                return -i;
            }
        });
        Integer idAnchor = null;
        for (XBaseEformData data : this.list) {
            if (data.getId() == null || data.getIdAnchor() == null) {
                this.lastVersions.add(data);
            } else if (!data.getIdAnchor().equals(idAnchor)) {
                this.lastVersions.add(data);
            }
            idAnchor = data.getIdAnchor();
        }
        Collections.sort(this.lastVersions, new Comparator<XBaseEformData>(){

            @Override
            public int compare(XBaseEformData o1, XBaseEformData o2) {
                if (o1.getId() == null && o2.getId() == null) {
                    return 0;
                }
                if (o1.getId() == null) {
                    return -1;
                }
                if (o2.getId() == null) {
                    return 1;
                }
                if (o1.getDatetime() == o2.getDatetime()) {
                    return 0;
                }
                if (o1.getDatetime() == null) {
                    return -1;
                }
                if (o2.getDatetime() == null) {
                    return 1;
                }
                return -o1.getDatetime().compareTo(o2.getDatetime());
            }
        });
        return this.lastVersions.toArray();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput instanceof List) {
            this.list = (List)newInput;
        }
    }

    public Object[] getChildren(Object element) {
        XBaseEformData data = (XBaseEformData)element;
        if (data.getId() == null || data.getIdAnchor() == null) {
            return EMPTY;
        }
        int i = this.list.indexOf(data);
        if (i == -1) {
            return EMPTY;
        }
        ArrayList<XBaseEformData> children = new ArrayList<XBaseEformData>(5);
        ++i;
        while (i < this.list.size()) {
            XBaseEformData d = this.list.get(i);
            if (!data.getIdAnchor().equals(d.getIdAnchor())) break;
            children.add(d);
            ++i;
        }
        return children.toArray();
    }

    public Object getParent(Object element) {
        XBaseEformData data = (XBaseEformData)element;
        if (data.getId() == null || data.getIdAnchor() == null) {
            return null;
        }
        for (XBaseEformData d : this.lastVersions) {
            if (!data.getIdAnchor().equals(d.getIdAnchor())) continue;
            return d;
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        XBaseEformData data = (XBaseEformData)element;
        return data.getId() != null && this.lastVersions.contains(data) && this.getChildren(data).length > 0;
    }

    public void dispose() {
    }
}

