/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.dashboard.models;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.util.GlobalInstancesAdapter;
import ca.infodata.ofys.data.dataaccess.util.GlobalInstancesListener;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.encounter.CEncounter;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.CEditableDataObject;
import ca.infodata.ofys.ui.library.LibPlugin;
import ca.infodata.ofys.ui.library.file.FileUtil;
import ca.infodata.ofys.ui.library.log.Log;
import ca.infodata.ofys.util.Triplet;
import ca.infodata.util1.Pair;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.DateUtil;
import java.io.File;
import java.io.FilenameFilter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.SerializationUtils;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;

public class MVEncs {
    private static final Logger logger = Logger.getLogger(MVEncs.class.getName());
    private Map<String, MVStore> stores = new ConcurrentHashMap<String, MVStore>();
    private GlobalInstancesAdapter globalInstancesListener;
    private String storePath = String.valueOf(LibPlugin.OFYS_HOME) + ".encs/";
    private String clientCode = null;
    private String userName = null;

    public MVEncs() {
        XSession session;
        File file = new File(this.storePath);
        if (!file.exists()) {
            file.mkdirs();
        }
        if ((session = Application.get().getGlobalInstances().getSession()) != null) {
            if (session.getClient() != null) {
                this.clientCode = session.getClient().clientCode;
            }
            if (session.getUser() != null) {
                this.userName = session.getUser().name;
            }
        }
        this.globalInstancesListener = new GlobalInstancesAdapter(){

            public void sessionChanged() {
                XSession session = Application.get().getGlobalInstances().getSession();
                if (session != null) {
                    if (session.getClient() != null) {
                        MVEncs.this.clientCode = session.getClient().clientCode;
                    }
                    if (session.getUser() != null) {
                        MVEncs.this.userName = session.getUser().name;
                    }
                    MVEncs.this.openUserStores(MVEncs.this.clientCode, MVEncs.this.userName);
                }
            }

            public void logout() {
                MVEncs.this.closeUserStore(MVEncs.this.clientCode, MVEncs.this.userName);
            }
        };
        this.openUserStores(this.clientCode, this.userName);
        Application.get().getGlobalInstances().addGlobalInstancesListener((GlobalInstancesListener)this.globalInstancesListener);
    }

    public synchronized void commit(Integer idPt) {
        MVStore store = this.getUserStoreForPatient(idPt);
        long commit = store.commit();
        MVMap map = store.openMap(MAPS.VERS.name());
        map.put((Object)this.getDateTimeHMS(), (Object)commit);
        store.sync();
    }

    public List<CEncounter> getAllEncounters() {
        ArrayList<CEncounter> res = new ArrayList<CEncounter>();
        Integer prefixlength = this.getPrefixStoreName(this.clientCode, this.userName).length() + 1;
        for (String k : this.stores.keySet()) {
            Integer patId = Integer.parseInt(k.substring(prefixlength));
            res.add(this.getEncounter(patId));
        }
        return res;
    }

    public List<Integer> getAllPresaveEncountersPatientId() {
        ArrayList<Integer> res = new ArrayList<Integer>();
        Integer prefixlength = this.getPrefixStoreName(this.clientCode, this.userName).length() + 1;
        for (String k : this.stores.keySet()) {
            Integer i;
            String id;
            if (k == null || (id = k.substring(prefixlength)).equals("null") || this.getEncounter(i = Integer.valueOf(Integer.parseInt(id))) == null) continue;
            res.add(i);
        }
        return res;
    }

    public CEncounter getEncounter(Integer idPt) {
        return this.getEncounter(idPt, null);
    }

    public CEncounter getEncounter(Integer idPt, Long version) {
        CEncounter c = null;
        if (this.stores.containsKey(this.getStoreKey(idPt))) {
            List<Triplet<Class<?>, String, CEditableDataObject>> list = this.getDataFromVersionForPatient(idPt, version);
            for (Triplet<Class<?>, String, CEditableDataObject> o : list) {
                if (!((Class)o.getFirst()).equals(CEncounter.class)) continue;
                c = (CEncounter)CEncounter.class.cast(o.getThird());
            }
            if (c != null) {
                c = (CEncounter)SerializationUtils.clone(c);
                for (Triplet<Class<?>, String, CEditableDataObject> o : list) {
                    Class clazz = (Class)o.getFirst();
                    Object oo = clazz.cast(o.getThird());
                    try {
                        if (o.getSecond() == null) continue;
                        Method method = CEncounter.class.getMethod((String)o.getSecond(), clazz);
                        method.invoke((Object)c, oo);
                    }
                    catch (NoSuchMethodException | SecurityException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return c;
    }

    private synchronized List<Triplet<Class<?>, String, CEditableDataObject>> getDataFromVersionForPatient(Integer idPt, Long version) {
        ArrayList lst = new ArrayList();
        MVStore store = this.getUserStoreForPatient(idPt);
        MVMap map = version == null ? store.openMap(MAPS.ENC.name()) : store.openMap(MAPS.ENC.name()).openVersion(version.longValue());
        for (Map.Entry es : map.entrySet()) {
            Triplet t = (Triplet)es.getValue();
            lst.add(t);
        }
        return lst;
    }

    public synchronized List<Pair<String, Long>> getAllVersionsForPatient(Integer idPt) {
        ArrayList<Pair<String, Long>> lst = new ArrayList<Pair<String, Long>>();
        MVStore store = this.getUserStoreForPatient(idPt);
        MVMap map = store.openMap(MAPS.VERS.name());
        for (Map.Entry es : map.entrySet()) {
            lst.add((Pair<String, Long>)new Pair((Object)((String)es.getKey()), (Object)((Long)es.getValue())));
        }
        return lst;
    }

    public synchronized void addModifiedEnc(CEncounter enc) {
        Triplet pair;
        Triplet pair2;
        Integer idPt = enc.getIdPatientAnchor();
        if (enc.guid != null) {
            CEncounter c = new CEncounter();
            c.setGuid(enc.getGuid());
            c.setId(enc.getId());
            c.setIdAnchor(enc.getIdAnchor());
            c.setIdPatientAnchor(enc.getIdPatientAnchor());
            c.setVersion(enc.version);
            c.editMode = enc.editMode;
            c.setIsSigned(enc.getIsSigned());
            c.setDatetime(enc.getDatetime());
            c.setDatetimeS(enc.getDatetimeS());
            c.setEncLabelInt(enc.getEncLabelInt());
            c.setSite(enc.getSite());
            c.setEncounterType(enc.getEncounterType());
            c.setEncounterTypeS(enc.getEncounterTypeS());
            c.setEncounterLanguage(enc.getEncounterLanguage());
            c.setProfessionnal(enc.getProfessionnal());
            for (CEncounter.Profs p : enc.getLstProf()) {
                c.addToLst(p);
            }
            c.setTbcObj(enc.getTbcObj());
            c.setTbrObj(enc.getTbrObj());
            c.getEncLabel().addAll(enc.getEncLabel());
            Triplet pair3 = new Triplet(CEncounter.class, null, (Object)c);
            this.addObject(idPt, enc.guid, pair3);
        }
        if (enc.getLstNote() != null) {
            for (CEncounter c : enc.getLstNote()) {
                pair2 = new Triplet(CEncounter.EncounterNote.class, (Object)"addToLst", (Object)c);
                this.addObject(idPt, c.guid, pair2);
            }
        }
        if (enc.getLstRaison() != null) {
            for (CEncounter c : enc.getLstRaison()) {
                pair2 = new Triplet(CEncounter.EncounterRaison.class, (Object)"addToLst", (Object)c);
                this.addObject(idPt, c.guid, pair2);
            }
        }
        if (enc.getTbcObj() != null) {
            pair = new Triplet(CEncounter.EncounterToBeCompleted.class, (Object)"setTbcObj", (Object)enc.getTbcObj());
            this.addObject(idPt, enc.getTbcObj().guid, pair);
        }
        if (enc.getTbrObj() != null) {
            pair = new Triplet(CEncounter.EncounterToBeRevised.class, (Object)"setTbrObj", (Object)enc.getTbrObj());
            this.addObject(idPt, enc.getTbrObj().guid, pair);
        }
        if (enc.getLstDoc() != null) {
            for (CEncounter c : enc.getLstDoc()) {
                pair2 = new Triplet(CEncounter.Docs.class, (Object)"addToLst", (Object)c);
                this.addObject(idPt, c.guid, pair2);
            }
        }
        if (enc.getLstPhysicalExam() != null) {
            for (CEncounter c : enc.getLstPhysicalExam()) {
                pair2 = new Triplet(CEncounter.PhysicalExam.class, (Object)"addToLst", (Object)c);
                this.addObject(idPt, c.guid, pair2);
            }
        }
        if (enc.getLstMeasurement() != null) {
            for (CEncounter c : enc.getLstMeasurement()) {
                pair2 = new Triplet(CEncounter.Measurement.class, (Object)"addToLst", (Object)c);
                this.addObject(idPt, c.guid, pair2);
            }
        }
        if (enc.getLstFreq() != null) {
            for (CEncounter c : enc.getLstFreq()) {
                pair2 = new Triplet(CEncounter.Freq.class, (Object)"addToLst", (Object)c);
                this.addObject(idPt, c.guid, pair2);
            }
        }
        if (enc.getLstBodyTemp() != null) {
            for (CEncounter c : enc.getLstBodyTemp()) {
                pair2 = new Triplet(CEncounter.BodyTemp.class, (Object)"addToLst", (Object)c);
                this.addObject(idPt, c.guid, pair2);
            }
        }
        if (enc.getLstBloodPres() != null) {
            for (CEncounter c : enc.getLstBloodPres()) {
                pair2 = new Triplet(CEncounter.BloodPres.class, (Object)"addToLst", (Object)c);
                this.addObject(idPt, c.guid, pair2);
            }
        }
        if (enc.getLstCustMeasure() != null) {
            for (CEncounter c : enc.getLstCustMeasure()) {
                pair2 = new Triplet(CEncounter.CustMeasure.class, (Object)"addToLst", (Object)c);
                this.addObject(idPt, c.guid, pair2);
            }
        }
        if (enc.getLstPrescription() != null) {
            for (CEncounter c : enc.getLstPrescription()) {
                pair2 = new Triplet(CEncounter.Prescription.class, (Object)"addToLst", (Object)c);
                this.addObject(idPt, c.guid, pair2);
            }
        }
        if (enc.getLstBilling() != null) {
            for (CEncounter c : enc.getLstBilling()) {
                pair2 = new Triplet(CEncounter.EncounterBilling.class, (Object)"addToLst", (Object)c);
                this.addObject(idPt, c.guid, pair2);
            }
        }
    }

    public synchronized void addObject(Integer idPt, String guid, Triplet<Class<?>, String, CEditableDataObject> obj) {
        MVStore store = this.getUserStoreForPatient(idPt);
        MVMap map = store.openMap(MAPS.ENC.name());
        map.put((Object)guid, obj);
        this.commit(idPt);
    }

    public synchronized void dispose() {
        this.closeUserStore(this.clientCode, this.userName);
    }

    public synchronized void openUserStores(String clientcode, String userName) {
        String[] list;
        String[] stringArray = list = this.getUserStoresFileName(clientcode, userName);
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            String f = stringArray[n2];
            MVStore mVStore = this.openUserStoreWithName(f);
            ++n2;
        }
    }

    private String getDateTimeHMS() {
        Calendar c = Calendar.getInstance();
        return new StringBuilder(19).append(DateUtil.calendarToFormatedStringDate((Calendar)c)).append(" ").append(DateUtil.calendarToFormatedStringTimeMilli((Calendar)c).substring(0, 8)).toString();
    }

    private synchronized MVStore openUserStoreWithName(String storeFileName) {
        if (this.stores.containsKey(storeFileName)) {
            return this.stores.get(storeFileName);
        }
        char[] storePassword = this.getKeyForUserSession().toCharArray();
        String file = String.valueOf(this.storePath) + storeFileName;
        MVStore store = null;
        try {
            store = new MVStore.Builder().fileName(file).encryptionKey(storePassword).open();
            this.stores.put(storeFileName, store);
        }
        catch (IllegalStateException e1) {
            Log.severe((String)("createStore pour " + storeFileName), (Exception)e1);
        }
        return store;
    }

    public synchronized MVStore getUserStoreForPatient(Integer idPt) {
        String storeFileName = this.getStoreKey(idPt);
        if (this.stores.containsKey(storeFileName)) {
            MVStore store = this.stores.get(storeFileName);
            if (store.isClosed()) {
                this.createUserStoreForPatient(idPt);
            }
            return this.stores.get(storeFileName);
        }
        return this.createUserStoreForPatient(idPt);
    }

    public synchronized MVStore createUserStoreForPatient(Integer idpt) {
        String storeFileName = this.getStoreFileNameForPatient(idpt);
        char[] storePassword = this.getKeyForUserSession().toCharArray();
        String file = new StringBuilder(60).append(this.storePath).append(storeFileName).toString();
        MVStore store = null;
        try {
            store = new MVStore.Builder().fileName(file).encryptionKey(storePassword).open();
            this.stores.put(storeFileName, store);
        }
        catch (IllegalStateException e1) {
            Log.severe((String)("createStore pour " + storeFileName), (Exception)e1);
            File st = new File(file);
            boolean delete = st.delete();
            if (delete) {
                try {
                    store = new MVStore.Builder().fileName(file).encryptionKey(storePassword).open();
                    this.stores.put(storeFileName, store);
                }
                catch (IllegalStateException e2) {
                    Log.severe((String)("createStore delete pour " + storeFileName), (Exception)e2);
                }
                catch (Exception e3) {
                    Log.severe((String)("createStore delete pour " + storeFileName), (Exception)e3);
                }
            }
            Log.severe((String)("cannot delete file for MVProps " + file));
        }
        return store;
    }

    private String getStoreFileNameForPatient(Integer idpt) {
        return new StringBuilder(30).append(this.getPrefixStoreName(this.clientCode, this.userName)).append("_").append(idpt).toString();
    }

    public synchronized void closeUserStore(String clientcode, String userName) {
        String[] userStores;
        String[] stringArray = userStores = this.getUserStoresFileName(clientcode, userName);
        int n = userStores.length;
        int n2 = 0;
        while (n2 < n) {
            String ss = stringArray[n2];
            this.closeUserStore(ss, false);
            ++n2;
        }
    }

    public synchronized void closeUserStore(String storeFileName, boolean immediat) {
        try {
            MVStore store = this.stores.get(storeFileName);
            if (store != null) {
                if (immediat) {
                    store.closeImmediately();
                } else {
                    store.commit();
                    store.close();
                }
                store = null;
            }
            this.stores.remove(storeFileName);
        }
        catch (IllegalStateException e1) {
            Log.severe((String)("closeUserStore pour " + storeFileName), (Exception)e1);
        }
    }

    public synchronized void deleteUserStore(Integer idpt) {
        this.closeUserStore(this.getStoreKey(idpt), true);
        String storeFilePath = this.getStoreFilePath(idpt);
        File file = new File(storeFilePath);
        FileUtil.deleteSingleFile((File)file);
    }

    private String getStoreKey(Integer idpt) {
        return this.getStoreFileNameForPatient(idpt);
    }

    private String getStoreFilePath(Integer idpt) {
        String sn = this.getStoreFileNameForPatient(idpt);
        return new StringBuilder(60).append(this.storePath).append(sn).toString();
    }

    private String[] getUserStoresFileName(String clientcode, String userName) {
        File file = new File(this.storePath);
        final String un = this.getPrefixStoreName(clientcode, userName);
        if (un == null) {
            return new String[0];
        }
        String[] list = file.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(un);
            }
        });
        return list;
    }

    private String getKeyForUserSession() {
        String key = "z1234ABCD9876dcba";
        try {
            XSession session = Application.get().getGlobalInstances().getSession();
            if (session != null && session.getUser() != null) {
                key = new StringBuilder(20).append(session.getUser().encryptedPassword).append(session.getUser().name).toString();
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to get codeClient from xsession bug", e);
        }
        return key;
    }

    private String getPrefixStoreName(String clientCode, String userName) {
        StringBuilder codeUn = new StringBuilder(20);
        try {
            if (clientCode != null) {
                codeUn.append(clientCode);
            }
            if (userName != null) {
                codeUn.append("_").append(this.getReadableString(userName));
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to get codeClient from xsession bug", e);
        }
        return codeUn.length() == 0 ? null : new StringBuilder(20).append("MV_").append((CharSequence)codeUn).toString();
    }

    private String getReadableString(String nn) {
        String n = nn.toLowerCase().replace('0', 'j').replace('1', 'i').replace('2', 'h').replace('3', 'g').replace('4', 'f').replace('5', 'e').replace('6', 'd').replace('7', 'c').replace('8', 'b').replace('9', 'a').replace('-', 'z').replace('.', 'm');
        String encName = "";
        int i = 0;
        while (i < n.length()) {
            int tmp = n.charAt(i) - 65;
            int rotated = (tmp - 4) % 25;
            int shift = rotated + 65;
            encName = String.valueOf(encName) + (char)shift;
            ++i;
        }
        if (StringUtils.isEmpty((String)encName)) {
            encName = n;
        }
        return encName.toLowerCase();
    }

    private static enum MAPS {
        VERS,
        ENC;

    }
}

