/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.x509;

import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Iterator;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.TBSCertificateStructure;
import org.bouncycastle.asn1.x509.Time;
import org.bouncycastle.asn1.x509.V3TBSCertificateGenerator;
import org.bouncycastle.asn1.x509.X509CertificateStructure;
import org.bouncycastle.asn1.x509.X509ExtensionsGenerator;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.jce.provider.X509CertificateObject;
import org.bouncycastle.x509.ExtCertificateEncodingException;
import org.bouncycastle.x509.X509Util;
import org.bouncycastle.x509.extension.X509ExtensionUtil;

public class X509V3CertificateGenerator {
    private V3TBSCertificateGenerator tbsGen = new V3TBSCertificateGenerator();
    private DERObjectIdentifier sigOID;
    private AlgorithmIdentifier sigAlgId;
    private String signatureAlgorithm;
    private X509ExtensionsGenerator extGenerator = new X509ExtensionsGenerator();

    public void reset() {
        this.tbsGen = new V3TBSCertificateGenerator();
        this.extGenerator.reset();
    }

    public void setSerialNumber(BigInteger serialNumber) {
        if (serialNumber.compareTo(BigInteger.ZERO) <= 0) {
            throw new IllegalArgumentException("serial number must be a positive integer");
        }
        this.tbsGen.setSerialNumber(new DERInteger(serialNumber));
    }

    public void setIssuerDN(X500Principal issuer) {
        try {
            this.tbsGen.setIssuer(new X509Principal(issuer.getEncoded()));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("can't process principal: " + e);
        }
    }

    public void setIssuerDN(X509Name issuer) {
        this.tbsGen.setIssuer(issuer);
    }

    public void setNotBefore(Date date) {
        this.tbsGen.setStartDate(new Time(date));
    }

    public void setNotAfter(Date date) {
        this.tbsGen.setEndDate(new Time(date));
    }

    public void setSubjectDN(X500Principal subject) {
        try {
            this.tbsGen.setSubject(new X509Principal(subject.getEncoded()));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("can't process principal: " + e);
        }
    }

    public void setSubjectDN(X509Name subject) {
        this.tbsGen.setSubject(subject);
    }

    public void setPublicKey(PublicKey key) throws IllegalArgumentException {
        try {
            this.tbsGen.setSubjectPublicKeyInfo(SubjectPublicKeyInfo.getInstance(new ASN1InputStream(key.getEncoded()).readObject()));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("unable to process key - " + e.toString());
        }
    }

    public void setSignatureAlgorithm(String signatureAlgorithm) {
        this.signatureAlgorithm = signatureAlgorithm;
        try {
            this.sigOID = X509Util.getAlgorithmOID(signatureAlgorithm);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Unknown signature type requested: " + signatureAlgorithm);
        }
        this.sigAlgId = X509Util.getSigAlgID(this.sigOID, signatureAlgorithm);
        this.tbsGen.setSignature(this.sigAlgId);
    }

    public void setSubjectUniqueID(boolean[] uniqueID) {
        this.tbsGen.setSubjectUniqueID(this.booleanToBitString(uniqueID));
    }

    public void setIssuerUniqueID(boolean[] uniqueID) {
        this.tbsGen.setIssuerUniqueID(this.booleanToBitString(uniqueID));
    }

    private DERBitString booleanToBitString(boolean[] id) {
        byte[] bytes = new byte[(id.length + 7) / 8];
        int i = 0;
        while (i != id.length) {
            int n = i / 8;
            bytes[n] = (byte)(bytes[n] | (id[i] ? 1 << 7 - i % 8 : 0));
            ++i;
        }
        int pad = id.length % 8;
        if (pad == 0) {
            return new DERBitString(bytes);
        }
        return new DERBitString(bytes, 8 - pad);
    }

    public void addExtension(String oid, boolean critical, DEREncodable value) {
        this.addExtension(new DERObjectIdentifier(oid), critical, value);
    }

    public void addExtension(DERObjectIdentifier oid, boolean critical, DEREncodable value) {
        this.extGenerator.addExtension(oid, critical, value);
    }

    public void addExtension(String oid, boolean critical, byte[] value) {
        this.addExtension(new DERObjectIdentifier(oid), critical, value);
    }

    public void addExtension(DERObjectIdentifier oid, boolean critical, byte[] value) {
        this.extGenerator.addExtension(oid, critical, value);
    }

    public void copyAndAddExtension(String oid, boolean critical, X509Certificate cert) throws CertificateParsingException {
        byte[] extValue = cert.getExtensionValue(oid);
        if (extValue == null) {
            throw new CertificateParsingException("extension " + oid + " not present");
        }
        try {
            ASN1Object value = X509ExtensionUtil.fromExtensionValue(extValue);
            this.addExtension(oid, critical, (DEREncodable)value);
        }
        catch (IOException e) {
            throw new CertificateParsingException(e.toString());
        }
    }

    public void copyAndAddExtension(DERObjectIdentifier oid, boolean critical, X509Certificate cert) throws CertificateParsingException {
        this.copyAndAddExtension(oid.getId(), critical, cert);
    }

    public X509Certificate generateX509Certificate(PrivateKey key) throws SecurityException, SignatureException, InvalidKeyException {
        try {
            return this.generateX509Certificate(key, "BC", null);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new SecurityException("BC provider not installed!");
        }
    }

    public X509Certificate generateX509Certificate(PrivateKey key, SecureRandom random) throws SecurityException, SignatureException, InvalidKeyException {
        try {
            return this.generateX509Certificate(key, "BC", random);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new SecurityException("BC provider not installed!");
        }
    }

    public X509Certificate generateX509Certificate(PrivateKey key, String provider) throws NoSuchProviderException, SecurityException, SignatureException, InvalidKeyException {
        return this.generateX509Certificate(key, provider, null);
    }

    public X509Certificate generateX509Certificate(PrivateKey key, String provider, SecureRandom random) throws NoSuchProviderException, SecurityException, SignatureException, InvalidKeyException {
        try {
            return this.generate(key, provider, random);
        }
        catch (NoSuchProviderException e) {
            throw e;
        }
        catch (SignatureException e) {
            throw e;
        }
        catch (InvalidKeyException e) {
            throw e;
        }
        catch (GeneralSecurityException e) {
            throw new SecurityException("exception: " + e);
        }
    }

    public X509Certificate generate(PrivateKey key) throws CertificateEncodingException, IllegalStateException, NoSuchAlgorithmException, SignatureException, InvalidKeyException {
        return this.generate(key, (SecureRandom)null);
    }

    public X509Certificate generate(PrivateKey key, SecureRandom random) throws CertificateEncodingException, IllegalStateException, NoSuchAlgorithmException, SignatureException, InvalidKeyException {
        byte[] signature;
        TBSCertificateStructure tbsCert = this.generateTbsCert();
        try {
            signature = X509Util.calculateSignature(this.sigOID, this.signatureAlgorithm, key, random, tbsCert);
        }
        catch (IOException e) {
            throw new ExtCertificateEncodingException("exception encoding TBS cert", e);
        }
        try {
            return this.generateJcaObject(tbsCert, signature);
        }
        catch (CertificateParsingException e) {
            throw new ExtCertificateEncodingException("exception producing certificate object", e);
        }
    }

    public X509Certificate generate(PrivateKey key, String provider) throws CertificateEncodingException, IllegalStateException, NoSuchProviderException, NoSuchAlgorithmException, SignatureException, InvalidKeyException {
        return this.generate(key, provider, null);
    }

    public X509Certificate generate(PrivateKey key, String provider, SecureRandom random) throws CertificateEncodingException, IllegalStateException, NoSuchProviderException, NoSuchAlgorithmException, SignatureException, InvalidKeyException {
        byte[] signature;
        TBSCertificateStructure tbsCert = this.generateTbsCert();
        try {
            signature = X509Util.calculateSignature(this.sigOID, this.signatureAlgorithm, provider, key, random, tbsCert);
        }
        catch (IOException e) {
            throw new ExtCertificateEncodingException("exception encoding TBS cert", e);
        }
        try {
            return this.generateJcaObject(tbsCert, signature);
        }
        catch (CertificateParsingException e) {
            throw new ExtCertificateEncodingException("exception producing certificate object", e);
        }
    }

    private TBSCertificateStructure generateTbsCert() {
        if (!this.extGenerator.isEmpty()) {
            this.tbsGen.setExtensions(this.extGenerator.generate());
        }
        return this.tbsGen.generateTBSCertificate();
    }

    private X509Certificate generateJcaObject(TBSCertificateStructure tbsCert, byte[] signature) throws CertificateParsingException {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(tbsCert);
        v.add(this.sigAlgId);
        v.add(new DERBitString(signature));
        return new X509CertificateObject(new X509CertificateStructure(new DERSequence(v)));
    }

    public Iterator getSignatureAlgNames() {
        return X509Util.getAlgNames();
    }
}

