/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.tls;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.X509CertificateStructure;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.agreement.DHBasicAgreement;
import org.bouncycastle.crypto.generators.DHBasicKeyPairGenerator;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.DHKeyGenerationParameters;
import org.bouncycastle.crypto.params.DHParameters;
import org.bouncycastle.crypto.params.DHPrivateKeyParameters;
import org.bouncycastle.crypto.params.DHPublicKeyParameters;
import org.bouncycastle.crypto.tls.Certificate;
import org.bouncycastle.crypto.tls.CertificateRequest;
import org.bouncycastle.crypto.tls.TlsAgreementCredentials;
import org.bouncycastle.crypto.tls.TlsClientContext;
import org.bouncycastle.crypto.tls.TlsCredentials;
import org.bouncycastle.crypto.tls.TlsDSSSigner;
import org.bouncycastle.crypto.tls.TlsFatalAlert;
import org.bouncycastle.crypto.tls.TlsKeyExchange;
import org.bouncycastle.crypto.tls.TlsRSASigner;
import org.bouncycastle.crypto.tls.TlsSigner;
import org.bouncycastle.crypto.tls.TlsSignerCredentials;
import org.bouncycastle.crypto.tls.TlsUtils;
import org.bouncycastle.crypto.util.PublicKeyFactory;
import org.bouncycastle.util.BigIntegers;

class TlsDHKeyExchange
implements TlsKeyExchange {
    protected static final BigInteger ONE = BigInteger.valueOf(1L);
    protected static final BigInteger TWO = BigInteger.valueOf(2L);
    protected TlsClientContext context;
    protected int keyExchange;
    protected TlsSigner tlsSigner;
    protected AsymmetricKeyParameter serverPublicKey = null;
    protected DHPublicKeyParameters dhAgreeServerPublicKey = null;
    protected TlsAgreementCredentials agreementCredentials;
    protected DHPrivateKeyParameters dhAgreeClientPrivateKey = null;

    TlsDHKeyExchange(TlsClientContext context, int keyExchange) {
        switch (keyExchange) {
            case 7: 
            case 9: {
                this.tlsSigner = null;
                break;
            }
            case 5: {
                this.tlsSigner = new TlsRSASigner();
                break;
            }
            case 3: {
                this.tlsSigner = new TlsDSSSigner();
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported key exchange algorithm");
            }
        }
        this.context = context;
        this.keyExchange = keyExchange;
    }

    @Override
    public void skipServerCertificate() throws IOException {
        throw new TlsFatalAlert(10);
    }

    @Override
    public void processServerCertificate(Certificate serverCertificate) throws IOException {
        X509CertificateStructure x509Cert = serverCertificate.certs[0];
        SubjectPublicKeyInfo keyInfo = x509Cert.getSubjectPublicKeyInfo();
        try {
            this.serverPublicKey = PublicKeyFactory.createKey(keyInfo);
        }
        catch (RuntimeException runtimeException) {
            throw new TlsFatalAlert(43);
        }
        if (this.tlsSigner == null) {
            try {
                this.dhAgreeServerPublicKey = this.validateDHPublicKey((DHPublicKeyParameters)this.serverPublicKey);
            }
            catch (ClassCastException classCastException) {
                throw new TlsFatalAlert(46);
            }
            TlsUtils.validateKeyUsage(x509Cert, 8);
        } else {
            if (!this.tlsSigner.isValidPublicKey(this.serverPublicKey)) {
                throw new TlsFatalAlert(46);
            }
            TlsUtils.validateKeyUsage(x509Cert, 128);
        }
    }

    @Override
    public void skipServerKeyExchange() throws IOException {
    }

    @Override
    public void processServerKeyExchange(InputStream is) throws IOException {
        throw new TlsFatalAlert(10);
    }

    @Override
    public void validateCertificateRequest(CertificateRequest certificateRequest) throws IOException {
        short[] types = certificateRequest.getCertificateTypes();
        int i = 0;
        while (i < types.length) {
            switch (types[i]) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 64: {
                    break;
                }
                default: {
                    throw new TlsFatalAlert(47);
                }
            }
            ++i;
        }
    }

    @Override
    public void skipClientCredentials() throws IOException {
        this.agreementCredentials = null;
    }

    @Override
    public void processClientCredentials(TlsCredentials clientCredentials) throws IOException {
        if (clientCredentials instanceof TlsAgreementCredentials) {
            this.agreementCredentials = (TlsAgreementCredentials)clientCredentials;
        } else if (!(clientCredentials instanceof TlsSignerCredentials)) {
            throw new TlsFatalAlert(80);
        }
    }

    @Override
    public void generateClientKeyExchange(OutputStream os) throws IOException {
        if (this.agreementCredentials != null) {
            TlsUtils.writeUint24(0, os);
        } else {
            this.generateEphemeralClientKeyExchange(this.dhAgreeServerPublicKey.getParameters(), os);
        }
    }

    @Override
    public byte[] generatePremasterSecret() throws IOException {
        if (this.agreementCredentials != null) {
            return this.agreementCredentials.generateAgreement(this.dhAgreeServerPublicKey);
        }
        return this.calculateDHBasicAgreement(this.dhAgreeServerPublicKey, this.dhAgreeClientPrivateKey);
    }

    protected boolean areCompatibleParameters(DHParameters a, DHParameters b) {
        return a.getP().equals(b.getP()) && a.getG().equals(b.getG());
    }

    protected byte[] calculateDHBasicAgreement(DHPublicKeyParameters publicKey, DHPrivateKeyParameters privateKey) {
        DHBasicAgreement dhAgree = new DHBasicAgreement();
        dhAgree.init(this.dhAgreeClientPrivateKey);
        BigInteger agreement = dhAgree.calculateAgreement(this.dhAgreeServerPublicKey);
        return BigIntegers.asUnsignedByteArray(agreement);
    }

    protected AsymmetricCipherKeyPair generateDHKeyPair(DHParameters dhParams) {
        DHBasicKeyPairGenerator dhGen = new DHBasicKeyPairGenerator();
        dhGen.init(new DHKeyGenerationParameters(this.context.getSecureRandom(), dhParams));
        return dhGen.generateKeyPair();
    }

    protected void generateEphemeralClientKeyExchange(DHParameters dhParams, OutputStream os) throws IOException {
        AsymmetricCipherKeyPair dhAgreeClientKeyPair = this.generateDHKeyPair(dhParams);
        this.dhAgreeClientPrivateKey = (DHPrivateKeyParameters)dhAgreeClientKeyPair.getPrivate();
        BigInteger Yc = ((DHPublicKeyParameters)dhAgreeClientKeyPair.getPublic()).getY();
        byte[] keData = BigIntegers.asUnsignedByteArray(Yc);
        TlsUtils.writeUint24(keData.length + 2, os);
        TlsUtils.writeOpaque16(keData, os);
    }

    protected DHPublicKeyParameters validateDHPublicKey(DHPublicKeyParameters key) throws IOException {
        BigInteger Y = key.getY();
        DHParameters params = key.getParameters();
        BigInteger p = params.getP();
        BigInteger g = params.getG();
        if (!p.isProbablePrime(2)) {
            throw new TlsFatalAlert(47);
        }
        if (g.compareTo(TWO) < 0 || g.compareTo(p.subtract(TWO)) > 0) {
            throw new TlsFatalAlert(47);
        }
        if (Y.compareTo(TWO) < 0 || Y.compareTo(p.subtract(ONE)) > 0) {
            throw new TlsFatalAlert(47);
        }
        return key;
    }
}

