/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.suggest.analyzing;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.State;
import org.apache.lucene.util.automaton.Transition;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.Util;

public class FSTUtil {
    private FSTUtil() {
    }

    public static <T> List<Path<T>> intersectPrefixPaths(Automaton a, FST<T> fst) throws IOException {
        assert (a.isDeterministic());
        ArrayList queue = new ArrayList();
        ArrayList<Path<T>> endNodes = new ArrayList<Path<T>>();
        queue.add(new Path<T>(a.getInitialState(), fst.getFirstArc(new FST.Arc()), fst.outputs.getNoOutput(), new IntsRef()));
        FST.Arc scratchArc = new FST.Arc();
        FST.BytesReader fstReader = fst.getBytesReader();
        while (queue.size() != 0) {
            Path path = (Path)queue.remove(queue.size() - 1);
            if (path.state.isAccept()) {
                endNodes.add(path);
                continue;
            }
            IntsRef currentInput = path.input;
            for (Transition t : path.state.getTransitions()) {
                IntsRef newInput;
                FST.Arc<T> nextArc;
                int max;
                int min = t.getMin();
                if (min == (max = t.getMax())) {
                    nextArc = fst.findTargetArc(t.getMin(), path.fstNode, scratchArc, fstReader);
                    if (nextArc == null) continue;
                    newInput = new IntsRef(currentInput.length + 1);
                    newInput.copyInts(currentInput);
                    newInput.ints[currentInput.length] = t.getMin();
                    newInput.length = currentInput.length + 1;
                    queue.add(new Path(t.getDest(), new FST.Arc<T>().copyFrom(nextArc), fst.outputs.add(path.output, nextArc.output), newInput));
                    continue;
                }
                nextArc = Util.readCeilArc(min, fst, path.fstNode, scratchArc, fstReader);
                while (nextArc != null && nextArc.label <= max) {
                    assert (nextArc.label <= max);
                    assert (nextArc.label >= min) : String.valueOf(nextArc.label) + " " + min;
                    newInput = new IntsRef(currentInput.length + 1);
                    newInput.copyInts(currentInput);
                    newInput.ints[currentInput.length] = nextArc.label;
                    newInput.length = currentInput.length + 1;
                    queue.add(new Path(t.getDest(), new FST.Arc<T>().copyFrom(nextArc), fst.outputs.add(path.output, nextArc.output), newInput));
                    int label = nextArc.label;
                    FST.Arc<T> arc = nextArc = nextArc.isLast() ? null : fst.readNextRealArc(nextArc, fstReader);
                    assert (nextArc == null || label < nextArc.label) : "last: " + label + " next: " + nextArc.label;
                }
            }
        }
        return endNodes;
    }

    public static final class Path<T> {
        public final State state;
        public final FST.Arc<T> fstNode;
        T output;
        public final IntsRef input;

        public Path(State state, FST.Arc<T> fstNode, T output, IntsRef input) {
            this.state = state;
            this.fstNode = fstNode;
            this.output = output;
            this.input = input;
        }
    }
}

