/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spell;

import org.apache.lucene.search.spell.StringDistance;
import org.apache.lucene.util.IntsRef;

public final class LuceneLevenshteinDistance
implements StringDistance {
    @Override
    public float getDistance(String target, String other) {
        IntsRef targetPoints = LuceneLevenshteinDistance.toIntsRef(target);
        IntsRef otherPoints = LuceneLevenshteinDistance.toIntsRef(other);
        int n = targetPoints.length;
        int m = otherPoints.length;
        int[][] d = new int[n + 1][m + 1];
        if (n == 0 || m == 0) {
            if (n == m) {
                return 0.0f;
            }
            return Math.max(n, m);
        }
        int i = 0;
        while (i <= n) {
            d[i][0] = i;
            ++i;
        }
        int j = 0;
        while (j <= m) {
            d[0][j] = j;
            ++j;
        }
        j = 1;
        while (j <= m) {
            int t_j = otherPoints.ints[j - 1];
            i = 1;
            while (i <= n) {
                int cost = targetPoints.ints[i - 1] == t_j ? 0 : 1;
                d[i][j] = Math.min(Math.min(d[i - 1][j] + 1, d[i][j - 1] + 1), d[i - 1][j - 1] + cost);
                if (i > 1 && j > 1 && targetPoints.ints[i - 1] == otherPoints.ints[j - 2] && targetPoints.ints[i - 2] == otherPoints.ints[j - 1]) {
                    d[i][j] = Math.min(d[i][j], d[i - 2][j - 2] + cost);
                }
                ++i;
            }
            ++j;
        }
        return 1.0f - (float)d[n][m] / (float)Math.min(m, n);
    }

    private static IntsRef toIntsRef(String s) {
        IntsRef ref = new IntsRef(s.length());
        int utf16Len = s.length();
        int i = 0;
        int cp = 0;
        while (i < utf16Len) {
            int n = Character.codePointAt(s, i);
            ref.ints[ref.length++] = n;
            cp = n;
            i += Character.charCount(cp);
        }
        return ref;
    }
}

