/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.template.editor;

import ca.infodata.ofys.client.modules.template.DField;
import ca.infodata.ofys.client.modules.template.DNum;
import ca.infodata.ofys.client.modules.template.TypeDeMesure;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XCompletionProposalType;
import ca.infodata.ofys.ui.controls.MyMaskedText;
import ca.infodata.ofys.ui.controls.MyMessageDialogBuilder;
import ca.infodata.ofys.ui.controls.NumberMask;
import ca.infodata.ofys.ui.controls.SimpleNumberText;
import ca.infodata.ofys.ui.controls.form.MyButton;
import ca.infodata.ofys.ui.controls.form.MyLabel;
import ca.infodata.ofys.ui.controls.form.combo.MyCombo;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.util1.StringUtils;
import java.util.regex.Pattern;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class DNumDialog
extends MyMessageDialogBuilder {
    private static String REQUIRED_DATA = Messages.getString((String)"REQUIRED_DATA", (String[])new String[0]);
    private DNum field;
    private MyMaskedText txtName;
    private SimpleNumberText txtMax;
    private SimpleNumberText txtDigits;
    private MyCombo<TypeDeMesure> cmbTypeDeMesure;
    private MyButton chkRequired;
    private final XCompletionProposalType type;

    public DNumDialog(Shell shell, DNum field, XCompletionProposalType xType) {
        this.field = field;
        this.type = xType;
        this.setButtonLabels(Messages.getString((String)"OK", (String[])new String[0]), Messages.getString((String)"CANCEL", (String[])new String[0]));
        this.setDefaultButton(-1);
        this.setParent(shell);
    }

    @Override
    protected Control createCustomArea(Composite parent) {
        parent = new Composite(parent, 0);
        MyLabel lblName = new MyLabel(parent, "Nom :", 16384);
        this.txtName = new MyMaskedText(parent, Pattern.compile(DField.regExpForName));
        this.txtName.setValidStyle(6);
        MyLabel lblMax = new MyLabel(parent, "Nombre d'entier max :", 16384);
        lblMax.setToolTipText("Par ex., 3 signifie un chiffre max de 999");
        this.txtMax = new SimpleNumberText(parent, 2048);
        NumberMask maxMask = new NumberMask(0, 99999);
        this.txtMax.setMask(maxMask);
        MyLabel lblDigits = new MyLabel(parent, "Nombre de d\u00e9cimales :", 16384);
        this.txtDigits = new SimpleNumberText(parent, 2048);
        NumberMask digitMask = new NumberMask(0, 4);
        this.txtDigits.setMask(digitMask);
        MyLabel lblType = new MyLabel(parent, "Type de mesure :", 16384);
        this.cmbTypeDeMesure = new MyCombo(parent, 8);
        this.cmbTypeDeMesure.setItems((TypeDeMesure[])TypeDeMesure.values());
        this.chkRequired = new MyButton(parent, REQUIRED_DATA, 32, null);
        FormLayout layout = new FormLayout();
        layout.spacing = 5;
        parent.setLayout((Layout)layout);
        this.txtName.setText(StringUtils.defaultString((String)this.field.name));
        if (this.field.max != null) {
            this.txtMax.setNumber(this.field.max.intValue());
        }
        if (this.field.digits != null && this.field.digits > -1) {
            this.txtDigits.setNumber((int)this.field.digits);
        }
        if (this.field.typeDeMesure != null) {
            this.cmbTypeDeMesure.select(this.field.typeDeMesure);
        }
        this.chkRequired.setSelection(this.field.required);
        UI.newFormDataLabeledControlLayout(null, (Control)lblName.getControl(), (Control)this.txtName.getControl());
        UI.newFormDataLabeledControlLayout((Control)this.txtName.getControl(), (Control)lblMax.getControl(), (Control)this.txtMax.getControl());
        UI.newFormDataLabeledControlLayout((Control)this.txtMax.getControl(), (Control)lblDigits.getControl(), (Control)this.txtDigits.getControl());
        FormData data = new FormData();
        data.top = new FormAttachment(this.txtDigits.getControl());
        data.left = new FormAttachment(0);
        if (!XCompletionProposalType.ENCOUNTER_NOTE.equals((Object)this.type)) {
            data.height = 0;
            lblType.setVisible(false);
        }
        lblType.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment(this.txtDigits.getControl());
        data.left = new FormAttachment(lblType.getControl());
        if (!XCompletionProposalType.ENCOUNTER_NOTE.equals((Object)this.type)) {
            data.height = 0;
            this.cmbTypeDeMesure.setVisible(false);
        }
        this.cmbTypeDeMesure.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.cmbTypeDeMesure.getControl());
        data.left = new FormAttachment(0);
        this.chkRequired.setLayoutData(data);
        return parent;
    }

    @Override
    protected boolean customShouldTakeFocus() {
        return true;
    }

    @Override
    protected boolean buttonPressed(int buttonId) {
        if (buttonId == 0) {
            String name = this.txtName.getText().trim();
            if (StringUtils.isBlank((CharSequence)name)) {
                return false;
            }
            this.field.name = name;
            this.field.max = this.txtMax.getNumber();
            this.field.digits = this.txtDigits.getNumber();
            this.field.required = new Boolean(this.chkRequired.getSelection());
            this.field.typeDeMesure = this.cmbTypeDeMesure.getSelection();
        }
        return true;
    }
}

