/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.report2;

import ca.infodata.ofys.data.middle.dataobjects.interfaces.IReport;
import ca.infodata.ofys.ui.controls.report2.PrintController;
import ca.infodata.ofys.ui.controls.report2.PrintTreeContentProvider;
import java.util.Set;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.swt.graphics.Color;

public class PrintTreeLabelAndCheckedStateProvider
extends ColumnLabelProvider
implements ICheckStateProvider {
    private PrintController controller;

    public PrintTreeLabelAndCheckedStateProvider(CheckboxTreeViewer treeViewer) {
    }

    public PrintController getController() {
        return this.controller;
    }

    public void setController(PrintController controller) {
        this.controller = controller;
    }

    public String getText(Object element) {
        String text = null;
        if (element instanceof PrintTreeContentProvider.ReportItem) {
            PrintTreeContentProvider.ReportItem r = (PrintTreeContentProvider.ReportItem)element;
            return r.report.getName();
        }
        if (element instanceof PrintTreeContentProvider.CategoryItem) {
            PrintTreeContentProvider.CategoryItem c = (PrintTreeContentProvider.CategoryItem)element;
            int count = this.countCheckedChildren(c);
            if (count > 0) {
                return String.valueOf(c.category.getName()) + " (" + count + ")";
            }
            return c.category.getName();
        }
        return text;
    }

    private int countCheckedChildren(PrintTreeContentProvider.CategoryItem c) {
        int count = 0;
        for (PrintTreeContentProvider.ReportItem r : c.children) {
            if (!this.isChecked(r)) continue;
            ++count;
        }
        return count;
    }

    public Color getBackground(Object element) {
        return null;
    }

    public boolean isChecked(Object element) {
        boolean checked = false;
        if (this.controller == null) {
            checked = false;
        } else {
            Set<IReport> selection = this.controller.getSelection();
            if (selection == null || selection.isEmpty()) {
                checked = false;
            } else if (element instanceof PrintTreeContentProvider.ReportItem) {
                PrintTreeContentProvider.ReportItem r = (PrintTreeContentProvider.ReportItem)element;
                checked = selection.contains(r.report);
            } else if (element instanceof PrintTreeContentProvider.CategoryItem) {
                PrintTreeContentProvider.CategoryItem c = (PrintTreeContentProvider.CategoryItem)element;
                if (c.children.isEmpty()) {
                    checked = false;
                }
                for (PrintTreeContentProvider.ReportItem r : c.children) {
                    if (!selection.contains(r.report)) continue;
                    checked = true;
                    break;
                }
            }
        }
        return checked;
    }

    public boolean isGrayed(Object element) {
        if (this.controller == null) {
            return false;
        }
        Set<IReport> selection = this.controller.getSelection();
        if (selection == null || selection.isEmpty()) {
            return false;
        }
        if (element instanceof PrintTreeContentProvider.CategoryItem) {
            PrintTreeContentProvider.CategoryItem c = (PrintTreeContentProvider.CategoryItem)element;
            if (c.children.isEmpty()) {
                return false;
            }
            int selectedChildrenCount = 0;
            for (PrintTreeContentProvider.ReportItem r : c.children) {
                if (!selection.contains(r.report)) continue;
                ++selectedChildrenCount;
            }
            return selectedChildrenCount > 0 && selectedChildrenCount < c.children.size();
        }
        return false;
    }
}

