/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.highLight;

import ca.infodata.ofys.ui.controls.statusbar.StatusMessageManager;
import ca.infodata.ofys.ui.library.DaemonThread;
import ca.infodata.ofys.ui.library.ResourceGetter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class ControlHighLighter {
    private HighLightMode mode;
    private String msg;
    private Control hControl;
    private Control pControl;
    private Color hColor;
    private Color originalColor;
    private int duration;

    public ControlHighLighter(Control control, Color highColor, int duration, String msg, HighLightMode mode) {
        this.mode = mode;
        this.hControl = control;
        this.pControl = this.hControl.getParent();
        this.duration = duration;
        this.hColor = highColor;
        this.originalColor = this.hControl.getForeground();
        this.msg = msg;
        this.roundDuration();
    }

    private void roundDuration() {
        this.duration = this.duration / 100 * 100 + (this.duration % 100 < 50 ? 0 : 100);
    }

    public void start() {
        if (this.msg != null) {
            StatusMessageManager.getInstance().setMessage(this.getClass().getName(), this.msg);
        }
        switch (this.mode) {
            case FADE_OUT: {
                this.fadeOut();
                break;
            }
            case FADE_IN: {
                this.fadeIn();
                break;
            }
            case FADE_IN_OUT: {
                this.fadeInOut();
            }
        }
    }

    private void fadeOut() {
        DaemonThread t = new DaemonThread(){

            public void run() {
                final int nbStep = ControlHighLighter.this.duration / 100;
                int i = 0;
                while (i <= nbStep) {
                    final int step = i;
                    try {
                        Thread.sleep(100L);
                        System.out.println("STEP : " + i);
                        Display display = Display.getCurrent();
                        if (display == null) {
                            display = Display.getDefault();
                        }
                        if (display != null) {
                            display.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    System.out.println("RUN ASYNC");
                                    if (ControlHighLighter.this.hControl != null && !ControlHighLighter.this.hControl.isDisposed() && ControlHighLighter.this.pControl != null && !ControlHighLighter.this.pControl.isDisposed()) {
                                        Color c = ControlHighLighter.this.getIntermedColor(ControlHighLighter.this.hColor, ControlHighLighter.this.originalColor, step, nbStep);
                                        System.out.println("step:" + step + " | c:" + c.getRed() + "," + c.getGreen() + "," + c.getBlue());
                                        ControlHighLighter.this.hControl.setForeground(c);
                                    }
                                }
                            });
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    ++i;
                }
            }
        };
        t.start();
    }

    private void fadeIn() {
        DaemonThread t = new DaemonThread(){

            public void run() {
                final int nbStep = ControlHighLighter.this.duration / 100;
                int i = 0;
                while (i <= nbStep) {
                    final int step = i;
                    try {
                        Thread.sleep(100L);
                        System.out.println("STEP : " + i);
                        Display display = Display.getCurrent();
                        if (display == null) {
                            display = Display.getDefault();
                        }
                        if (display != null) {
                            display.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    System.out.println("RUN ASYNC");
                                    if (ControlHighLighter.this.hControl != null && !ControlHighLighter.this.hControl.isDisposed() && ControlHighLighter.this.pControl != null && !ControlHighLighter.this.pControl.isDisposed()) {
                                        Color c = ControlHighLighter.this.getIntermedColor(ControlHighLighter.this.originalColor, ControlHighLighter.this.hColor, step, nbStep);
                                        System.out.println("step:" + step + " | c:" + c.getRed() + "," + c.getGreen() + "," + c.getBlue());
                                        ControlHighLighter.this.hControl.setForeground(c);
                                    }
                                }
                            });
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    ++i;
                }
            }
        };
        t.start();
    }

    private void fadeInOut() {
        DaemonThread t = new DaemonThread(){

            public void run() {
                Display display;
                int step;
                final int nbStep = ControlHighLighter.this.duration / 100;
                int i = 0;
                while (i <= nbStep) {
                    step = i;
                    try {
                        Thread.sleep(50L);
                        System.out.println("STEP : " + i);
                        display = Display.getCurrent();
                        if (display == null) {
                            display = Display.getDefault();
                        }
                        if (display != null) {
                            display.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    System.out.println("RUN ASYNC");
                                    if (ControlHighLighter.this.hControl != null && !ControlHighLighter.this.hControl.isDisposed() && ControlHighLighter.this.pControl != null && !ControlHighLighter.this.pControl.isDisposed()) {
                                        Color c = ControlHighLighter.this.getIntermedColor(ControlHighLighter.this.originalColor, ControlHighLighter.this.hColor, step, nbStep);
                                        System.out.println("step:" + step + " | c:" + c.getRed() + "," + c.getGreen() + "," + c.getBlue());
                                        ControlHighLighter.this.hControl.setForeground(c);
                                    }
                                }
                            });
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    ++i;
                }
                i = 0;
                while (i <= nbStep) {
                    step = i;
                    try {
                        Thread.sleep(50L);
                        System.out.println("STEP : " + i);
                        display = Display.getCurrent();
                        if (display == null) {
                            display = Display.getDefault();
                        }
                        if (display != null) {
                            display.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    System.out.println("RUN ASYNC");
                                    if (ControlHighLighter.this.hControl != null && !ControlHighLighter.this.hControl.isDisposed() && ControlHighLighter.this.pControl != null && !ControlHighLighter.this.pControl.isDisposed()) {
                                        Color c = ControlHighLighter.this.getIntermedColor(ControlHighLighter.this.hColor, ControlHighLighter.this.originalColor, step, nbStep);
                                        System.out.println("step:" + step + " | c:" + c.getRed() + "," + c.getGreen() + "," + c.getBlue());
                                        ControlHighLighter.this.hControl.setForeground(c);
                                    }
                                }
                            });
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    ++i;
                }
            }
        };
        t.start();
    }

    private Color getIntermedColor(Color ca, Color cb, int step, int nbStep) {
        return ResourceGetter.getColor((int)this.getIntermedInt(ca.getRed(), cb.getRed(), step, nbStep), (int)this.getIntermedInt(ca.getGreen(), cb.getGreen(), step, nbStep), (int)this.getIntermedInt(ca.getBlue(), cb.getBlue(), step, nbStep));
    }

    private int getIntermedInt(int a, int b, int step, int nbStep) {
        return a - step * (a - b) / nbStep;
    }

    public static enum HighLightMode {
        FADE_OUT,
        FADE_IN,
        FADE_IN_OUT;

    }
}

