/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.form.combo.proposal;

import ca.infodata.ofys.data.middle.dataobjects.XCity;
import ca.infodata.ofys.data.middle.dataobjects.XCountry;
import ca.infodata.ofys.data.middle.dataobjects.XProvince;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ISimplePerson;
import ca.infodata.ofys.ui.controls.EditorModifyListener;
import ca.infodata.ofys.ui.controls.IBaseEditor;
import ca.infodata.ofys.ui.controls.IControl;
import ca.infodata.ofys.ui.controls.form.combo.proposal.CityProposal;
import ca.infodata.ofys.ui.controls.form.combo.proposal.CityText;
import ca.infodata.util1.StringUtils;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class SimplePersonCityText
implements IControl {
    private IBaseEditor baseEditor;
    private ISimplePerson patient;
    private CityText cityText;

    public SimplePersonCityText(IBaseEditor baseEditor, Composite parent, int style, FormToolkit toolkit) {
        this.baseEditor = baseEditor;
        this.cityText = new CityText(parent, style, toolkit);
        this.cityText.getCityContentProposal().getContentProposalAdapter().addContentProposalListener(new IContentProposalListener(){

            public void proposalAccepted(IContentProposal proposal) {
                CityProposal c = (CityProposal)proposal;
                ISimplePerson a = SimplePersonCityText.this.getPerson();
                if (a != null) {
                    a.setCity(new XCity(c.getContent().toUpperCase()));
                    a.setCountry(new XCountry("CANADA"));
                    a.setProvince(new XProvince(c.getCity().province.toUpperCase()));
                    SimplePersonCityText.this.baseEditor.showAllDataObject();
                }
            }
        });
        this.addModifyListener(new EditorModifyListener(this.baseEditor, 24){

            @Override
            public void edited(Event e) {
                String text = SimplePersonCityText.this.getText();
                if (StringUtils.isNotBlank((String)text)) {
                    SimplePersonCityText.this.getPerson().setCity(new XCity(SimplePersonCityText.this.getText()));
                } else {
                    SimplePersonCityText.this.getPerson().setCity(null);
                }
            }
        });
    }

    public ISimplePerson getPerson() {
        return this.patient;
    }

    public void setPerson(ISimplePerson person) {
        this.patient = person;
        if (this.patient == null) {
            this.cityText.selectNone();
        } else {
            this.cityText.select(this.patient.getCity());
        }
    }

    @Override
    public Control getControl() {
        return this.cityText.getControl();
    }

    @Override
    public void setEnabled(boolean v) {
        this.cityText.setEnabled(v);
    }

    public void setVisible(boolean b) {
        this.cityText.setVisible(b);
    }

    public String getText() {
        return this.cityText.getText();
    }

    public void setText(String text) {
        this.cityText.setText(text);
    }

    public void addModifyListener(ModifyListener listener) {
        this.cityText.addModifyListener(listener);
    }
}

