/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.form;

import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.ui.controls.form.INumberConverter;

public final class NumberConverters {
    public static final INumberConverter kgToPound = new INumberConverter(){

        @Override
        public String getToUnitText() {
            return Messages.getString((String)"LIVRES", (String[])new String[0]);
        }

        @Override
        public String getFromUnitText() {
            return Messages.getString((String)"KILOGRAMMES", (String[])new String[0]);
        }

        @Override
        public Double inverse(Double n) {
            return n == null ? null : Double.valueOf(n / 2.20462262);
        }

        @Override
        public Double convert(Double n) {
            return n == null ? null : Double.valueOf(n * 2.20462262);
        }
    };
    public static final INumberConverter poundToKg = new INumberConverter(){

        @Override
        public String getToUnitText() {
            return Messages.getString((String)"KILOGRAMMES", (String[])new String[0]);
        }

        @Override
        public String getFromUnitText() {
            return Messages.getString((String)"LIVRES", (String[])new String[0]);
        }

        @Override
        public Double inverse(Double n) {
            return n == null ? null : Double.valueOf(n * 2.20462262);
        }

        @Override
        public Double convert(Double n) {
            return n == null ? null : Double.valueOf(n / 2.20462262);
        }
    };
    public static final INumberConverter cmToInch = new INumberConverter(){

        @Override
        public String getToUnitText() {
            return Messages.getString((String)"POUCE", (String[])new String[0]);
        }

        @Override
        public String getFromUnitText() {
            return Messages.getString((String)"CENTIMETRE", (String[])new String[0]);
        }

        @Override
        public Double inverse(Double n) {
            return n == null ? null : Double.valueOf(n * 2.54);
        }

        @Override
        public Double convert(Double n) {
            return n == null ? null : Double.valueOf(n / 2.54);
        }
    };
    public static final INumberConverter inchToCm = new INumberConverter(){

        @Override
        public String getToUnitText() {
            return Messages.getString((String)"CENTIMETRE", (String[])new String[0]);
        }

        @Override
        public String getFromUnitText() {
            return Messages.getString((String)"POUCE", (String[])new String[0]);
        }

        @Override
        public Double inverse(Double n) {
            return n == null ? null : Double.valueOf(n / 2.54);
        }

        @Override
        public Double convert(Double n) {
            return n == null ? null : Double.valueOf(n * 2.54);
        }
    };

    private NumberConverters() {
    }
}

