/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.form;

import ca.infodata.ofys.ui.controls.FontAwareButton;
import ca.infodata.ofys.ui.controls.IControl;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.UI;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class MyButton
extends FontAwareButton
implements IControl {
    private static int STANDARD_BUTTON_WIDTH = UI.OS_CARBON ? 130 : 100;
    private Image imageIcon;

    public static int getStandardButtonHeight() {
        return 30;
    }

    public static int getStandardButtonWidth() {
        return STANDARD_BUTTON_WIDTH;
    }

    public MyButton(Composite parent, String text, int style, FormToolkit formToolkit) {
        super(parent, style | (formToolkit == null ? 0 : 0x800000));
        if (text != null) {
            this.setText(text);
        }
        if (formToolkit != null) {
            this.setBackground(formToolkit.getColors().getBackground());
        }
        this.initialize();
    }

    public MyButton(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    private void initialize() {
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                if (MyButton.this.imageIcon != null && !MyButton.this.imageIcon.isDisposed()) {
                    ResourceGetter.dispose((Object)MyButton.this.imageIcon);
                }
            }
        });
    }

    @Override
    public Control getControl() {
        return this;
    }

    public Button getButton() {
        return this;
    }

    public void setImage(Image image) {
        if (this.imageIcon != null && this.imageIcon.isDisposed()) {
            ResourceGetter.dispose((Object)this.imageIcon);
        }
        this.imageIcon = image;
        super.setImage(image);
    }

    public void setText(String text) {
        super.setText(text == null ? (UI.OS_CARBON ? " " : "") : text);
    }

    public boolean getSelection() {
        return this.isDisposed() ? false : super.getSelection();
    }
}

