/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.browser;

import ca.infodata.ofys.ui.browser.HtmlBrowserTools;
import ca.infodata.ofys.ui.browser.HtmlResource;
import ca.infodata.ofys.ui.browser.HtmlResourceList;
import ca.infodata.ofys.ui.browser.JettyConnector;
import ca.infodata.ofys.ui.controls.FontAwareComposite;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.UI;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.ProgressAdapter;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class BrowserComposite
extends FontAwareComposite {
    private static final Logger logger = Logger.getLogger(BrowserComposite.class.getName());
    private Browser browser;
    private HtmlResourceList htmlResourceList;
    private String htmlResourceName;
    private JettyConnector jettyConnector = HtmlBrowserTools.getConnector0();
    public static int fontSize = UI.OS_MAC ? 11 : 15;

    public BrowserComposite(Composite parent, int browserControlStyle) {
        super(parent, 0);
        this.htmlResourceList = new HtmlResourceList();
        this.setLayout((Layout)new FillLayout());
        this.browser = new Browser((Composite)this, browserControlStyle);
        this.init();
    }

    public BrowserComposite(Composite parent, FormToolkit toolkit) {
        super(parent, 0);
        this.htmlResourceList = new HtmlResourceList();
        this.setLayout((Layout)new FormLayout());
        Composite browserContainer = toolkit.createComposite((Composite)this, 2048);
        browserContainer.setLayout((Layout)new FillLayout());
        this.browser = new Browser(browserContainer, 0);
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.bottom = new FormAttachment(100);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        browserContainer.setLayoutData((Object)data);
        this.init();
    }

    public JettyConnector getJettyConnector() {
        return this.jettyConnector;
    }

    public void setJettyConnector(JettyConnector jettyConnector) {
        if (jettyConnector == null) {
            throw new NullPointerException("jettyConnector");
        }
        this.jettyConnector = jettyConnector;
    }

    protected void init() {
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                BrowserComposite.this.htmlResourceList.dispose();
            }
        });
        this.browser.addProgressListener((ProgressListener)new ProgressAdapter(){

            public void completed(ProgressEvent event) {
                Object obj = null;
                try {
                    obj = BrowserComposite.this.browser.evaluate("return document.documentMode");
                    logger.log(Level.INFO, "DOCUMENT MODE: " + obj);
                    Double dc = (Double)obj;
                    if (dc != null && dc < 10.0) {
                        String s = "Ce poste est dans un mode document invalide: " + dc;
                        logger.log(Level.INFO, s);
                    }
                }
                catch (Exception exception) {
                    logger.log(Level.WARNING, "Validation du mode de document a \u00e9chou\u00e9 : " + obj + "/" + obj.getClass().getName());
                }
            }
        });
    }

    public void setAndReplaceHtml(HtmlResource htmlResource) {
        this.htmlResourceList.clear();
        this.htmlResourceList.add(htmlResource);
        this.setUrl(htmlResource.getUrl());
    }

    public void setHtml(HtmlResource htmlResource) {
        this.htmlResourceList.add(htmlResource);
        this.setUrl(htmlResource.getUrl());
    }

    public void setUrl(String url) {
        this.browser.setUrl(url);
    }

    public void setHtmlInUIThread(final Exception e) {
        if (UI.isCurrentThreadIsUIThread()) {
            this.setHtml(e);
        } else {
            this.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    BrowserComposite.this.setHtml(e);
                }
            });
        }
    }

    public void setHtml(Exception e) {
        this.setHtml(HtmlBrowserTools.newErrorTemplateResource((JettyConnector)this.jettyConnector, null, (Exception)e));
    }

    public void setHtmlInUIThread(final String html) {
        if (UI.isCurrentThreadIsUIThread()) {
            this.setHtml(html);
        } else {
            this.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    BrowserComposite.this.setHtml(html);
                }
            });
        }
    }

    public void setHtml(String html) {
        block5: {
            HtmlResource resource = null;
            try {
                try {
                    html = html == null ? "" : html;
                    resource = HtmlBrowserTools.newHtmlResource((String)this.getResourceName(), null, (Object)html);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Failed to set html in browser", e);
                    resource = HtmlBrowserTools.newErrorTemplateResource((Exception)e, null);
                    this.htmlResourceList.add(resource);
                    this.browser.setUrl(resource.getUrl());
                    break block5;
                }
            }
            catch (Throwable throwable) {
                this.htmlResourceList.add(resource);
                this.browser.setUrl(resource.getUrl());
                throw throwable;
            }
            this.htmlResourceList.add(resource);
            this.browser.setUrl(resource.getUrl());
        }
    }

    protected String getResourceName() {
        if (this.htmlResourceName != null) {
            return this.htmlResourceName;
        }
        return "html" + System.currentTimeMillis();
    }

    public Browser getInnerBrowser() {
        return this.browser;
    }

    public boolean setFocus() {
        if (this.browser != null) {
            return this.browser.setFocus();
        }
        return false;
    }

    public Control getControl() {
        return this;
    }

    @Override
    public void refreshFont() {
        if (this.browser != null) {
            this.browser.evaluate("document.body.style.fontSize='" + (fontSize + ResourceGetter.getFontSizeIncrement()) + "px';");
        }
    }

    public String getHtmlResourceName() {
        return this.htmlResourceName;
    }

    public void setHtmlResourceName(String htmlResourceName) {
        this.htmlResourceName = htmlResourceName;
    }

    public void addProgressListener(ProgressListener listener) {
        this.browser.addProgressListener(listener);
    }

    public boolean execute(String script) {
        return this.browser.execute(script);
    }

    public Object evaluate(String script) throws SWTException {
        return this.browser.evaluate(script);
    }

    public static int getFontSize() {
        return fontSize;
    }
}

