/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.assistant.gabarit;

import ca.infodata.ofys.data.middle.dataobjects.XCompletionProposalType;
import ca.infodata.ofys.data.middle.dataobjects.template.XTemplate;
import ca.infodata.ofys.ui.controls.assistant.AssistantProposer;
import ca.infodata.ofys.ui.controls.assistant.AssistantProposition;
import ca.infodata.ofys.ui.controls.assistant.LegendControl;
import ca.infodata.ofys.ui.controls.assistant.gabarit.TemplateAssistantProposition;
import ca.infodata.ofys.ui.controls.template.TemplateAccessorClient;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.graphics.RGB;

public class TemplateAssistantProposer
extends AssistantProposer<XTemplate> {
    private static final Logger logger = Logger.getLogger("ca.infodata.ofys.ui.controls.assistant.gabarit.TemplateAssistantProposer");
    public static final LegendControl[] LEGENDS = new LegendControl[]{new LegendControl(new RGB(237, 176, 71), "Derniers utilis\u00e9s (moi)"), new LegendControl(new RGB(237, 195, 71), "Plus utilis\u00e9s (moi)"), new LegendControl(new RGB(237, 212, 71), "Plus utilis\u00e9s (clinique)"), new LegendControl(new RGB(242, 232, 187), "Plus utilis\u00e9s (partag\u00e9s)")};
    private TemplateAccessorClient accessor;
    private XCompletionProposalType type;
    private AssistantPropositionCache cache;

    public TemplateAssistantProposer(TemplateAccessorClient accessor, XCompletionProposalType type) {
        this.accessor = accessor;
        this.type = type;
        this.cache = new AssistantPropositionCache();
    }

    @Override
    public List<AssistantProposition<XTemplate>> getList(String word) {
        AssistantPropositionListCache aplc = this.cache.getPropositions(word);
        List<AssistantProposition<XTemplate>> li = null;
        if (aplc != null) {
            li = aplc.list;
            System.out.println("Reuse cache!!!");
        }
        if (li == null) {
            li = new ArrayList<AssistantProposition<XTemplate>>();
            try {
                List findEformUsed = this.accessor.findOneListGrouping(this.type.getValue(), word);
                if (findEformUsed == null) {
                    throw new Exception("FindTemplate return null list...");
                }
                for (XTemplate t : findEformUsed) {
                    li.add(new TemplateAssistantProposition(t));
                }
                this.cache.setAssistant(word, li);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Unable to get gabarit list.", e);
            }
        }
        return li;
    }

    @Override
    public LegendControl[] getLegendControl() {
        return LEGENDS;
    }

    @Override
    protected int getLegendColumnNumber() {
        return 2;
    }

    private class AssistantPropositionCache {
        private static final long EXPIRATION_TIME = 20000L;
        private Map<String, AssistantPropositionListCache> cache = new HashMap<String, AssistantPropositionListCache>();

        public void setAssistant(String key, List<AssistantProposition<XTemplate>> list) {
            this.cache.put(key, new AssistantPropositionListCache(list));
        }

        public AssistantPropositionListCache getPropositions(String key) {
            AssistantPropositionListCache apc = this.cache.get(key);
            if (apc != null && System.currentTimeMillis() > apc.getTime() + 20000L) {
                return null;
            }
            return apc;
        }
    }

    private class AssistantPropositionListCache {
        private long time;
        public List<AssistantProposition<XTemplate>> list;

        public AssistantPropositionListCache(List<AssistantProposition<XTemplate>> list) {
            this.list = list;
            this.time = System.currentTimeMillis();
        }

        public long getTime() {
            return this.time;
        }
    }
}

