/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls;

import ca.infodata.ofys.ui.browser.HtmlBrowserTools;
import ca.infodata.ofys.ui.browser.HtmlResource;
import ca.infodata.ofys.ui.controls.FontAwareComposite;
import ca.infodata.ofys.ui.controls.browser.BrowserComposite;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.UI;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.browser.ProgressAdapter;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class SpellCheckerBrowser
extends FontAwareComposite {
    private static final Logger logger = Logger.getLogger(SpellCheckerBrowser.class.getName());
    public BrowserComposite browser;
    private FormToolkit toolkit;
    private ProgressAdapter browserListner;
    static int fontSize = UI.OS_MAC ? 11 : 15;

    public SpellCheckerBrowser(Composite parent, FormToolkit toolkit) {
        super(parent, 0);
        this.toolkit = toolkit;
        FormLayout layout = new FormLayout();
        this.setLayout((Layout)layout);
        this.createControl(this);
    }

    private void createControl(Composite parent) {
        Composite browserContainer = this.toolkit.createComposite(parent, 2048);
        browserContainer.setLayout((Layout)new FillLayout());
        this.browser = new BrowserComposite(browserContainer, 0);
        new SearchProfessionnalFunction(this.browser.getInnerBrowser());
        new SearchPatientFunction(this.browser.getInnerBrowser());
        new AssistTextFunction(this.browser.getInnerBrowser());
        new LogNavigationFunction(this.browser.getInnerBrowser());
        new OpenPdfExternFunction(this.browser.getInnerBrowser());
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.bottom = new FormAttachment(100);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        browserContainer.setLayoutData((Object)data);
        if (this.browserListner == null) {
            this.browserListner = new ProgressAdapter(){

                public void completed(ProgressEvent e) {
                    SpellCheckerBrowser.this.setBrowsertReadonly(true);
                }
            };
            this.browser.addProgressListener((ProgressListener)this.browserListner);
        }
    }

    public void highlight(String text) {
        this.browser.execute("$('#thenote').removeHighlight().highlight('" + text + "');");
    }

    public HtmlResource setContent(String s) {
        if (s == null) {
            throw new IllegalArgumentException("content is null");
        }
        String html = "<html><head><meta charset=\"utf-8\"><meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge\" /></head><body><span id='thenote'>" + s + "</span></body></html>";
        try {
            html = this.addCustomsMethods(html);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to set resource root path into html", e);
        }
        return HtmlBrowserTools.newHtmlResource((String)html, null, null);
    }

    public String addCustomsMethods(String html) {
        String s1 = "<script type=\"text/javascript\" src=\"../tools/jquery-1.11.3.min.js\"></script>\n";
        String style = "<style>\n.highlight { background-color: yellow }\n.button{background:none!important;border:none;padding:0!important;/*border is optional*/border-bottom:1px solid #444;cursor: pointer;outline-color:transparent;}\n</style>\n";
        String script = "<script type=\"text/javascript\">jQuery.fn.highlight=function(c){function e(b,c){var d=0;if(3==b.nodeType){var a=b.data.indexOf(c),a=a-(b.data.substr(0,a).length-b.data.substr(0,a).length);if(0<=a){d=document.createElement('span');d.className='highlight';a=b.splitText(a);a.splitText(c.length);var f=a.cloneNode(!0);d.appendChild(f);a.parentNode.replaceChild(d,a);d=1}}else if(1==b.nodeType&&b.childNodes&&!/(script|style)/i.test(b.tagName))for(a=0;a<b.childNodes.length;++a)a+=e(b.childNodes[a],c);return d} return this.length&&c&&c.length?this.each(function(){e(this,c)}):this};jQuery.fn.removeHighlight=function(){return this.find('span.highlight').each(function(){this.parentNode.firstChild.nodeName;with(this.parentNode)replaceChild(this.firstChild,this),normalize()}).end()};</script>\n";
        String script1 = "<script type=\"text/javascript\">String.prototype.splice = function(start,length,replacement) {return this.substr(0,start)+replacement+this.substr(start+length);}\n\nfunction replaceInNote(start, len, replacement){\n $('#thenote').removeHighlight();\n var oo=$(\"#thenote\");\n var nn=oo.html();\n nn=nn.splice(start, len, replacement);\n oo.html(nn);\n}\nfunction getNoteVal(){\n $('#thenote').removeHighlight();\n var oo=$(\"#thenote\");\n return oo.html();\n}\nfunction replaceNote(bad,good){\n var oo=$(\"#thenote\");\n var nn=oo.html();\n nn=nn.replace(new RegExp(bad,'gi'),good)\n oo.html(nn);\n}\n</script>\n";
        int indexOf = html.indexOf("<head>");
        if (indexOf == -1) {
            indexOf = html.indexOf("<HEAD>");
        }
        StringBuilder b2 = new StringBuilder(html);
        indexOf = indexOf == -1 ? 0 : (indexOf += "<head>".length());
        b2.insert(indexOf, String.valueOf(s1) + script + script1 + style);
        return b2.toString();
    }

    public boolean execute(String script) {
        return this.browser.execute(script);
    }

    public Object evaluate(String script) {
        return this.browser.evaluate(script);
    }

    public void setBrowserDirty(boolean b) {
        this.browser.evaluate("dirty = " + b + ";");
    }

    public void setBrowsertReadonly(boolean b) {
        this.browser.execute("setReadonly(" + b + ");");
    }

    public boolean setFocus() {
        return this.browser.setFocus();
    }

    public void setVariableInBrowser(String var, Object value) {
        this.setVariableInBrowser(this.browser.getInnerBrowser(), var, value);
    }

    protected void setVariableInBrowser(Browser browser, String var, Object value) {
        String value2 = String.valueOf(value).replaceAll("\n", "\\\\n");
        value2 = value2.replaceAll("\r", "\\\\r");
        value2 = value2.replace("\"", "\\\"");
        String text = "setVariable(\"" + var + "\", \"" + SpellCheckerBrowser.escapeAndPrepareJSValue(value2) + "\");";
        browser.execute(text);
    }

    private static String escapeAndPrepareJSValue(Object value) {
        String value2 = String.valueOf(value).replaceAll("\n", "\\\\n");
        value2 = value2.replaceAll("\r", "\\\\r");
        value2 = value2.replace("\"", "\\\"");
        return value2;
    }

    public Control getControl() {
        return this;
    }

    @Override
    public void refreshFont() {
        this.browser.evaluate("document.body.style.fontSize='" + (fontSize + ResourceGetter.getFontSizeIncrement()) + "px';");
    }

    public void setUrl(String string) {
        this.browser.setUrl(string);
    }

    protected class AssistTextFunction
    extends BrowserFunction {
        AssistTextFunction(Browser browser) {
            super(browser, "assistText");
        }

        public Object function(Object[] arguments) {
            return null;
        }
    }

    protected class LogNavigationFunction
    extends BrowserFunction {
        LogNavigationFunction(Browser browser) {
            super(browser, "logNavigation");
        }

        public Object function(Object[] arguments) {
            String str = (String)arguments[0];
            logger.log(Level.INFO, str);
            return null;
        }
    }

    protected class OpenPdfExternFunction
    extends BrowserFunction {
        OpenPdfExternFunction(Browser browser) {
            super(browser, "openPdfExtern");
        }

        public Object function(Object[] arguments) {
            String str = null;
            try {
                str = (String)arguments[0];
                Program.launch((String)str);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Unable to open external pdf: " + str, e);
            }
            return null;
        }
    }

    protected class SearchPatientFunction
    extends BrowserFunction {
        SearchPatientFunction(Browser browser) {
            super(browser, "searchPatient");
        }

        public Object function(Object[] arguments) {
            return null;
        }
    }

    protected class SearchProfessionnalFunction
    extends BrowserFunction {
        SearchProfessionnalFunction(Browser browser) {
            super(browser, "searchProf");
        }

        public Object function(Object[] arguments) {
            return null;
        }
    }
}

