/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls;

import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.ui.controls.ConsoleStyledText;
import ca.infodata.ofys.ui.controls.IProgressMonitorWithLogWrapper;
import ca.infodata.ofys.ui.controls.IRunnableWithProgressWithLog;
import ca.infodata.util1.StringUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.IThreadListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class MyProgressMonitorDialogWithLog
extends ProgressMonitorDialog {
    private boolean interruptOnCancel;
    private IRunnableWithProgressWrapper runnable2;
    private ConsoleStyledText styledText;
    private Button closeButton;
    private boolean doClose;
    private int heightHint = 200;
    private List<InnerLog> logs = new ArrayList<InnerLog>();
    private int tab = 0;
    private String tabs = "";

    public MyProgressMonitorDialogWithLog(Shell parent) {
        super(parent);
    }

    public void setInterruptOnCancel(boolean b) {
        this.interruptOnCancel = b;
    }

    public void setAutoCloseIfNoErrorOrWarning(boolean b) {
        this.doClose = b;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.closeButton = this.createButton(parent, 12, Messages.getString((String)"FERMER", (String[])new String[0]), false);
        this.closeButton.setEnabled(false);
        this.closeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MyProgressMonitorDialogWithLog.this.doClose = true;
                MyProgressMonitorDialogWithLog.this.close();
            }
        });
    }

    protected void finishedRun() {
        this.cancel.setVisible(false);
        this.closeButton.setEnabled(true);
        super.finishedRun();
    }

    protected void cancelPressed() {
        super.cancelPressed();
        if (this.interruptOnCancel && this.runnable2 != null && this.runnable2.runnableThread != null && this.runnable2.runnableThread != Thread.currentThread()) {
            if (this.confirmInterruption()) {
                this.runnable2.runnableThread.interrupt();
            } else {
                this.setCancelable(true);
            }
        }
    }

    protected boolean confirmInterruption() {
        return true;
    }

    @Deprecated
    public void run(boolean fork, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        throw new UnsupportedOperationException();
    }

    public void runWithLog(boolean fork, boolean cancelable, IRunnableWithProgressWithLog runnable) throws InvocationTargetException, InterruptedException {
        this.runnable2 = new IRunnableWithProgressWrapper(runnable);
        super.run(fork, cancelable, (IRunnableWithProgress)this.runnable2);
    }

    protected Control createDialogArea(Composite parent) {
        super.createDialogArea(parent);
        this.styledText = new ConsoleStyledText(parent, 2818);
        this.styledText.setEditable(false);
        this.subTaskLabel.setVisible(false);
        this.subTaskLabel.setLayoutData(null);
        GridData gd = new GridData(768);
        gd.heightHint = this.getHeightHint();
        gd.horizontalSpan = 2;
        this.styledText.setLayoutData(gd);
        this.styledText.setFont(parent.getFont());
        return parent;
    }

    protected void untab() {
        if (this.tab > 0) {
            --this.tab;
        }
        this.tabs = this.tab <= 0 ? "" : (this.tab == 1 ? "\t" : this.tabs.substring(0, this.tabs.length() - "\t".length()));
    }

    protected void tab() {
        ++this.tab;
        this.tabs = String.valueOf(this.tabs) + "\t";
    }

    protected String adaptMessage(String message) {
        if (StringUtils.isBlank((CharSequence)message)) {
            return message;
        }
        message = message.replace("\t", "");
        message = message.replace("\r\n", "\r\n" + this.tabs);
        message = message.replace("\n", "\n" + this.tabs);
        message = String.valueOf(this.tabs) + message;
        return message;
    }

    protected boolean hasLog(Level ... levels) {
        for (InnerLog log : this.logs) {
            Level[] levelArray = levels;
            int n = levels.length;
            int n2 = 0;
            while (n2 < n) {
                Level level = levelArray[n2];
                if (log.level == level) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    protected void log(final Level level, String message, final Throwable t) {
        if (level != null && level.intValue() > Level.INFO.intValue()) {
            this.doClose = false;
        }
        this.logs.add(new InnerLog(level, message, t));
        final String message2 = this.adaptMessage(message);
        this.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                MyProgressMonitorDialogWithLog.this.styledText.log(level, message2, t);
            }
        });
    }

    protected void logException(Exception e) {
        if (e != null) {
            if (StringUtils.isBlank((CharSequence)e.getMessage())) {
                this.log(Level.SEVERE, Messages.getString((String)"ERREUR", (String[])new String[0]), null);
            } else {
                this.log(Level.SEVERE, String.valueOf(Messages.getString((String)"ERREUR", (String[])new String[0])) + "\n\t" + e.getMessage(), null);
            }
        }
    }

    protected void logStatus(IStatus status) {
        if (status != null && !status.isOK()) {
            switch (status.getSeverity()) {
                case OK: {
                    break;
                }
                case INFO: 
                case NEED_MORE_INFO: {
                    this.log(Level.INFO, status.getMessage(), null);
                    break;
                }
                case WARNING: {
                    this.log(Level.WARNING, status.getMessage(), null);
                    break;
                }
                case ERROR: 
                case BUG: {
                    this.log(Level.SEVERE, status.getMessage(), null);
                }
            }
        }
    }

    public boolean close() {
        if (this.doClose) {
            return super.close();
        }
        return false;
    }

    public int getHeightHint() {
        return this.heightHint;
    }

    public void setHeightHint(int heightHint) {
        this.heightHint = heightHint;
    }

    private class IRunnableWithProgressWrapper
    implements IRunnableWithProgress,
    IThreadListener {
        IRunnableWithProgressWithLog runnable;
        Thread runnableThread;
        IProgressMonitorWithLogWrapper progressMonitorWrapper;

        IRunnableWithProgressWrapper(IRunnableWithProgressWithLog runnable) {
            this.runnable = runnable;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            this.progressMonitorWrapper = new IProgressMonitorWithLogWrapper(monitor){

                @Override
                public void log(Level level, String message, Throwable t) {
                    MyProgressMonitorDialogWithLog.this.log(level, message, t);
                }

                @Override
                public boolean hasLog(Level ... levels) {
                    return MyProgressMonitorDialogWithLog.this.hasLog(levels);
                }

                @Override
                public boolean askQuestion(String title, String message) {
                    return MessageUtil.askQuestion((Shell)MyProgressMonitorDialogWithLog.this.getShell(), (String)title, (String)message, (boolean)true);
                }

                @Override
                public void exception(Exception e) {
                    MyProgressMonitorDialogWithLog.this.logException(e);
                }

                @Override
                public void status(IStatus status) {
                    MyProgressMonitorDialogWithLog.this.logStatus(status);
                }

                @Override
                public void beginTask(String name, int totalWork) {
                    super.beginTask(name, totalWork);
                }

                @Override
                public void subTask(String name) {
                    MyProgressMonitorDialogWithLog.this.log(Level.INFO, String.valueOf(name) + "...", null);
                    super.subTask(name);
                }

                @Override
                public void tab() {
                    MyProgressMonitorDialogWithLog.this.tab();
                }

                @Override
                public void untab() {
                    MyProgressMonitorDialogWithLog.this.untab();
                }

                @Override
                public void done() {
                    super.done();
                    MyProgressMonitorDialogWithLog.this.log(Level.INFO, Messages.getString((String)"TERMINE", (String[])new String[0]), null);
                }
            };
            this.runnable.run(this.progressMonitorWrapper);
        }

        public void threadChange(Thread thread) {
            this.runnableThread = thread;
        }
    }

    static class InnerLog {
        Level level;
        String message;
        Throwable t;

        InnerLog(Level level, String message, Throwable t) {
            this.level = level;
            this.message = message;
            this.t = t;
        }
    }
}

