/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.appointment.editor.model2;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.AppointmentAccessorClient;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.callback.Callback;
import ca.infodata.ofys.data.dataaccess.callback.IStatusHandler;
import ca.infodata.ofys.data.dataaccess.callback.JustLogStatusHandler;
import ca.infodata.ofys.data.dataaccess.util.notification.IConsumerListener;
import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.XPatient;
import ca.infodata.ofys.data.middle.dataobjects.XPersonGroup;
import ca.infodata.ofys.data.middle.dataobjects.appointment.IAppointment;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointment;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentCompleteDataContainer;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentDate;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentDateKey;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentDateTemplate;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentObjects;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentPeriodType;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentWeekTemplate;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XBaseAppointmentDate;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XReservedAppointment;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IEditableDataObjectList;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.notification.DataObjectUpdatedNotification;
import ca.infodata.ofys.data.middle.dataobjects.notification.Notification;
import ca.infodata.ofys.data.middle.dataobjects.patient.XConsentement;
import ca.infodata.ofys.mb.listener.object.ObjectListenerManager;
import ca.infodata.ofys.ui.appointment.editor.model2.Cache;
import ca.infodata.ofys.ui.appointment.editor.model2.CacheCleaner;
import ca.infodata.ofys.ui.appointment.editor.model2.Data;
import ca.infodata.ofys.ui.appointment.editor.model2.IServer;
import ca.infodata.ofys.ui.appointment.editor.model2.ServerImpl;
import ca.infodata.ofys.ui.appointment.editor.model2.XAppointmentDateTemplateSet;
import ca.infodata.ofys.ui.appointment.editor.model2.XAppointmentWeekTemplateSet;
import ca.infodata.ofys.ui.library.log.Log;
import ca.infodata.util1.date.LocalDate;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mb.listeners.GenListenerManager;

public final class Model
implements IConsumerListener {
    private static final Logger logger = Logger.getLogger(Model.class.getName());
    private static Model instance;
    final IServer server;
    final Data data;
    final Cache cache;
    final CacheCleaner cacheCleaner;
    final Object lock = new Object();
    private boolean isDisposed;
    private GenListenerManager<IAppointmentModelListener> manager = new GenListenerManager(IAppointmentModelListener.class);
    private IAppointmentModelListener proxy = (IAppointmentModelListener)this.manager.getProxy();

    public static boolean isInstanceDisposed() {
        return instance == null || Model.instance.isDisposed;
    }

    public static Model getInstance() {
        if (instance == null) {
            instance = new Model();
        }
        return instance;
    }

    public static void disposeInstance() {
        if (instance != null) {
            instance.dispose();
            instance = null;
        }
    }

    Model() {
        this(new ServerImpl());
    }

    public Model(IServer server) {
        this.server = server;
        this.data = new Data(server);
        this.cache = new Cache(server, this.data){

            @Override
            void outProcessReceivedObjects(XAppointmentCompleteDataContainer container) {
                Model.this.data.initBlock(container);
            }
        };
        this.cacheCleaner = new CacheCleaner(this);
        Application.get().getGlobalInstances().getNotificationSystem().addListener((IConsumerListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        logger.info("Model.reset");
        try {
            Object object = this.lock;
            synchronized (object) {
                this.cache.reset();
                this.data.reset();
                ConcurrentHashMap<XBaseProfessionnal, Set<LocalDate>> vetos = this.cacheCleaner.getVetos();
                for (Map.Entry<XBaseProfessionnal, Set<LocalDate>> veto : vetos.entrySet()) {
                    XBaseProfessionnal prof = veto.getKey();
                    TreeSet dates = new TreeSet(veto.getValue());
                    if (dates.size() <= 0) continue;
                    System.out.println(veto.getKey() + " = " + veto.getValue().size());
                    LocalDate startDate = (LocalDate)dates.first();
                    LocalDate endDate = (LocalDate)dates.last();
                    this.initBlock(startDate, endDate, prof.getId());
                }
            }
            this.proxy.appointmentPeriodTypesChanged();
            this.proxy.baseAppointmentDatesChanged();
            this.proxy.appointmentDateTemplatesChanged();
            this.proxy.appointmentWeekTemplateChanged();
            this.proxy.appointmentDatesChanged();
            this.proxy.appointmentsChanged();
        }
        catch (Exception e) {
            Log.severe((String)"Model-donop instance dispose exception", (Exception)e);
        }
    }

    private void dispose() {
        this.isDisposed = true;
        try {
            this.cache.dispose();
        }
        catch (Exception e) {
            Log.severe((String)"Model-cache instance dispose exception", (Exception)e);
        }
        try {
            this.cacheCleaner.dispose();
        }
        catch (Exception e) {
            Log.severe((String)"Model-cacheCleaner instance dispose exception", (Exception)e);
        }
        try {
            this.data.dispose();
        }
        catch (Exception e) {
            Log.severe((String)"Model-data instance dispose exception", (Exception)e);
        }
        try {
            Application.get().getGlobalInstances().getNotificationSystem().removeListener((IConsumerListener)this);
        }
        catch (Exception e) {
            Log.severe((String)"Model-donop instance dispose exception", (Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initBlock(LocalDate startDate, LocalDate endDate, Integer professional) {
        Object object = this.lock;
        synchronized (object) {
            if (this.shouldDoCall(startDate, endDate, professional)) {
                try {
                    this.server.getCompleteAppointmentData_sync(Application.get().getGlobalInstances().getSession(), new Callback((IStatusHandler)new JustLogStatusHandler()){

                        public void responseReceived(ReturnObject response) {
                            XAppointmentCompleteDataContainer container = (XAppointmentCompleteDataContainer)response.getObj();
                            Model.this.data.initBlock(container);
                            HashSet<Integer> queriedProfessionnals = new HashSet<Integer>();
                            if (container.appointmentDates != null) {
                                for (XAppointmentDate xdate : container.appointmentDates) {
                                    queriedProfessionnals.add(xdate.getProfessional());
                                }
                            }
                            if (container.baseAppointmentDates != null) {
                                for (XAppointmentDate xdate : container.baseAppointmentDates) {
                                    queriedProfessionnals.add(xdate.getProfessional());
                                }
                            }
                            Model.this.cache.initBlock(LocalDate.fromDayFrom1970((int)container.cacheStart), LocalDate.fromDayFrom1970((int)container.cacheEnd), queriedProfessionnals);
                        }
                    }, startDate, endDate, Arrays.asList(professional));
                }
                catch (Exception e) {
                    Log.severe((String)"erreur", (Exception)e);
                }
            }
        }
    }

    private boolean shouldDoCall(LocalDate startDate, LocalDate endDate, Integer professional) {
        if (this.data.getLstProfessional().isEmpty()) {
            return true;
        }
        List dates = LocalDate.generateList((LocalDate)startDate, (LocalDate)endDate);
        if (professional != null) {
            for (LocalDate date : dates) {
                if (this.cache.isBaseAppointmentDateInCache(date, professional)) continue;
                return true;
            }
        } else {
            for (XBaseProfessionnal prof : this.data.getLstProfessional()) {
                for (LocalDate date : dates) {
                    if (this.cache.isBaseAppointmentDateInCache(date, prof.getId())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XAppointmentDate getDateFromCache(LocalDate date, Integer professional) {
        Object object = this.lock;
        synchronized (object) {
            return this.data.getAppointmentDates().get(date, professional);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XAppointmentDate getDate(LocalDate date, Integer professional) {
        Object object = this.lock;
        synchronized (object) {
            this.cache.checkCacheForAppointmentDate(date, professional);
            return this.data.getAppointmentDates().get(date, professional);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XBaseAppointmentDate getBaseDate(LocalDate date, Integer professional) {
        Object object = this.lock;
        synchronized (object) {
            this.cache.checkCacheForBaseAppointmentDates(date, professional);
            return this.data.getBaseAppointmentDates().get(date, professional);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkCacheForBaseAppointmentDates(List<LocalDate> dates, List<Integer> professionals) {
        Object object = this.lock;
        synchronized (object) {
            this.cache.checkCacheForBaseAppointmentDates(dates, professionals);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkCacheForAppointmentDates(Collection<LocalDate> dates, List<Integer> professionals) {
        Object object = this.lock;
        synchronized (object) {
            this.cache.checkCacheForAppointmentDates(dates, professionals);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkCacheForAppointmentDates(LocalDate date, Integer professional) {
        Object object = this.lock;
        synchronized (object) {
            this.cache.checkCacheForAppointmentDate(date, professional);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBaseAppointmentDateInCache(LocalDate date, Integer professional) {
        Object object = this.lock;
        synchronized (object) {
            return this.cache.isBaseAppointmentDateInCache(date, professional);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAppointmentDateInCache(LocalDate date, Integer professional) {
        Object object = this.lock;
        synchronized (object) {
            return this.cache.isAppointmentDateInCache(date, professional);
        }
    }

    public XAppointmentDateTemplateSet getLstAppointmentDateTemplate() {
        return this.data.getLstAppointmentDateTemplate();
    }

    public XAppointmentWeekTemplateSet getLstAppointmentWeekTemplate() {
        return this.data.getLstAppointmentWeekTemplate();
    }

    public Collection<XBaseProfessionnal> getLstProfessional() {
        return this.data.getLstProfessional();
    }

    public Collection<XPersonGroup> getLstPersonGroup() {
        return this.data.getLstPersonGroup();
    }

    protected void finalize() throws Throwable {
        logger.log(Level.FINE, this + "was finalized by gc");
        super.finalize();
    }

    public void addListener(IAppointmentModelListener listener) {
        this.manager.addListener((Object)listener);
    }

    public void removeListener(IAppointmentModelListener listener) {
        this.manager.removeListener((Object)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markAsUsing(XBaseProfessionnal prof, Collection<LocalDate> dates) {
        Object object = this.lock;
        synchronized (object) {
            this.cacheCleaner.veto(prof, dates);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markAsUnusing(XBaseProfessionnal prof, Collection<LocalDate> dates) {
        Object object = this.lock;
        synchronized (object) {
            this.cacheCleaner.unveto(prof, dates);
        }
    }

    public IAppointment getCutTemp() {
        return this.data.getCutTemp();
    }

    public void setCutTemp(IAppointment cutTemp) {
        this.data.setCutTemp(cutTemp);
    }

    public IAppointment getCopyTemp() {
        return this.data.getCopyTemp();
    }

    public void setCopyTemp(IAppointment copyTemp) {
        this.data.setCopyTemp(copyTemp);
    }

    public IEditableDataObjectList<XAppointment> getAppointments(LocalDate date, Integer idProf) {
        return this.data.getAppointments(idProf, date);
    }

    public IEditableDataObjectList<XReservedAppointment> getReservedAppointments(LocalDate date, Integer idProf) {
        return this.data.getReservedAppointments(idProf, date);
    }

    public XAppointment getAppointment(Integer id) {
        return this.data.getAppointments().get(id);
    }

    public void handle(DataObjectUpdatedNotification notification) {
        try {
            this._handle(notification);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error in Model.handle", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _handle(DataObjectUpdatedNotification notification) {
        IDataObject object = notification.getObject();
        if (object == null) {
            return;
        }
        logger.info("Model" + System.identityHashCode(this) + " handle " + object);
        if (object instanceof XReservedAppointment) {
            logger.info("Model" + System.identityHashCode(this) + " handle XReservedAppointment " + object);
            XReservedAppointment xReservedAppt = (XReservedAppointment)object;
            Object object2 = this.lock;
            synchronized (object2) {
                if (xReservedAppt.isInvalidateMe()) {
                    this.data.getReservedAppointments().replace(xReservedAppt);
                } else {
                    boolean b = this.data.getReservedAppointments().replace(xReservedAppt);
                    if (!b) {
                        throw new IllegalStateException("XReservedAppointment " + xReservedAppt + " was not replaced in model");
                    }
                }
            }
            this.proxy.handleNotification(notification);
        } else if (object instanceof XBaseAppointmentDate) {
            logger.info("Model" + System.identityHashCode(this) + " handle XBaseAppointmentDate " + object);
            XBaseAppointmentDate xdate = (XBaseAppointmentDate)object;
            Object object3 = this.lock;
            synchronized (object3) {
                this.data.getBaseAppointmentDates().remove(xdate);
                this.data.getBaseAppointmentDates().add(xdate);
            }
            this.proxy.handleNotification(notification);
            this.proxy.baseAppointmentDatesChanged();
        } else if (object instanceof XAppointmentDate) {
            logger.info("Model" + System.identityHashCode(this) + " handle XAppointmentDate " + object);
            XAppointmentDate xdate = (XAppointmentDate)object;
            Object object4 = this.lock;
            synchronized (object4) {
                this.data.getAppointmentDates().remove(xdate);
                this.data.getAppointmentDates().add(xdate);
                this.cache.removeBase(xdate.getProfessional(), xdate.getDate());
            }
            this.proxy.handleNotification(notification);
            this.proxy.appointmentDatesChanged();
            this.proxy.baseAppointmentDatesChanged();
        } else if (object instanceof XAppointmentDateKey) {
            logger.info("Model" + System.identityHashCode(this) + " handle XAppointmentDateKey " + object);
            XAppointmentDateKey xdatekey = (XAppointmentDateKey)object;
            Object object5 = this.lock;
            synchronized (object5) {
                this.cache.removeBase(xdatekey.professional, xdatekey.date);
            }
            this.proxy.handleNotification(notification);
            this.proxy.baseAppointmentDatesChanged();
            this.proxy.appointmentDatesChanged();
        } else if (object instanceof XAppointment) {
            logger.info("Model" + System.identityHashCode(this) + " handle XAppointment " + object);
            XAppointment appointment = (XAppointment)object;
            boolean doNotify = false;
            boolean doNotifyAppointmentMoved = false;
            XAppointment doNotifyAppointmentMovedModelVersion = null;
            Object object6 = this.lock;
            synchronized (object6) {
                boolean showRdvs;
                List patients = appointment.getPatients();
                XConsentement consent = new XConsentement();
                boolean showToAll = true;
                Iterator iterator = patients.iterator();
                while (iterator.hasNext()) {
                    XPatient patient = (XPatient)iterator.next();
                    boolean bl = showToAll = showToAll && patient.getShowToAllAndConsent(consent, Application.get().getGlobalInstances().getSessionIdUser());
                }
                boolean checkDroit = false;
                if (!showToAll && consent.getDroits() != null) {
                    checkDroit = true;
                }
                boolean bl = showRdvs = showToAll || checkDroit && consent.hasRightRdvs();
                if (showRdvs) {
                    XAppointment modelVersion = this.data.getAppointments().get(appointment.getId());
                    if (modelVersion != null && modelVersion.getId() != null && modelVersion.getVersion() != null && modelVersion.getVersion() > appointment.getVersion()) {
                        logger.info("Model" + System.identityHashCode(this) + " XAppointment not replaced.\n\tLocal=" + modelVersion + "\n\tNotification=" + appointment);
                        return;
                    }
                    boolean b = this.data.getAppointments().replace(appointment);
                    if (!b) {
                        throw new IllegalStateException("appointment " + appointment + " was not replaced in model");
                    }
                    for (Integer idProf : appointment.getIdProfessionals()) {
                        this.cache.removeBase(idProf, appointment.getDate());
                    }
                    doNotify = true;
                    if (!(modelVersion == null || modelVersion.getDate().equals((Object)appointment.getDate()) && modelVersion.getIdProfessionals().equals(appointment.getIdProfessionals()))) {
                        doNotifyAppointmentMoved = true;
                        doNotifyAppointmentMovedModelVersion = modelVersion;
                    }
                }
            }
            if (doNotify) {
                this.proxy.handleNotification(notification);
                this.proxy.currentAppointmentChanged(appointment);
                this.proxy.baseAppointmentDatesChanged();
            }
            if (doNotifyAppointmentMoved) {
                for (Integer idProf : doNotifyAppointmentMovedModelVersion.getIdProfessionals()) {
                    this.proxy.handleNotification(new DataObjectUpdatedNotification((IDataObject)new XAppointmentDateKey(idProf, doNotifyAppointmentMovedModelVersion.getDate())));
                }
            }
        } else if (object instanceof XAppointmentDateTemplate) {
            logger.info("Model" + System.identityHashCode(this) + " handle XAppointmentDateTemplate " + object);
            XAppointmentDateTemplate template = (XAppointmentDateTemplate)object;
            Object object7 = this.lock;
            synchronized (object7) {
                this.data.getLstAppointmentDateTemplate().replace(template, template);
            }
            this.proxy.handleNotification(notification);
            this.proxy.appointmentDateTemplatesChanged();
        } else if (object instanceof XAppointmentWeekTemplate) {
            logger.info("Model" + System.identityHashCode(this) + " handle XAppointmentWeekTemplate " + object);
            XAppointmentWeekTemplate template = (XAppointmentWeekTemplate)object;
            Object object8 = this.lock;
            synchronized (object8) {
                this.data.getLstAppointmentWeekTemplate().replace(template, template);
            }
            this.proxy.handleNotification(notification);
            this.proxy.appointmentWeekTemplateChanged();
        } else if (object instanceof XPatient) {
            logger.info("Model" + System.identityHashCode(this) + " handle XPatient  " + object);
            XPatient patient = (XPatient)object;
            Object object9 = this.lock;
            synchronized (object9) {
                for (XAppointment appointment : this.data.getAppointments().getAll()) {
                    List patients = appointment.getPatients();
                    int indexOf = patients.indexOf(patient);
                    if (indexOf == -1) continue;
                    ObjectListenerManager.disable((Object)patients);
                    patients.set(indexOf, patient);
                    ObjectListenerManager.disable((Object)patients);
                }
            }
            this.proxy.handleNotification(notification);
        } else if (object instanceof XAppointmentPeriodType) {
            this.proxy.appointmentPeriodTypesChanged();
        }
    }

    public void refresFromServer(List<? extends IDataObject> list) {
        Callback callback = new Callback((IStatusHandler)new JustLogStatusHandler()){

            public void responseReceived(ReturnObject response) {
                XAppointmentObjects x = (XAppointmentObjects)response.getObj();
                for (XAppointment e : x.getAppointments()) {
                    Model.this.handle(new DataObjectUpdatedNotification((IDataObject)e));
                }
                for (XAppointment e : x.getAppointmentDates()) {
                    Model.this.handle(new DataObjectUpdatedNotification((IDataObject)e));
                }
                for (XAppointment e : x.getAppointmentDateTemplates()) {
                    Model.this.handle(new DataObjectUpdatedNotification((IDataObject)e));
                }
                for (XAppointment e : x.getAppointmentWeekTemplates()) {
                    Model.this.handle(new DataObjectUpdatedNotification((IDataObject)e));
                }
            }
        };
        XAppointmentObjects object = new XAppointmentObjects();
        for (IDataObject iDataObject : list) {
            if (iDataObject instanceof XAppointment) {
                object.getAppointments().add((XAppointment)iDataObject);
                continue;
            }
            if (iDataObject instanceof XAppointmentDate) {
                object.getAppointmentDates().add((XAppointmentDate)iDataObject);
                continue;
            }
            if (iDataObject instanceof XAppointmentDateTemplate) {
                object.getAppointmentDateTemplates().add((XAppointmentDateTemplate)iDataObject);
                continue;
            }
            if (!(iDataObject instanceof XAppointmentWeekTemplate)) continue;
            object.getAppointmentWeekTemplates().add((XAppointmentWeekTemplate)iDataObject);
        }
        try {
            AppointmentAccessorClient.getInstance().refreshFromServerSync(object.hashCode(), (ICallback)callback, Application.get().getGlobalInstances().getSession(), object);
        }
        catch (CannotConnectToServerException cannotConnectToServerException) {
            logger.log(Level.SEVERE, "", cannotConnectToServerException);
        }
    }

    public IServer getServer() {
        return this.server;
    }

    public void forceRefresh() {
        logger.log(Level.INFO, "model reset called by RabbitMqConsumer listener");
        try {
            this.reset();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error in Model.forceRefresh", e);
        }
    }

    public void handleOther(Notification notification) {
    }

    public static interface IAppointmentModelListener {
        public void appointmentDatesChanged();

        public void appointmentDateTemplatesChanged();

        public void appointmentWeekTemplateChanged();

        public void baseAppointmentDatesChanged();

        public void professionalsChanged();

        public void appointmentsChanged();

        public void appointmentPeriodTypesChanged();

        public void currentAppointmentChanged(XAppointment var1);

        public void handleNotification(DataObjectUpdatedNotification var1);
    }
}

