/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.appointment.editor.controller;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.AppointmentAccessorClient;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.callback.IStatusHandler;
import ca.infodata.ofys.data.dataaccess.callback.SaveCallback;
import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointment;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentDate;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentDateTemplate;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentWeekTemplate;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XReservedAppointment;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObjectList;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IMinimalEditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.status.Status;
import ca.infodata.ofys.ui.appointment.AppointmentPlugin;
import ca.infodata.ofys.ui.appointment.editor.controller.XObjectContainer2;
import ca.infodata.ofys.ui.appointment.editor.model2.IServer;
import ca.infodata.util1.ClosureA;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

class Crud2 {
    static final Logger logger = Logger.getLogger(Crud2.class.getName());
    private final ArrayList<Serializable> container;
    private boolean askQuestion;
    private IStatusHandler statusHandler;
    private IServer server;
    private static final List saveableClasses = Arrays.asList(XAppointmentDate.class, XAppointmentDateTemplate.class, XAppointmentWeekTemplate.class, XAppointment.class, XReservedAppointment.class);

    public Crud2(IServer server, XObjectContainer2 container, boolean askQuestion, IStatusHandler statusHandler) {
        this.server = server;
        this.container = Crud2.getObjectToSave(container);
        this.askQuestion = askQuestion;
        this.statusHandler = statusHandler == null ? AppointmentPlugin.getDefaultStatusHandler() : statusHandler;
    }

    public IStatus saveReservation() {
        IStatus status = Status.OK_STATUS;
        if (this.container.isEmpty()) {
            logger.info("crud : Nothing to save");
        } else {
            ArrayList data;
            block8: {
                logger.info("crud : Saving " + this.container.size() + " objects ");
                SaveAllCallbackExtension callback = null;
                try {
                    callback = new SaveAllCallbackExtension(Application.get().getGlobalInstances().getSession(), this.statusHandler);
                    AppointmentAccessorClient.getInstance().saveReservedAppt(Application.get().getGlobalInstances().getSession(), this.container, (SaveCallback)callback);
                    status = callback.getStatus();
                    status = status == null ? new Status(IStatus.Severity.BUG) : status;
                }
                catch (CannotConnectToServerException e) {
                    logger.log(Level.SEVERE, "", e);
                    status = new Status(IStatus.Severity.ERROR);
                }
                catch (Exception e) {
                    status = new Status(IStatus.Severity.ERROR, "save exception", (Throwable)e);
                    logger.log(Level.WARNING, "Failed to save", e);
                    if (callback == null || callback.killed()) break block8;
                    callback.kill();
                }
            }
            if (status.isOkToProceed() && (data = (ArrayList)status.getData()) != null) {
                for (IMinimalEditableDataObject e : data) {
                    for (Serializable s : this.container) {
                        IMinimalEditableDataObject xr;
                        if (!(s instanceof IMinimalEditableDataObject) || !(xr = (IMinimalEditableDataObject)s).getTag().equals(e.getTag())) continue;
                        xr.setId(e.getId());
                    }
                }
            }
        }
        return status;
    }

    public IStatus extendsReservation() {
        IStatus status = Status.OK_STATUS;
        if (this.container.isEmpty()) {
            logger.info("crud : Nothing to save");
        } else {
            ArrayList data;
            block8: {
                logger.info("crud : Saving " + this.container.size() + " objects ");
                SaveAllCallbackExtension callback = null;
                try {
                    callback = new SaveAllCallbackExtension(Application.get().getGlobalInstances().getSession(), this.statusHandler);
                    AppointmentAccessorClient.getInstance().extendsReservedAppt(Application.get().getGlobalInstances().getSession(), this.container, (SaveCallback)callback);
                    status = callback.getStatus();
                    status = status == null ? new Status(IStatus.Severity.BUG) : status;
                }
                catch (CannotConnectToServerException e) {
                    logger.log(Level.SEVERE, "", e);
                    status = new Status(IStatus.Severity.ERROR);
                }
                catch (Exception e) {
                    status = new Status(IStatus.Severity.ERROR, "save exception", (Throwable)e);
                    logger.log(Level.WARNING, "Failed to save", e);
                    if (callback == null || callback.killed()) break block8;
                    callback.kill();
                }
            }
            if (status.isOkToProceed() && (data = (ArrayList)status.getData()) != null) {
                for (IMinimalEditableDataObject e : data) {
                    for (Serializable s : this.container) {
                        IMinimalEditableDataObject xr;
                        if (!(s instanceof IMinimalEditableDataObject) || !(xr = (IMinimalEditableDataObject)s).getTag().equals(e.getTag())) continue;
                        xr.setId(e.getId());
                    }
                }
            }
        }
        return status;
    }

    public void cancelReservation() {
        if (this.container.isEmpty()) {
            logger.info("crud : Nothing to cancelReservation");
        } else {
            logger.info("crud : Cancelling " + this.container.size() + " objects ");
            try {
                AppointmentAccessorClient.getInstance().deleteReservedAppt(Application.get().getGlobalInstances().getSession(), this.container);
            }
            catch (CannotConnectToServerException e) {
                logger.log(Level.SEVERE, "", e);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Failed to save", e);
            }
        }
    }

    public IStatus save() {
        IStatus status;
        block6: {
            status = Status.OK_STATUS;
            if (this.container.isEmpty()) {
                logger.info("crud : Nothing to save");
            } else {
                logger.info("crud : Saving " + this.container.size() + " objects ");
                SaveAllCallbackExtension callback = null;
                try {
                    callback = new SaveAllCallbackExtension(Application.get().getGlobalInstances().getSession(), this.statusHandler);
                    this.server.save_sync(this.hashCode(), Application.get().getGlobalInstances().getSession(), callback, this.askQuestion, this.container);
                    status = callback.getStatus();
                }
                catch (CannotConnectToServerException e) {
                    status = new Status(IStatus.Severity.ERROR, "CannotConnectToServer", (Throwable)e);
                    MessageUtil.cannotConnectToServerExceptionMsg();
                    if (callback != null && !callback.killed()) {
                        callback.kill();
                    }
                }
                catch (Exception e) {
                    status = new Status(IStatus.Severity.ERROR, "save exception", (Throwable)e);
                    logger.log(Level.WARNING, "Failed to save", e);
                    if (callback == null || callback.killed()) break block6;
                    callback.kill();
                }
            }
        }
        return status;
    }

    public static ArrayList<IMinimalEditableDataObject> getObjectToSaveNoLog(XObjectContainer2 container) {
        final ArrayList<IMinimalEditableDataObject> list = new ArrayList<IMinimalEditableDataObject>(container.size());
        container.iterator(new ClosureA<IMinimalEditableDataObject>(){

            public void execute(IMinimalEditableDataObject e) {
                if (Crud2.shouldAdd((Serializable)e)) {
                    list.add(e);
                }
            }
        });
        return list;
    }

    public static ArrayList<Serializable> getObjectToSave(XObjectContainer2 container) {
        logger.info("crud-size " + container.size());
        final ArrayList<Serializable> list = new ArrayList<Serializable>(container.size());
        container.iterator(new ClosureA<IMinimalEditableDataObject>(){

            public void execute(IMinimalEditableDataObject e) {
                if (Crud2.shouldAdd((Serializable)e)) {
                    if (logger.isLoggable(Level.INFO)) {
                        logger.info("crud-added " + String.valueOf(e));
                    }
                    list.add(e);
                } else if (logger.isLoggable(Level.FINE)) {
                    logger.fine("crud-skipped " + String.valueOf(e));
                }
            }
        });
        return list;
    }

    private static boolean shouldAdd(Serializable e) {
        boolean b = false;
        if (e != null) {
            if (e instanceof EditableDataObject && saveableClasses.contains(e.getClass())) {
                EditableDataObject object = (EditableDataObject)e;
                b = object.isDirty() && (!object.isNonExisting() && !object.isStatusDeleted() || object.getId() != null);
            } else if (e instanceof IMinimalEditableDataObject && saveableClasses.contains(e.getClass())) {
                b = true;
            }
        }
        return b;
    }

    public EditableDataObjectList<?> getSavedObjects() {
        return new EditableDataObjectList(this.container);
    }

    private static class SaveAllCallbackExtension
    extends SaveCallback {
        private IStatus status;

        protected IStatus getStatus() {
            return this.status;
        }

        private SaveAllCallbackExtension(XSession session, IStatusHandler statusHandler) {
            super(session, statusHandler);
        }

        public void responseReceived(ReturnObject response) {
            if (response == null) {
                this.status = new Status(IStatus.Severity.BUG, "Error", (Throwable)new RuntimeException("response is null"));
                this.status.setData(null);
            } else {
                this.status = response.getStatus();
                if (this.status.isOkToProceed()) {
                    this.status.setData((Serializable)response.getObj());
                } else {
                    this.status.setData(null);
                }
            }
        }

        public void exception(Exception e) {
            super.exception(e);
            this.status = new Status(IStatus.Severity.BUG, "Error", (Throwable)e);
        }
    }
}

