/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.appointment.editor.appointment;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IVariablesReplacer;
import ca.infodata.ofys.data.middle.dataobjects.preferences.FormatDateProvider;
import ca.infodata.ofys.ui.appointment.editor.appointment.AppointmentController;
import ca.infodata.ofys.util.json.IJsonReader;
import ca.infodata.util1.date.LocalDate;
import ca.infodata.util1.date.LocalDateFormat;

public class AppointmentVariableReplacer
implements IVariablesReplacer<AppointmentController> {
    private AppointmentController appointment;
    private LocalDate today = LocalDate.today();

    public String replaceVariables(String text) {
        String textToReplaceBy;
        int varIndexEnd;
        int varIndex;
        IPatient patient = this.appointment.getAppointment() == null ? null : this.appointment.getAppointment().getPatientOrAdhoc((IJsonReader)Application.get().getGsonProcessor());
        StringBuilder textToReturn = new StringBuilder(text);
        while ((varIndex = textToReturn.indexOf("[aujourd'hui]")) > -1) {
            varIndexEnd = varIndex + "[aujourd'hui]".length();
            textToReplaceBy = LocalDateFormat.format((LocalDate)this.today, (String)FormatDateProvider.getFormatDate().toString());
            textToReturn = textToReturn.replace(varIndex, varIndexEnd, textToReplaceBy);
        }
        if (patient != null) {
            while ((varIndex = textToReturn.indexOf("[titre]")) > -1) {
                varIndexEnd = varIndex + "[titre]".length();
                textToReplaceBy = patient.getTitle();
                textToReturn = textToReturn.replace(varIndex, varIndexEnd, textToReplaceBy);
            }
            while ((varIndex = textToReturn.indexOf("[sexe]")) > -1) {
                varIndexEnd = varIndex + "[sexe]".length();
                String gender = patient.getGender();
                String textToReplaceBy2 = "";
                if (gender == null || gender.equals("I")) {
                    textToReplaceBy2 = Messages.getString((String)"INCONNU", (String[])new String[0]);
                } else if (gender.equals("M")) {
                    textToReplaceBy2 = Messages.getString((String)"MASCULIN", (String[])new String[0]);
                } else if (gender.equals("F")) {
                    textToReplaceBy2 = Messages.getString((String)"FEMININ", (String[])new String[0]);
                }
                textToReturn = textToReturn.replace(varIndex, varIndexEnd, textToReplaceBy2);
            }
            while ((varIndex = textToReturn.indexOf("[datedenaissance]")) > -1) {
                varIndexEnd = varIndex + "[datedenaissance]".length();
                textToReplaceBy = "";
                LocalDate birthDate = patient.getBirthDate();
                if (birthDate != null) {
                    textToReplaceBy = LocalDateFormat.format((LocalDate)birthDate, (String)FormatDateProvider.getFormatDate().toString());
                }
                textToReturn = textToReturn.replace(varIndex, varIndexEnd, textToReplaceBy);
            }
            while ((varIndex = textToReturn.indexOf("[nom]")) > -1) {
                varIndexEnd = varIndex + "[nom]".length();
                textToReplaceBy = patient.getName();
                textToReturn = textToReturn.replace(varIndex, varIndexEnd, textToReplaceBy);
            }
            while ((varIndex = textToReturn.indexOf("[client.nodossier]")) > -1) {
                varIndexEnd = varIndex + "[client.nodossier]".length();
                textToReplaceBy = patient.getName();
                textToReturn = textToReturn.replace(varIndex, varIndexEnd, textToReplaceBy);
            }
        }
        while ((varIndex = textToReturn.indexOf("[datederencontre]")) > -1) {
            varIndexEnd = varIndex + "[datederencontre]".length();
            textToReplaceBy = LocalDateFormat.format((LocalDate)this.appointment.getDate(), (String)FormatDateProvider.getFormatDate().toString());
            textToReturn = textToReturn.replace(varIndex, varIndexEnd, textToReplaceBy);
        }
        return textToReturn.toString();
    }

    public void setDataObject(AppointmentController dataObject) {
        this.appointment = dataObject;
    }

    public void setToday(LocalDate today) {
        this.today = today;
    }
}

