/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.appointment.editor.appointment;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.callback.IStatusHandler;
import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.XContactInformation;
import ca.infodata.ofys.data.middle.dataobjects.XPatient;
import ca.infodata.ofys.data.middle.dataobjects.appointment.IAppointment;
import ca.infodata.ofys.data.middle.dataobjects.appointment.IVisualAppointment;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointment;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentPeriodType;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentStatus;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentType;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XPatientStatus;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IMinimalEditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ModificationStatus;
import ca.infodata.ofys.data.middle.dataobjects.site.SiteAddedAs;
import ca.infodata.ofys.data.middle.dataobjects.site.XPersonSite;
import ca.infodata.ofys.data.middle.dataobjects.site.XSite;
import ca.infodata.ofys.mb.listener.object.IObjectListener;
import ca.infodata.ofys.mb.listener.object.ObjectListenerManager;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.ui.appointment.XAppointmentFormatter;
import ca.infodata.ofys.ui.appointment.editor.controller.AppointmentControllerAdapter;
import ca.infodata.ofys.ui.appointment.editor.controller.AppointmentMainController;
import ca.infodata.ofys.ui.appointment.editor.controller.XObjectContainer2;
import ca.infodata.ofys.ui.library.log.Log;
import ca.infodata.ofys.util.MiscUtil;
import ca.infodata.ofys.util.json.IJsonReader;
import ca.infodata.ofys.util.json.IJsonWriter;
import ca.infodata.util1.date.LocalDate;
import java.io.IOException;
import java.io.StringReader;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.mb.listeners.GenListenerManager;
import org.mb.listeners.IListenerManager;

public class AppointmentController {
    private final IListenerManager<IAppointmentControllerListener> manager;
    private final IAppointmentControllerListener proxy;
    private AppointmentMainController appointmentController;
    private final AppointmentControllerAdapterExtension controllerListener;
    private XAppointment appointment;
    private IPatient currentPatient;

    public AppointmentController(AppointmentMainController controller) {
        block12: {
            if (controller == null) {
                throw new IllegalArgumentException();
            }
            this.manager = new GenListenerManager(IAppointmentControllerListener.class);
            this.proxy = (IAppointmentControllerListener)this.manager.getProxy();
            this.controllerListener = new AppointmentControllerAdapterExtension();
            this.setAppointmentController(controller);
            IAppointment appointment = this.appointmentController.getCurrentAppointment();
            this.setAppointment(appointment);
            List patients = appointment.getPatientsOrAdhoc((IJsonReader)Application.get().getGsonProcessor());
            if (patients.isEmpty() && StringUtils.isNotBlank((CharSequence)appointment.getNote())) {
                Properties p = new Properties();
                try {
                    p.load(new StringReader(appointment.getNote()));
                    String ln = p.getProperty("Nom/lastname");
                    String fn = p.getProperty("Prenom/firstname");
                    String dob = p.getProperty("DDN/DOB");
                    String sex = p.getProperty("Sex");
                    String nam = p.getProperty("NAM/HIN");
                    String tel = p.getProperty("Tel");
                    String email = p.getProperty("Email");
                    String cell = p.getProperty("Cell");
                    String lang = p.getProperty("Lang");
                    if (!StringUtils.isNotBlank((CharSequence)nam) && (!StringUtils.isNotBlank((CharSequence)fn) || !StringUtils.isNotBlank((CharSequence)ln) || !StringUtils.isNotBlank((CharSequence)sex) || !StringUtils.isNotBlank((CharSequence)dob))) break block12;
                    System.out.println(String.format("%s, %s, %s, %s, %s, %s, %s, %s, %s", ln, fn, dob, sex, nam, tel, email, cell, lang));
                    XPatient x = this.addNewPatient();
                    x.firstName = fn;
                    x.lastName = ln;
                    x.gender = sex;
                    x.healthInsuranceNumber = nam;
                    if (StringUtils.isNotBlank((CharSequence)dob)) {
                        try {
                            FastDateFormat dateSdf = FastDateFormat.getInstance((String)"yyyy-MM-dd");
                            Calendar c = Calendar.getInstance();
                            c.setTime(dateSdf.parse(dob));
                            x.birthDate = LocalDate.fromCalendar((Calendar)c);
                        }
                        catch (ParseException parseException) {}
                    }
                    XContactInformation c1 = null;
                    XContactInformation c2 = null;
                    XContactInformation c3 = null;
                    if (tel != null) {
                        c1 = new XContactInformation();
                        c1.setTypeContact(XContactInformation.CONTACT_TYPE_PHONE);
                        c1.setContact(tel);
                        c1.setImportance(Short.valueOf((short)0));
                        x.addContactInformation(c1);
                    }
                    if (cell != null) {
                        c2 = new XContactInformation();
                        c2.setTypeContact(XContactInformation.CONTACT_TYPE_CELL_TEXTO);
                        c2.setContact(cell);
                        c2.setImportance(Short.valueOf((short)256));
                        if (c1 == null) {
                            c2.setImportance(Short.valueOf((short)0));
                        }
                        x.addContactInformation(c2);
                    }
                    if (email != null) {
                        c3 = new XContactInformation();
                        c3.setTypeContact(XContactInformation.CONTACT_TYPE_EMAIL);
                        c3.setContact(email);
                        c3.setImportance(Short.valueOf((short)512));
                        if (c2 == null && c1 == null) {
                            c3.setImportance(Short.valueOf((short)0));
                        }
                        x.addContactInformation(c3);
                    }
                    this.setCurrentPatient((IPatient)x);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void setAppointment(IAppointment a) {
        System.out.println("AppointmentController.setAppointment() " + a);
        XAppointment b = (XAppointment)this.appointmentController.getAppointment((IVisualAppointment)a);
        ObjectListenerManager.removeListener((Object)this.appointment, (IObjectListener)this.controllerListener);
        this.appointment = b;
        ObjectListenerManager.addListener((Object)this.appointment, (IObjectListener)this.controllerListener);
        if (this.appointment == null) {
            this.setCurrentPatient(null);
        } else if (this.getAppointmentMainController().canSeeAndModifyAppointment((IAppointment)this.appointment)) {
            List patients = this.appointment.getPatientsOrAdhoc((IJsonReader)Application.get().getGsonProcessor());
            if (patients.size() > 0) {
                this.setCurrentPatient((IPatient)patients.iterator().next());
            } else {
                this.setCurrentPatient(null);
            }
        } else {
            this.setCurrentPatient(null);
        }
        this.proxy.appointmentChanged();
    }

    public boolean hasAppointment() {
        return this.getAppointment() != null;
    }

    public IStatus extendsReservation(XObjectContainer2 reservation) {
        return this.getAppointmentMainController().extendsReservation(reservation);
    }

    public IStatus save(IProgressMonitor monitor, boolean askQuestion, IStatusHandler statusHandler) {
        XAppointment appointment = this.getAppointment();
        Log.logOperation((String)"AppointmentController.save", (Object[])new Object[]{appointment});
        try {
            if (appointment != null) {
                XPatient adhocPatient = appointment.getAdhocPatient((IJsonReader)Application.get().getGsonProcessor());
                if (adhocPatient != null) {
                    appointment.getPatients().add(adhocPatient);
                    appointment.setAdhocPatient((IJsonWriter)Application.get().getGsonProcessor(), null);
                }
                Iterator patients = this.getAppointment().getPatients().iterator();
                while (patients.hasNext()) {
                    XPatient x = (XPatient)patients.next();
                    if (x.getId() != null || !StringUtils.isEmpty((CharSequence)x.getFirstName()) || !StringUtils.isEmpty((CharSequence)x.getLastName())) continue;
                    patients.remove();
                }
                IStatus status = this.getAppointmentMainController().saveAll(askQuestion, statusHandler);
                if (monitor != null) {
                    monitor.done();
                }
                IStatus iStatus = status;
                return iStatus;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
        return null;
    }

    public void cancel() {
        Log.logOperation((String)("AppointmentController.cancel isDirty=" + this.isDirty()), (Object[])new Object[0]);
        XAppointment appointment = this.getAppointment();
        if (appointment != null) {
            this.getAppointmentMainController().cancelAll();
        }
    }

    public String format(boolean includeDate, boolean includeProfessional) {
        XAppointment appointment = this.getAppointment();
        if (appointment != null) {
            return XAppointmentFormatter.format((IAppointment)appointment, includeDate, includeProfessional, false, false, false);
        }
        return "";
    }

    public Integer getVersion() {
        return this.getAppointment() == null ? null : this.getAppointment().getVersion();
    }

    public boolean isDirty() {
        XAppointment appointment = this.getAppointment();
        return appointment != null && appointment.isDirty();
    }

    public Collection<XAppointmentType> getLstAppointmentType() {
        return this.getAppointmentMainController().getLstAppointmentType();
    }

    public Collection<XAppointmentPeriodType> getLstAppointmentPeriodType() {
        return this.getAppointmentMainController().getLstAppointmentPeriodType();
    }

    public Integer getArrivedTime() {
        return this.getAppointment() == null || this.getAppointment().getArrivedTime() == null ? null : Integer.valueOf(this.getAppointment().getArrivedTime().intValue());
    }

    public String getDateTimeDuree() {
        return this.getAppointment() == null ? null : this.getAppointment().getDateTimeDuree();
    }

    public LocalDate getDate() {
        return this.getAppointment() == null ? null : this.getAppointment().getDate();
    }

    public Long getDateCreated() {
        return this.getAppointment() == null ? null : this.getAppointment().getDateCreated();
    }

    public Long getDateEntryLast() {
        return this.getAppointment() == null ? null : this.getAppointment().getDateEntryLast();
    }

    public String getNameUser() {
        return this.getAppointment() == null ? null : this.getAppointment().getNameUser();
    }

    public String getDuree() {
        return this.getAppointment() == null ? null : this.getAppointment().getDuree();
    }

    public Integer getEndTime() {
        return this.getAppointment() == null || this.getAppointment().getEndTime() == null ? null : Integer.valueOf(this.getAppointment().getEndTime().intValue());
    }

    public Integer getId() {
        return this.getAppointment() == null ? null : this.getAppointment().getId();
    }

    public Boolean getIsAnnualExam() {
        return this.getAppointment() == null ? null : this.getAppointment().getIsAnnualExam();
    }

    public Boolean getIsDeleted() {
        return this.getAppointment() == null ? null : this.getAppointment().getIsDeleted();
    }

    public ModificationStatus getModificationStatus() {
        return this.getAppointment() == null ? null : this.getAppointment().getModificationStatus();
    }

    public String getNote() {
        return this.getAppointment() == null ? null : this.getAppointment().getNote();
    }

    public XPatientStatus getPatientStatus() {
        return this.getAppointment() == null ? null : this.getAppointment().getPatientStatus();
    }

    public Integer getSeenTime() {
        return this.getAppointment() == null || this.getAppointment().getSeenTime() == null ? null : Integer.valueOf(this.getAppointment().getSeenTime().intValue());
    }

    public Integer getStartTime() {
        return this.getAppointment() == null || this.getAppointment().getStartTime() == null ? null : Integer.valueOf(this.getAppointment().getStartTime().intValue());
    }

    public XAppointmentStatus getStatus() {
        return this.getAppointment() == null ? null : this.getAppointment().getStatus();
    }

    public String getStatusNote() {
        return this.getAppointment() == null ? null : this.getAppointment().getStatusNote();
    }

    public XAppointmentType getAppointmentType() {
        if (this.getAppointment() == null) {
            return null;
        }
        return this.getAppointmentMainController().getObjectResolver().getAppointmentType(this.getAppointment().getTypeAppointment());
    }

    public String getNotePatient() {
        return this.getAppointment().getNotePatient();
    }

    public boolean getWasProfNameHidden() {
        return Boolean.TRUE.equals(this.getAppointment().getWasProfNameHidden());
    }

    public XBaseProfessionnal getAppointmentProfessionnalReferer() {
        Integer idProf;
        if (this.getAppointment() != null && (idProf = this.getAppointment().getProfessionnalReferer()) != null) {
            return this.getAppointmentMainController().getObjectResolver().getProfessionnal(idProf);
        }
        return null;
    }

    public Set<Integer> getIdProfessionals() {
        return this.getAppointment() == null ? null : this.getAppointment().getIdProfessionals();
    }

    public boolean canSeeAndModifyAppointment() {
        return this.appointmentController.canSeeAndModifyAppointment((IAppointment)this.getAppointment());
    }

    public final boolean isDeleted() {
        return this.getAppointment() == null ? false : this.getAppointment().isStatusDeleted();
    }

    public void setIsConfidential(boolean value) {
        if (this.getAppointment() != null) {
            this.getAppointment().setIsConfidential(Boolean.valueOf(value));
        }
    }

    public Boolean getIsConfidential() {
        return this.getAppointment() == null ? null : this.getAppointment().getIsConfidential();
    }

    public void setArrivedTime(Integer arrivedTime) {
        if (this.getAppointment() != null) {
            this.getAppointment().setArrivedTime(arrivedTime == null ? null : Short.valueOf(arrivedTime.shortValue()));
        }
    }

    public void setEndTime(Integer endTime) {
        if (this.getAppointment() != null && !this.getAppointment().getEndTime().equals(endTime)) {
            this.getAppointment().setEndTime(endTime == null ? null : Short.valueOf(endTime.shortValue()));
        }
    }

    public void setId(Integer id) {
        if (this.getAppointment() != null) {
            this.getAppointment().setId(id);
        }
    }

    public void setIsAnnualExam(Boolean isAnnualExam) {
        if (this.getAppointment() != null) {
            this.getAppointment().setIsAnnualExam(isAnnualExam);
        }
    }

    public void setIsDeleted(Boolean isDeleted) {
        if (this.getAppointment() != null) {
            this.getAppointment().setIsDeleted(isDeleted);
        }
    }

    public void setListenerEnabled(boolean enable) {
        if (this.getAppointment() != null) {
            this.getAppointment().setListenerEnabled(enable);
        }
    }

    public void setNote(String note) {
        if (this.getAppointment() != null) {
            this.getAppointment().setNote(note);
        }
    }

    public void setStatusNote(String note) {
        if (this.getAppointment() != null) {
            this.getAppointment().setStatusNote(note);
        }
    }

    public void setPatientStatus(XPatientStatus patientStatus) {
        if (this.getAppointment() != null) {
            this.getAppointment().setPatientStatus(patientStatus);
        }
    }

    public void setSeenTime(Integer seenTime) {
        if (this.getAppointment() != null) {
            this.getAppointment().setSeenTime(seenTime == null ? null : Short.valueOf(seenTime.shortValue()));
        }
    }

    public void setStartTime(Integer startTime) {
        if (this.getAppointment() != null) {
            this.getAppointment().setStartTime(startTime == null ? null : Short.valueOf(startTime.shortValue()));
        }
    }

    public void setStatus(XAppointmentStatus status) {
        if (this.getAppointment() != null) {
            this.getAppointment().setStatus(status);
        }
    }

    public void setProfessionnalReferer(Integer idProfessionnal) {
        if (this.getAppointment() != null) {
            this.getAppointment().setProfessionnalReferer(idProfessionnal);
        }
    }

    public void setAppointmentType(XAppointmentType type) {
        if (!MiscUtil.areObjectsEquals((Object)(type == null ? null : type.getId()), (Object)this.getAppointment().getTypeAppointment())) {
            Short duree;
            Integer startTime = this.getStartTime();
            if (type != null && startTime != null && (duree = type.getDuree()) != null && duree.intValue() != 0) {
                this.setEndTime(startTime + duree.intValue());
            }
        }
        this.getAppointment().setTypeAppointment(type == null ? null : type.getId());
    }

    public XAppointmentPeriodType getServiceType() {
        if (this.getAppointment() == null || this.getAppointment().getIdService() == null) {
            return null;
        }
        return this.getAppointmentMainController().getObjectResolver().getPeriodType(this.getAppointment().getIdService());
    }

    public void setServiceType(XAppointmentPeriodType type) {
        this.getAppointment().setIdService(type == null ? null : type.getId());
    }

    public void addListener(IAppointmentControllerListener listener) {
        this.manager.addListener((Object)listener);
    }

    public void removeListener(IAppointmentControllerListener listener) {
        this.manager.removeListener((Object)listener);
    }

    public void dispose() {
        if (!this.getAppointmentMainController().isDisposed()) {
            ObjectListenerManager.removeListener((IObjectListener)this.controllerListener);
            this.getAppointmentMainController().removeListener(this.controllerListener);
        }
    }

    public void setAppointmentController(AppointmentMainController appointmentController) {
        if (appointmentController == null) {
            throw new NullPointerException("appointmentController");
        }
        if (appointmentController.isDisposed()) {
            throw new IllegalArgumentException("appointmentController is disposed");
        }
        if (this.appointmentController != appointmentController) {
            if (this.appointmentController != null && !this.appointmentController.isDisposed()) {
                this.appointmentController.removeListener(this.controllerListener);
            }
            this.appointmentController = appointmentController;
            this.appointmentController.addListener(this.controllerListener);
        }
    }

    public AppointmentMainController getAppointmentMainController() {
        return this.appointmentController;
    }

    public XAppointment getAppointment() {
        return this.appointment;
    }

    public void setSite(XSite site) {
        if (this.getAppointment() != null) {
            this.getAppointment().setSite(site == null ? null : site.getId());
        }
    }

    public XSite getSite() {
        if (this.getAppointment() == null) {
            return null;
        }
        return this.getAppointmentMainController().getObjectResolver().getSite(this.getAppointment().getSite());
    }

    public String toString() {
        return String.format("AppointmentController [appointment=%s]", this.getAppointment());
    }

    public IPatient getCurrentPatient() {
        return this.currentPatient;
    }

    public void setCurrentPatient(IPatient currentPatient) {
        ObjectListenerManager.removeListener((Object)this.currentPatient, (IObjectListener)this.controllerListener);
        this.currentPatient = currentPatient;
        ObjectListenerManager.addListener((Object)this.currentPatient, (IObjectListener)this.controllerListener);
    }

    public XPatient addNewPatient() {
        XAppointment appointment = this.getAppointment();
        Integer site = appointment.getSite();
        if (site == null) {
            site = this.getAppointmentMainController().getObjectResolver().getContextSite().getId();
        }
        List patients = this.getAppointment().getPatients();
        for (XPatient x : patients) {
            if (x.getId() != null || !StringUtils.isEmpty((CharSequence)x.getFirstName()) || !StringUtils.isEmpty((CharSequence)x.getLastName())) continue;
            return x;
        }
        XPatient patient = new XPatient();
        XPersonSite ps = new XPersonSite();
        ps.setIdSite(site);
        ps.setAddedAs(SiteAddedAs.WORK_SITE);
        ps.setNew();
        patient.getLstSites().add((IMinimalEditableDataObject)ps);
        patient.setNew();
        this.addPatient(patient);
        return patient;
    }

    public boolean addPatient(XPatient patient) {
        XPatient patient1;
        if (patient == null) {
            throw new NullPointerException("patient");
        }
        List patients = this.getAppointment().getPatients();
        if (patients.size() == 1 && (patient1 = (XPatient)patients.iterator().next()).getId() == null && patient1.isNewOrNewUpdated() && patient.getId() != null) {
            patients.remove(patient1);
        }
        if (patients.contains(patient)) {
            return false;
        }
        patients.add(patient);
        return true;
    }

    public boolean removePatient(Collection<IPatient> list) {
        List patients = this.getAppointment().getPatients();
        patients.removeAll(list);
        return true;
    }

    public boolean replacePatient(XPatient newPatient) {
        List patients = this.getAppointment().getPatients();
        if (patients.size() > 1) {
            return false;
        }
        if (newPatient == null) {
            return false;
        }
        patients.clear();
        patients.add(newPatient);
        return true;
    }

    private final class AppointmentControllerAdapterExtension
    extends AppointmentControllerAdapter {
        private AppointmentControllerAdapterExtension() {
        }

        @Override
        public void objectModified(Object object) {
            if (object != null) {
                if (object == AppointmentController.this.getAppointment()) {
                    AppointmentController.this.proxy.appointmentModified();
                }
                if (object == AppointmentController.this.getCurrentPatient()) {
                    AppointmentController.this.proxy.patientModified();
                }
            }
        }

        @Override
        public void appointmentChanged(IAppointment o2) {
            if (this.isEquals((IAppointment)AppointmentController.this.getAppointment(), o2)) {
                AppointmentController.this.setAppointment(o2);
            }
        }

        @Override
        public void appointmentsChanged() {
            AppointmentController.this.proxy.appointmentModified();
        }

        @Override
        public void currentAppointmentChanged(IAppointment o2) {
            if (this.isEquals((IAppointment)AppointmentController.this.getAppointment(), o2)) {
                AppointmentController.this.setAppointment(o2);
            }
        }

        public boolean isEquals(IAppointment o1, IAppointment o2) {
            if (o1 == null && o2 == null) {
                return true;
            }
            if (o1 == null || o2 == null) {
                return false;
            }
            return o1.equals(o2) || o1.equalsByTag((IMinimalEditableDataObject)o2);
        }
    }

    public static interface IAppointmentControllerListener {
        public void appointmentChanged();

        public void appointmentModified();

        public void patientModified();
    }
}

