/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.appointment.control;

import ca.infodata.ofys.data.middle.dataobjects.appointment.IAppointment;
import ca.infodata.ofys.data.middle.dataobjects.appointment.IVisualAppointment;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentDate;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentDateTemplate;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentPeriod;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentPeriodType;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XBaseAppointmentDate;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XPatientStatus;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XReservedAppointment;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IEditableDataObjectList;
import ca.infodata.ofys.mb.listener.object.IObjectListener;
import ca.infodata.ofys.mb.listener.object.ObjectListenerManager;
import ca.infodata.ofys.status.MultiStatus;
import ca.infodata.ofys.ui.appointment.AppointmentPlugin;
import ca.infodata.ofys.ui.appointment.control.AppointmentVisualStructureScaleManager;
import ca.infodata.ofys.ui.appointment.control.AppointmentVisualStructureTimeManager;
import ca.infodata.ofys.ui.appointment.control.IAppointmentMode;
import ca.infodata.ofys.ui.appointment.control.IAppointmentVisualStructureContentProvider;
import ca.infodata.ofys.ui.appointment.control.IAppointmentVisualStructureListener;
import ca.infodata.ofys.ui.controls.util.IPreferenceListener;
import ca.infodata.ofys.ui.controls.util.PreferencesSettings;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.ofys.ui.library.log.Log;
import ca.infodata.util1.IntegerRange;
import ca.infodata.util1.Range;
import ca.infodata.util1.RangeNotation;
import ca.infodata.util1.date.LocalDate;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.mb.listeners.GenListenerManager;

public final class AppointmentVisualStructure
implements IAppointmentMode,
IPreferenceListener {
    private static final Logger logger = Logger.getLogger(AppointmentVisualStructure.class.getName());
    public static final VsPoint NULL_SELECTION = new VsPoint(-1, -1);
    private static final boolean RESTRICT_APPOINTMENT_TO_PERIOD_SPACE = false;
    private final IAppointmentVisualStructureContentProvider contentProvider;
    private final GenListenerManager<IAppointmentVisualStructureListener> manager;
    private final IAppointmentVisualStructureListener proxy;
    private final MyModelListener modelListener;
    private XAppointmentDate internal_date;
    private XAppointmentDateTemplate internal_dateTemplate;
    private boolean unusable;
    private IAppointmentMode.Mode mode;
    private boolean showDeletedAppointment;
    private boolean showCanceledAppointment;
    private VsData[] lineArray;
    private Range<Integer> lineArrayRange;
    private int nbLineByDay;
    private int oldNbLineByDay;
    private VsPoint selection;
    private VsPoint oldSelection;
    private boolean isReseting;
    private final int index;
    private AppointmentVisualStructureScaleManager scaleManager;
    private AppointmentVisualStructureTimeManager timeManager;
    private static final Comparator<IAppointment> sortByIdAsc = new Comparator<IAppointment>(){

        @Override
        public int compare(IAppointment o1, IAppointment o2) {
            long id1 = o1.getId() == null ? 0 : o1.getId();
            long id2 = o2.getId() == null ? 0 : o2.getId();
            return (int)(id1 - id2);
        }
    };

    public AppointmentVisualStructure(IAppointmentVisualStructureContentProvider contentProvider, int index) {
        this.contentProvider = contentProvider;
        this.index = index;
        this.unusable = true;
        this.manager = new GenListenerManager(IAppointmentVisualStructureListener.class);
        this.proxy = (IAppointmentVisualStructureListener)this.manager.getProxy();
        this.modelListener = new MyModelListener();
        this.mode = IAppointmentMode.Mode.NONE;
        this.showDeletedAppointment = PreferencesSettings.getInstance().getBoolean("appointment/show_deleted_appointment");
        this.showCanceledAppointment = PreferencesSettings.getInstance().getBoolean("appointment/show_canceled_appointment");
        this.scaleManager = new AppointmentVisualStructureScaleManager();
        this.timeManager = new AppointmentVisualStructureTimeManager();
        PreferencesSettings.getInstance().addListener((IPreferenceListener)this);
    }

    void checkUsable() {
        if (this.unusable) {
            throw new IllegalStateException("The AppointmentVisualStructure is unusable");
        }
    }

    public void refresh() {
        this.getAppointmentDateTemplate();
        if (this.isUsable()) {
            this.getScale();
        }
    }

    private void setUnusable(boolean b) {
        logger.log(Level.FINE, String.valueOf(this.index) + ".setUnusable " + b);
        boolean changed = this.unusable ^ b;
        this.unusable = b;
        if (changed) {
            this.proxy.unusableStateChanged(this.unusable);
        }
    }

    public boolean isUnusable() {
        return this.unusable;
    }

    public boolean isUsable() {
        return !this.unusable;
    }

    public void forceReset() {
        this.internal_date = null;
        this.scaleManager.clearCache();
        this.timeManager.clearCache();
        this.reset();
    }

    public void reset() {
        if (!UI.isCurrentThreadIsUIThread()) {
            SWT.error((int)22);
        }
        if (!this.unusable && !this.isReseting) {
            logger.log(Level.FINE, String.valueOf(this.index) + ".AppointmentVisualStructure.reset");
            this.isReseting = true;
            if (this.getDate() == null && this.getAppointmentDate() == null && this.getAppointmentDateTemplate() == null) {
                this.oldNbLineByDay = 0;
                this.nbLineByDay = 0;
                this.lineArray = null;
                this.internal_date = null;
                this.internal_dateTemplate = null;
                this.timeManager.clearCache();
                this.scaleManager.clearCache();
                this.oldSelection = this.selection;
                this.selection = NULL_SELECTION;
                this.setUnusable(true);
            } else {
                this.oldNbLineByDay = this.nbLineByDay;
                this.nbLineByDay = (this.timeManager.getEndTimeMinute(this) - this.timeManager.getStartTimeMinute(this)) / this.scaleManager.getScaleNoReset(this);
                this.fill();
                if (this.selection != null && this.selection != NULL_SELECTION && this.oldNbLineByDay != this.nbLineByDay) {
                    float ratio = (float)this.selection.line * 100.0f / (float)this.oldNbLineByDay;
                    float line = ratio * (float)this.nbLineByDay / 100.0f;
                    this.oldSelection = this.selection;
                    this.selection = new VsPoint(this.selection.column, (int)line);
                }
                if (!this.isSelectionValid(this.selection)) {
                    this.oldSelection = this.selection;
                    this.selection = NULL_SELECTION;
                }
                this.proxy.mustRefresh();
                this.isReseting = false;
            }
        }
    }

    private void fill() {
        logger.log(Level.FINE, String.valueOf(this.index) + ".AppointmentVisualStructure.fill");
        if (this.lineArray == null || this.lineArray.length != this.nbLineByDay) {
            this.lineArray = new VsData[this.nbLineByDay];
        }
        int i = 0;
        while (i < this.lineArray.length) {
            if (this.lineArray[i] == null) {
                this.lineArray[i] = new VsData();
            } else {
                this.lineArray[i].reset();
            }
            ++i;
        }
        this.lineArrayRange = new IntegerRange(Integer.valueOf(0), Integer.valueOf(this.lineArray.length), RangeNotation.LEFT_CLOSED);
        this.fillPeriods();
        this.fillAppointments(0, this.nbLineByDay - 1);
    }

    private void fillPeriods() {
        for (XAppointmentPeriod period : this.getPeriods()) {
            boolean truncated;
            int periodStartLine = this.getLine(period);
            int periodEndLine = periodStartLine + this.getHeight(period);
            boolean intersect = this.lineArrayRange.intersect((Range)new IntegerRange(Integer.valueOf(periodStartLine), Integer.valueOf(periodEndLine), RangeNotation.CLOSED));
            if (!intersect) continue;
            boolean truncatedStart = periodStartLine < 0;
            boolean truncatedEnd = periodEndLine > this.lineArray.length - 1;
            boolean bl = truncated = truncatedStart || truncatedEnd;
            if (truncated && logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, period + " has been truncated");
            }
            int safePeriodStartLine = truncatedStart ? 0 : periodStartLine;
            int safePeriodEndLine = truncatedEnd ? this.lineArray.length : periodEndLine;
            int line = safePeriodStartLine;
            while (line < safePeriodEndLine) {
                this.lineArray[line].period = period;
                this.lineArray[line].truncated = truncated;
                ++line;
            }
        }
    }

    private void fillAppointments(int pStartLine, int pEndLine) {
        int startLine = this.getHighestLineOfReference(pStartLine);
        int endLine = this.getLowestLineOfReference(pEndLine);
        AppointmentBlock mainBlock = new AppointmentBlock(startLine, endLine);
        mainBlock.clear();
        List<? extends IAppointment> appointments = this.getAppointments();
        Collections.sort(appointments, sortByIdAsc);
        for (IAppointment iAppointment : appointments) {
            mainBlock.addAppointment((IVisualAppointment)iAppointment);
        }
        List<XReservedAppointment> list = this.getReserverdAppointments();
        for (XReservedAppointment x : list) {
            mainBlock.addAppointment((IVisualAppointment)x);
        }
    }

    private int getHighestLineOfReference(int currentLine) {
        if (currentLine < 0) {
            return 0;
        }
        if (currentLine > this.lineArray.length - 1) {
            return this.lineArray.length - 1;
        }
        int currentHighestLine = currentLine;
        for (IVisualAppointment appointment : this.lineArray[currentLine].appointments.values()) {
            if (appointment == null) continue;
            appointment = this.contentProvider.getAppointment(appointment);
            currentHighestLine = Math.min(currentHighestLine, this.getLine(appointment));
        }
        if (currentHighestLine != currentLine) {
            currentHighestLine = this.getHighestLineOfReference(currentHighestLine);
        }
        return currentHighestLine;
    }

    private int getLowestLineOfReference(int currentLine) {
        if (currentLine < 0) {
            return 0;
        }
        if (currentLine > this.lineArray.length - 1) {
            return this.lineArray.length - 1;
        }
        int currentLowestLine = currentLine;
        for (IVisualAppointment appointment : this.lineArray[currentLine].appointments.values()) {
            if (appointment == null) continue;
            appointment = this.contentProvider.getAppointment(appointment);
            int endLine = this.getLine(appointment) + this.getHeight(appointment) - 1;
            currentLowestLine = Math.max(currentLowestLine, endLine);
        }
        if (currentLowestLine != currentLine) {
            currentLowestLine = this.getLowestLineOfReference(currentLowestLine);
        }
        return currentLowestLine;
    }

    public List<XReservedAppointment> getReserverdAppointments() {
        if (this.getAppointmentDate() == null) {
            return Collections.emptyList();
        }
        IEditableDataObjectList<XReservedAppointment> reservedAppointments = this.contentProvider.getReservedAppointments(this.getAppointmentDate());
        return reservedAppointments;
    }

    public List<? extends IAppointment> getAppointments() {
        if (this.getAppointmentDate() == null) {
            return Collections.emptyList();
        }
        IEditableDataObjectList<? extends IAppointment> appointments = this.contentProvider.getAppointments(this.getAppointmentDate());
        Iterator iterator = appointments.iterator();
        while (iterator.hasNext()) {
            IAppointment appointment = (IAppointment)iterator.next();
            if (!this.showDeletedAppointment && Boolean.TRUE.equals(appointment.getIsDeleted())) {
                iterator.remove();
                continue;
            }
            if (this.showCanceledAppointment || appointment.getPatientStatus() != XPatientStatus.CANCEL && appointment.getPatientStatus() != XPatientStatus.CANCEL_LESS_24H) continue;
            iterator.remove();
        }
        return appointments;
    }

    private List<XAppointmentPeriod> getPeriods() {
        if (this.getAppointmentDateTemplate() == null) {
            return Collections.emptyList();
        }
        return this.getAppointmentDateTemplate().getPeriods().getNotDeleted();
    }

    private boolean containsAppointment(int line) {
        if (line > -1 && line < this.nbLineByDay - 1) {
            return !this.lineArray[line].appointments.isEmpty();
        }
        return false;
    }

    public IVisualAppointment getAppointment(int column, int line) {
        this.checkUsable();
        if (line > -1 && line < this.nbLineByDay) {
            IVisualAppointment appointment = this.lineArray[line].appointments.get(column);
            return this.contentProvider.getAppointment(appointment);
        }
        return null;
    }

    public XBaseAppointmentDate getBaseAppointmentDate() {
        LocalDate date = this.getDate();
        if (date != null) {
            return this.contentProvider.getBaseAppointmentDate(date);
        }
        return null;
    }

    public XAppointmentDate getAppointmentDate() {
        XAppointmentDate date = this.contentProvider.getAppointmentDate(this.getDate());
        if (this.internal_date != date) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, String.valueOf(this.index) + ".internal_date != date --> date : " + date);
            }
            if (this.internal_date != null) {
                ObjectListenerManager.removeListener((Object)this.internal_date, (IObjectListener)this.modelListener);
            }
            if (date != null) {
                ObjectListenerManager.addListener((Object)date, (IObjectListener)this.modelListener);
            }
            this.internal_date = date;
            this.scaleManager.clearCache();
            this.timeManager.clearCache();
            this.setUnusable(this.internal_date == null);
            this.reset();
        }
        return this.internal_date;
    }

    public XAppointmentDateTemplate getAppointmentDateTemplate() {
        XAppointmentDate date;
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, String.valueOf(this.index) + ".internal_date=" + this.internal_date + ", date=" + this.getDate());
        }
        if (this.internal_date != (date = this.contentProvider.getAppointmentDate(this.getDate()))) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, String.valueOf(this.index) + ".internal_date != date --> date : " + date);
            }
            if (this.internal_date != null) {
                ObjectListenerManager.removeListener((Object)this.internal_date, (IObjectListener)this.modelListener);
            }
            if (date != null) {
                ObjectListenerManager.addListener((Object)date, (IObjectListener)this.modelListener);
            }
            this.internal_date = date;
            this.scaleManager.clearCache();
            this.timeManager.clearCache();
        }
        XAppointmentDateTemplate dateTemplate = null;
        dateTemplate = date != null ? date.getDateTemplate() : this.contentProvider.getAppointmentDateTemplate();
        if (this.internal_dateTemplate != dateTemplate) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(String.valueOf(this.index) + ".internal_dateTemplate != dateTemplate --> dateTemplate : " + dateTemplate);
            }
            if (this.internal_dateTemplate != null) {
                ObjectListenerManager.removeListener((Object)this.internal_dateTemplate, (IObjectListener)this.modelListener);
            }
            if (dateTemplate != null) {
                ObjectListenerManager.addListener((Object)dateTemplate, (IObjectListener)this.modelListener);
            }
            this.internal_dateTemplate = dateTemplate;
            this.scaleManager.clearCache();
            this.timeManager.clearCache();
            this.setUnusable(this.internal_dateTemplate == null);
            this.reset();
        }
        return this.internal_dateTemplate;
    }

    public int getColumn(IVisualAppointment appointment) {
        this.checkUsable();
        appointment = this.contentProvider.getAppointment(appointment);
        int column = -1;
        int line = this.getLine(appointment);
        if (line > 0 && line < this.lineArray.length) {
            for (Map.Entry<Integer, IVisualAppointment> entry : this.lineArray[line].appointments.entrySet()) {
                if (appointment != entry.getValue() && !appointment.equals(entry.getValue())) continue;
                column = entry.getKey();
            }
        }
        return column;
    }

    public LocalDate getDate() {
        return this.contentProvider.getDate();
    }

    public int getEndHour() {
        this.checkUsable();
        return this.timeManager.getEndHour(this);
    }

    public int getEndTimeMinute() {
        this.checkUsable();
        return this.timeManager.getEndTimeMinute(this);
    }

    public int getHeight(IVisualAppointment appointment) {
        this.checkUsable();
        appointment = this.contentProvider.getAppointment(appointment);
        return (appointment.getEndTime().intValue() - appointment.getStartTime().intValue()) / this.getScale();
    }

    public int getHeight(XAppointmentPeriod period) {
        this.checkUsable();
        return (period.getEndTime() - period.getStartTime()) / this.getScale();
    }

    public int getLastColumnIndex(int line) {
        this.checkUsable();
        if (line < this.nbLineByDay && line > -1) {
            return this.lineArray[line].lastColumnIndex;
        }
        return -1;
    }

    public int getLine(IVisualAppointment appointment) {
        this.checkUsable();
        appointment = this.contentProvider.getAppointment(appointment);
        return (appointment.getStartTime().intValue() - this.getStartTimeMinute()) / this.getScale();
    }

    public VsPoint getPoint(IVisualAppointment appointment) {
        this.checkUsable();
        appointment = this.contentProvider.getAppointment(appointment);
        int line = this.getLine(appointment);
        int column = -1;
        if (line >= 0 && line < this.lineArray.length) {
            for (Map.Entry<Integer, IVisualAppointment> item : this.lineArray[line].appointments.entrySet()) {
                if (appointment != item.getValue() && !appointment.equals(item.getValue())) continue;
                column = item.getKey();
                break;
            }
        } else {
            line = -1;
        }
        return new VsPoint(column, line);
    }

    public VsPoint getPoint(XAppointmentPeriod period) {
        this.checkUsable();
        int line = this.getLine(period);
        return new VsPoint(0, line);
    }

    public int getLine(XAppointmentPeriod period) {
        this.checkUsable();
        if (period != null) {
            return (period.getStartTime() - this.getStartTimeMinute()) / this.getScale();
        }
        return -1;
    }

    public int getLineByAppointment(XAppointmentPeriod period) {
        this.checkUsable();
        return Math.max(1, period.getDefaultLength() / this.getScale());
    }

    @Override
    public IAppointmentMode.Mode getMode() {
        return this.mode;
    }

    public int getNbLineByDay() {
        this.checkUsable();
        return this.nbLineByDay;
    }

    public XAppointmentPeriod getPeriod(int line) {
        this.checkUsable();
        if (line > -1 && line < this.nbLineByDay) {
            return this.lineArray[line].period;
        }
        return null;
    }

    public boolean isTruncated(XAppointmentPeriod period) {
        if (period == null) {
            throw new NullPointerException("period");
        }
        int line = this.getLine(period);
        return line != -1 && (!this.lineArrayRange.contains((Comparable)Integer.valueOf(line)) || this.lineArray[line].truncated);
    }

    public int getScale() {
        this.checkUsable();
        return this.scaleManager.getScale(this);
    }

    public IVisualAppointment getSelectedAppointment() {
        this.checkUsable();
        IVisualAppointment appointment = null;
        if (this.selection.line < this.nbLineByDay && this.selection.line > -1 && this.selection.column > -1) {
            appointment = this.getAppointment(this.selection.column, this.selection.line);
        }
        return appointment;
    }

    public XAppointmentPeriod getSelectedPeriod() {
        this.checkUsable();
        XAppointmentPeriod period = null;
        if (this.selection.line < this.nbLineByDay && this.selection.line > -1) {
            period = this.getPeriod(this.selection.line);
        }
        return period;
    }

    public VsPoint getOldSelection() {
        this.checkUsable();
        return this.oldSelection;
    }

    public VsPoint getSelection() {
        this.checkUsable();
        return this.selection;
    }

    public int getSelectionStartTime() {
        this.checkUsable();
        if (!this.isSelectionValid(this.selection)) {
            return -1;
        }
        return this.selection.line * this.getScale() + this.getStartTimeMinute();
    }

    public int getSelectionEndTime() {
        this.checkUsable();
        if (!this.isSelectionValid(this.selection)) {
            return -1;
        }
        return this.getSelectionStartTime() + this.getScale();
    }

    public int getStartHour() {
        this.checkUsable();
        return this.timeManager.getStartHour(this);
    }

    public int getStartTimeMinute() {
        this.checkUsable();
        return this.timeManager.getStartTimeMinute(this);
    }

    private void setHeight(IVisualAppointment appointment, int height) {
        this.checkUsable();
        this.contentProvider.setEndTime(appointment, height * this.getScale() + appointment.getStartTime().intValue());
    }

    private void setLine(IVisualAppointment appointment, int line) {
        this.checkUsable();
        appointment = this.contentProvider.getAppointment(appointment);
        this.contentProvider.setTimes(appointment, line * this.getScale() + this.getStartTimeMinute(), line * this.getScale() + this.getStartTimeMinute() + appointment.getEndTime() - appointment.getStartTime());
    }

    private void setLine(XAppointmentPeriod period, int line) {
        this.checkUsable();
        ObjectListenerManager.disable((Object)period);
        period.setEndTime(Integer.valueOf(line * this.getScale() + this.getStartTimeMinute() + period.getEndTime() - period.getStartTime()));
        period.setStartTime(Integer.valueOf(line * this.getScale() + this.getStartTimeMinute()));
        ObjectListenerManager.enable((Object)period, (boolean)true);
    }

    @Override
    public void setMode(IAppointmentMode.Mode mode) {
        this.mode = mode;
    }

    public int getTime(int line) {
        this.checkUsable();
        return this.getStartTimeMinute() + line * this.getScale();
    }

    public int getLine(int startTime) {
        this.checkUsable();
        if (startTime < this.getStartTimeMinute() || startTime > this.getEndTimeMinute()) {
            return -1;
        }
        return (startTime - this.getStartTimeMinute()) * 10000 / this.scaleManager.getScale(this) / 10000;
    }

    public void setSelection(VsPoint selection) {
        this.checkUsable();
        if (!this.selection.equals(selection)) {
            boolean allowSelection;
            boolean bl = allowSelection = this.getMode() != IAppointmentMode.Mode.APPOINTMENT || selection == null || NULL_SELECTION.equals(selection) || this.getPeriod(selection.line) == null || AppointmentVisualStructure.canHaveAppointment(this.getPeriod(selection.line)) || selection.column != -1 && this.containsAppointment(selection.line);
            if (allowSelection) {
                logger.fine("oldSelection " + this.selection + " newSelection " + (selection == null ? NULL_SELECTION : selection));
                this.oldSelection = this.selection;
                this.selection = selection == null ? NULL_SELECTION : selection;
                this.proxy.selectionChanged(selection);
            } else {
                this.setSelection(NULL_SELECTION);
            }
        }
    }

    public void setSelection(XAppointmentPeriod period) {
        boolean allowSelection;
        this.checkUsable();
        boolean bl = allowSelection = this.getMode() != IAppointmentMode.Mode.APPOINTMENT || period == null || AppointmentVisualStructure.canHaveAppointment(period);
        if (allowSelection) {
            this.setSelection(new VsPoint(-1, this.getLine(period)));
        } else {
            this.setSelection(NULL_SELECTION);
        }
    }

    public void setSelection(IVisualAppointment appointment) {
        this.checkUsable();
        appointment = this.contentProvider.getAppointment(appointment);
        if (appointment == null) {
            this.setSelection(NULL_SELECTION);
        } else {
            IVisualAppointment selectedAppointment = this.getSelectedAppointment();
            if (selectedAppointment == null || !selectedAppointment.equals(appointment)) {
                this.setSelection(new VsPoint(this.getColumn(appointment), this.getLine(appointment)));
            }
        }
    }

    public void addListener(IAppointmentVisualStructureListener listener) {
        this.manager.addListener((Object)listener);
    }

    public void removeListener(IAppointmentVisualStructureListener listener) {
        this.manager.removeListener((Object)listener);
    }

    public void resize(IVisualAppointment appointment, boolean shrink) {
        this.checkUsable();
        appointment = this.contentProvider.getAppointment(appointment);
        if (this.canSeeAndModifyAppointment(appointment)) {
            int height = this.getHeight(appointment);
            if (shrink) {
                if (height > 1) {
                    this.setHeight(appointment, height - 1);
                }
            } else {
                int line = this.getLine(appointment);
                int newEndLine = line + height;
                if (newEndLine <= this.nbLineByDay) {
                    this.setHeight(appointment, height + 1);
                }
            }
        }
    }

    public boolean move(XAppointmentPeriod period, int newStartLine) {
        if (period == null) {
            throw new IllegalArgumentException("period cant be null");
        }
        int line = this.getLine(period);
        int height = this.getHeight(period);
        if (newStartLine != line && newStartLine > -1 && line + height < this.nbLineByDay) {
            int i = newStartLine;
            while (i < newStartLine + height) {
                if (this.lineArray[i].period != null && this.lineArray[i].period != period) {
                    return false;
                }
                ++i;
            }
            this.setLine(period, newStartLine);
            this.setSelection(this.fixSelection(new VsPoint(this.selection.column, newStartLine)));
            return true;
        }
        return false;
    }

    public boolean move(IVisualAppointment appointment, int newStartLine) {
        if (appointment == null) {
            throw new IllegalArgumentException("appointment cant be null");
        }
        if (this.canSeeAndModifyAppointment(appointment = this.contentProvider.getAppointment(appointment))) {
            int line = this.getLine(appointment);
            int height = this.getHeight(appointment);
            boolean canMove = true;
            int i = newStartLine;
            while (i < newStartLine + height) {
                XAppointmentPeriod period = this.getPeriod(i);
                if (period != null && !AppointmentVisualStructure.canHaveAppointment(period)) {
                    canMove = false;
                    break;
                }
                ++i;
            }
            if (canMove && newStartLine != line && newStartLine > -1 && newStartLine + height <= this.nbLineByDay) {
                this.setLine(appointment, newStartLine);
                this.setSelection(this.fixSelection(new VsPoint(this.getColumn(appointment), newStartLine)));
                return true;
            }
        }
        return false;
    }

    public boolean resize(IVisualAppointment appointment, int newEndLine) {
        if (appointment == null) {
            throw new IllegalArgumentException("appointment cant be null");
        }
        if (this.canSeeAndModifyAppointment(appointment = this.contentProvider.getAppointment(appointment))) {
            int line = this.getLine(appointment);
            if (newEndLine < line) {
                newEndLine = line + 1;
            }
            if (newEndLine != line && newEndLine >= line && newEndLine > -1 && newEndLine <= this.nbLineByDay) {
                this.setHeight(appointment, newEndLine - line);
                this.setSelection(this.fixSelection(new VsPoint(this.getColumn(appointment), newEndLine - 1)));
                return true;
            }
        }
        return false;
    }

    public int resize(XAppointmentPeriod period, int newEndLine) {
        this.checkUsable();
        if (period == null) {
            throw new IllegalArgumentException("period cant be null");
        }
        int line = this.getLine(period);
        if (newEndLine < line) {
            int add = Math.max(period.getDefaultLength() / this.getScale(), 1);
            newEndLine = line + add;
        }
        if (newEndLine != line && newEndLine >= line && newEndLine > -1 && newEndLine <= this.nbLineByDay) {
            int i = line + this.getHeight(period);
            while (i < newEndLine) {
                if (this.lineArray[i].period != null && this.lineArray[i].period != period) {
                    return 1;
                }
                ++i;
            }
            this.setHeight(period, newEndLine - line);
            this.setSelection(new VsPoint(this.selection.column, this.getLine(period)));
            return 0;
        }
        return -1;
    }

    private void setHeight(XAppointmentPeriod period, int height) {
        int sectionLength = period.getDefaultLength();
        int startTime = period.getStartTime();
        int length = height * this.getScale();
        int modulo = length % sectionLength;
        if (modulo != 0) {
            length -= modulo;
        }
        if (length != 0) {
            period.setEndTime(Integer.valueOf(startTime + length));
            Integer defaultLength = period.getDefaultLength();
            if (defaultLength == null || defaultLength > length) {
                period.setDefaultLength(Integer.valueOf(length));
            }
        }
    }

    public void up(IAppointment appointment) {
        this.checkUsable();
        int line = this.getLine((IVisualAppointment)appointment);
        int nbLine = this.getHeight((IVisualAppointment)appointment);
        int newLine = this.getAppointmentNextHigherLine(line, nbLine, false);
        if (newLine != line) {
            this.setLine((IVisualAppointment)appointment, newLine);
            this.setSelection(this.getPoint((IVisualAppointment)appointment));
        }
    }

    private int getAppointmentNextHigherLine(int line, int nbLine, boolean restrictToPeriodSpace) {
        VsPoint higherSelection = this.findNextValidSelectionHigherOrEqualThan(new VsPoint(0, line), restrictToPeriodSpace);
        if (higherSelection.line != line) {
            int newLine = higherSelection.line;
            boolean enoughSpace = true;
            if (restrictToPeriodSpace) {
                int i = 1;
                while (i < nbLine) {
                    if (this.lineArray[newLine + i].period == null) {
                        enoughSpace = false;
                        break;
                    }
                    ++i;
                }
                if (!enoughSpace) {
                    newLine = newLine - (nbLine - i) + 1;
                    return this.getAppointmentNextHigherLine(newLine, nbLine, restrictToPeriodSpace);
                }
                return newLine;
            }
            return newLine;
        }
        return line;
    }

    public void down(IVisualAppointment appointment) {
        this.checkUsable();
        appointment = this.contentProvider.getAppointment(appointment);
        int line = this.getLine(appointment);
        int nbLine = this.getHeight(appointment);
        int newLine = this.getAppointmentNextLowerLine(line, nbLine, false);
        if (newLine != line) {
            this.setLine(appointment, newLine);
            this.setSelection(this.getPoint(appointment));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getAppointmentNextLowerLine(int line, int nbLine, boolean restrictToPeriodSpace) {
        VsPoint lowerSelection = this.findNextValidSelectionLowerOrEqualThan(new VsPoint(0, line), restrictToPeriodSpace);
        if (lowerSelection.line == line) return line;
        int newLine = lowerSelection.line;
        if (newLine + nbLine >= this.nbLineByDay) {
            return line;
        }
        if (!restrictToPeriodSpace) return newLine;
        boolean enoughSpace = true;
        int i = 1;
        while (i < nbLine) {
            if (this.lineArray[newLine + i].period == null) {
                enoughSpace = false;
                break;
            }
            ++i;
        }
        if (enoughSpace) return newLine;
        if ((newLine = newLine + nbLine - 1) + nbLine >= this.nbLineByDay) {
            return line;
        }
        int newLine2 = this.getAppointmentNextLowerLine(newLine, nbLine, restrictToPeriodSpace);
        if (newLine2 == newLine) return line;
        return newLine2;
    }

    public boolean isLineValid(int line) {
        return line >= 0 && line < this.lineArray.length;
    }

    private boolean isSelectionValid(VsPoint selection) {
        boolean notValid = selection == null || selection.line < 0 || selection.line >= this.nbLineByDay;
        return !notValid;
    }

    public boolean down() {
        this.checkUsable();
        VsPoint newSelection = !this.isSelectionValid(this.selection) ? this.findFirstValidSelection(false) : this.findNextValidSelectionLowerOrEqualThan(this.selection, false);
        newSelection = this.fixSelection(newSelection);
        if (!newSelection.equals(this.selection)) {
            this.setSelection(newSelection);
            return true;
        }
        return false;
    }

    public boolean up() {
        this.checkUsable();
        VsPoint newSelection = !this.isSelectionValid(this.selection) ? this.findFirstValidSelection(false) : this.findNextValidSelectionHigherOrEqualThan(this.selection, false);
        newSelection = this.fixSelection(newSelection);
        if (!newSelection.equals(this.selection)) {
            this.setSelection(newSelection);
            return true;
        }
        return false;
    }

    public boolean left() {
        this.checkUsable();
        VsPoint newSelection = !this.isSelectionValid(this.selection) ? this.findFirstValidSelection(false) : this.findNextValidSelectionLefterOrEqualThan(this.selection);
        if (!newSelection.equals(this.selection)) {
            this.setSelection(newSelection);
            return true;
        }
        return false;
    }

    public boolean right() {
        this.checkUsable();
        VsPoint newSelection = !this.isSelectionValid(this.selection) ? this.findFirstValidSelection(false) : this.findNextValidSelectionRighterOrEqualThan(this.selection);
        if (!newSelection.equals(this.selection)) {
            this.setSelection(newSelection);
            return true;
        }
        return false;
    }

    private VsPoint fixSelection(VsPoint pSelection) {
        int line = pSelection.line;
        int column = pSelection.column;
        int lastColumnIndex = this.getLastColumnIndex(pSelection.line);
        if (line < 0) {
            line = 0;
        } else if (column > 0 && column > lastColumnIndex) {
            column = 0;
        }
        if (line != pSelection.line || column != pSelection.column) {
            return new VsPoint(column, line);
        }
        return pSelection;
    }

    private VsPoint findLastValidSelection(boolean restrictToPeriodSpace) {
        return this.findNextValidSelectionHigherOrEqualThan(new VsPoint(0, this.lineArray.length), restrictToPeriodSpace);
    }

    private VsPoint findNextValidSelectionLowerOrEqualThan(VsPoint pSelection, boolean restrictToPeriodSpace) {
        int line = pSelection.line + 1;
        if (restrictToPeriodSpace) {
            while (line < this.lineArray.length && this.lineArray[line].period == null) {
                ++line;
            }
        }
        if (this.getMode() == IAppointmentMode.Mode.APPOINTMENT) {
            while (!(line >= this.lineArray.length || this.lineArray[line].period == null || AppointmentVisualStructure.canHaveAppointment(this.lineArray[line].period) || pSelection.column != -1 && this.containsAppointment(line))) {
                ++line;
            }
        }
        if (line >= this.lineArray.length) {
            return pSelection;
        }
        return new VsPoint(pSelection.column, line);
    }

    private static boolean canHaveAppointment(XAppointmentPeriod period) {
        if (period == null) {
            System.out.println(false);
            return false;
        }
        XAppointmentPeriodType periodType = AppointmentPlugin.getDefault().getPeriodType(period.getAppointmentPeriodType());
        if (periodType == null || !Boolean.TRUE.equals(periodType.getCanHaveAppointment())) {
            System.out.println(false);
            return false;
        }
        System.out.println(!period.isClosed());
        return !period.isClosed();
    }

    private VsPoint findFirstValidSelection(boolean restrictToPeriodSpace) {
        return this.findNextValidSelectionLowerOrEqualThan(new VsPoint(0, -1), restrictToPeriodSpace);
    }

    private VsPoint findNextValidSelectionHigherOrEqualThan(VsPoint pSelection, boolean restrictToPeriodSpace) {
        int line = pSelection.line - 1;
        if (restrictToPeriodSpace) {
            while (line >= 0 && this.lineArray[line].period == null) {
                --line;
            }
        }
        if (this.getMode() == IAppointmentMode.Mode.APPOINTMENT) {
            while (!(line < 0 || this.lineArray[line].period == null || AppointmentVisualStructure.canHaveAppointment(this.lineArray[line].period) || pSelection.column != -1 && this.containsAppointment(line))) {
                --line;
            }
        }
        if (line < 0) {
            return pSelection;
        }
        return new VsPoint(pSelection.column, line);
    }

    private VsPoint findNextValidSelectionLefterOrEqualThan(VsPoint pSelection) {
        int newColumn;
        int column = pSelection.column;
        int n = newColumn = column > -1 ? column - 1 : -1;
        if (newColumn != column) {
            return new VsPoint(newColumn, pSelection.line);
        }
        return pSelection;
    }

    private VsPoint findNextValidSelectionRighterOrEqualThan(VsPoint pSelection) {
        int line = pSelection.line;
        int column = pSelection.column;
        int lastColumnIndex = this.getLastColumnIndex(line);
        int newColumn = column;
        if (lastColumnIndex <= 0) {
            newColumn = 0;
        } else if (column < lastColumnIndex) {
            ++newColumn;
        }
        if (newColumn != column) {
            return new VsPoint(newColumn, line);
        }
        return pSelection;
    }

    public int changePeriodTime(XAppointmentPeriod period, int startTime, int endTime) {
        this.checkUsable();
        return this.getAppointmentDateTemplate().changePeriodTime(period, startTime, endTime);
    }

    public int changeDateTemplateScale(int newScale) {
        this.checkUsable();
        return this.getAppointmentDateTemplate().changeScale(newScale);
    }

    public void changed(String preferenceId, String oldValue, String newValue) {
        if (this.isUsable()) {
            if (preferenceId.equals("appointment/show_deleted_appointment")) {
                this.showDeletedAppointment = Boolean.valueOf(newValue);
                Display.getDefault().asyncExec(() -> this.forceReset());
            } else if (preferenceId.equals("appointment/show_canceled_appointment")) {
                this.showCanceledAppointment = Boolean.valueOf(newValue);
                Display.getDefault().asyncExec(() -> this.forceReset());
            }
        }
    }

    public boolean canSeeAndModifyAppointment(IVisualAppointment appointment) {
        this.checkUsable();
        return this.contentProvider.canSeeAndModifyAppointment(appointment);
    }

    IAppointmentVisualStructureContentProvider getContentProvider() {
        return this.contentProvider;
    }

    public boolean isShowDeletedAppointment() {
        return this.showDeletedAppointment;
    }

    public boolean isShowCanceledAppointment() {
        return this.showCanceledAppointment;
    }

    public void setScaleManager(AppointmentVisualStructureScaleManager scaleManager) {
        this.scaleManager = scaleManager;
    }

    public void setTimeManager(AppointmentVisualStructureTimeManager timeManager) {
        this.timeManager = timeManager;
    }

    public void validChange(String preferenceId, String oldValue, String newValue, MultiStatus status) {
    }

    public String toString() {
        return "AppointmentVisualStructure [internal_date=" + this.internal_date + ", internal_dateTemplate=" + this.internal_dateTemplate + ", unusable=" + this.unusable + ", mode=" + (Object)((Object)this.mode) + ", showDeletedAppointment=" + this.showDeletedAppointment + ", showCanceledAppointment=" + this.showCanceledAppointment + ", nbLineByDay=" + this.nbLineByDay + ", oldNbLineByDay=" + this.oldNbLineByDay + ", selection=" + this.selection + ", oldSelection=" + this.oldSelection + ", isReseting=" + this.isReseting + ", index=" + this.index + "]";
    }

    private class AppointmentBlock {
        final int blockStartLine;
        final int blockEndLine;

        AppointmentBlock(int startLine, int endLine) {
            this.blockStartLine = startLine;
            this.blockEndLine = endLine;
        }

        private int computeLastColumnIndex() {
            int column = -1;
            int i = this.blockStartLine;
            while (i <= this.blockEndLine) {
                column = Math.max(column, ((AppointmentVisualStructure)AppointmentVisualStructure.this).lineArray[i].lastColumnIndex);
                ++i;
            }
            return column;
        }

        boolean contain(AppointmentBlock block) {
            if (block == this) {
                return true;
            }
            if (block == null) {
                return false;
            }
            boolean contain = RangeNotation.CLOSED.inRange(block.blockStartLine, this.blockStartLine, this.blockEndLine) || RangeNotation.CLOSED.inRange(block.blockEndLine, this.blockStartLine, this.blockEndLine);
            return contain;
        }

        void clear() {
            int i = this.blockStartLine;
            while (i <= this.blockEndLine) {
                ((AppointmentVisualStructure)AppointmentVisualStructure.this).lineArray[i].lastColumnIndex = -1;
                ((AppointmentVisualStructure)AppointmentVisualStructure.this).lineArray[i].appointments.clear();
                ++i;
            }
        }

        void addAppointment(IVisualAppointment appointment) {
            int appointmentStartLine = AppointmentVisualStructure.this.getLine(appointment);
            int appointmentEndLine = appointmentStartLine + AppointmentVisualStructure.this.getHeight(appointment) - 1;
            AppointmentBlock block = null;
            if (appointmentStartLine >= 0 && appointmentStartLine < AppointmentVisualStructure.this.lineArray.length && appointmentEndLine >= 0 && appointmentEndLine < AppointmentVisualStructure.this.lineArray.length) {
                block = new AppointmentBlock(AppointmentVisualStructure.this.getHighestLineOfReference(appointmentStartLine), AppointmentVisualStructure.this.getLowestLineOfReference(appointmentEndLine));
            }
            if (this.contain(block)) {
                int column = super.getColumnForAppointment(appointmentStartLine, appointmentEndLine);
                int i = appointmentStartLine;
                while (i <= appointmentEndLine) {
                    ((AppointmentVisualStructure)AppointmentVisualStructure.this).lineArray[i].appointments.put(column, appointment);
                    ++i;
                }
            }
        }

        private int getColumnForAppointment(int appointmentStartLine, int appointmentEndLine) {
            int column = this.getVacantColumnForAppointment(appointmentStartLine, appointmentEndLine);
            if (column == -1) {
                column = this.newColumn();
                int i = this.blockStartLine;
                while (i <= this.blockEndLine) {
                    ((AppointmentVisualStructure)AppointmentVisualStructure.this).lineArray[i].lastColumnIndex = column;
                    ++i;
                }
            } else {
                int lastColumnIndex = this.computeLastColumnIndex();
                int i = this.blockStartLine;
                while (i <= this.blockEndLine) {
                    ((AppointmentVisualStructure)AppointmentVisualStructure.this).lineArray[i].lastColumnIndex = lastColumnIndex;
                    ++i;
                }
            }
            return column;
        }

        private int newColumn() {
            return this.computeLastColumnIndex() + 1;
        }

        private int getVacantColumnForAppointment(int appointmentStartLine, int appointmentEndLine) {
            if (appointmentStartLine < 0 || appointmentStartLine >= AppointmentVisualStructure.this.lineArray.length || appointmentEndLine < 0 || appointmentEndLine >= AppointmentVisualStructure.this.lineArray.length) {
                return -1;
            }
            VsData data = AppointmentVisualStructure.this.lineArray[appointmentStartLine];
            int i = 0;
            while (i <= data.lastColumnIndex) {
                int nbAppointment = data.appointments.size();
                if ((i > nbAppointment || data.appointments.get(i) == null) && this.isSpaceEnoughHigh(appointmentStartLine, appointmentEndLine, i)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        private boolean isSpaceEnoughHigh(int startLine, int endLine, int column) {
            int j = startLine;
            while (j <= endLine) {
                if (column < ((AppointmentVisualStructure)AppointmentVisualStructure.this).lineArray[j].appointments.size() && ((AppointmentVisualStructure)AppointmentVisualStructure.this).lineArray[j].appointments.get(column) != null) {
                    return false;
                }
                ++j;
            }
            return true;
        }

        public String toString() {
            return String.format("Block [%d-%d]", this.blockStartLine, this.blockEndLine);
        }
    }

    private class MyModelListener
    implements IObjectListener {
        private MyModelListener() {
        }

        public void objectModified(Object object) {
            Log.log((Logger)logger, (String)"AppointmentVisualStructure.objectModified", (String[])new String[]{"object"}, (Object[])new Object[]{object});
            if (UI.isCurrentThreadIsUIThread()) {
                AppointmentVisualStructure.this.scaleManager.clearCache();
                AppointmentVisualStructure.this.timeManager.clearCache();
                AppointmentVisualStructure.this.reset();
            } else {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        AppointmentVisualStructure.this.scaleManager.clearCache();
                        AppointmentVisualStructure.this.timeManager.clearCache();
                        AppointmentVisualStructure.this.reset();
                    }
                });
            }
        }
    }

    private static class VsData {
        int lastColumnIndex = -1;
        boolean truncated = false;
        XAppointmentPeriod period;
        final Map<Integer, IVisualAppointment> appointments = new HashMap<Integer, IVisualAppointment>();

        private VsData() {
        }

        void reset() {
            this.lastColumnIndex = -1;
            this.period = null;
            this.appointments.clear();
        }

        public String toString() {
            return String.format("VsData %d %s %s", this.lastColumnIndex, this.period, this.appointments);
        }
    }

    public static class VsPoint {
        public final int line;
        public final int column;

        public VsPoint(int column, int line) {
            this.line = line;
            this.column = column;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.column;
            result = 31 * result + this.line;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof VsPoint)) {
                return false;
            }
            VsPoint other = (VsPoint)obj;
            if (this.column != other.column) {
                return false;
            }
            return this.line == other.line;
        }

        public String toString() {
            return String.format("VsPoint (%d,%d)", this.column, this.line);
        }
    }
}

