/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.appointment.control;

import ca.infodata.ofys.data.dataaccess.util.MessageUtil;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.appointment.IAppointment;
import ca.infodata.ofys.data.middle.dataobjects.appointment.IVisualAppointment;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentDate;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentDateTemplate;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentPeriod;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentPeriodType;
import ca.infodata.ofys.mb.listener.object.ObjectListenerManager;
import ca.infodata.ofys.ui.appointment.control.AppointmentDrawer;
import ca.infodata.ofys.ui.appointment.control.AppointmentVisualStructure;
import ca.infodata.ofys.ui.appointment.control.BaseDrawer;
import ca.infodata.ofys.ui.appointment.control.IAppointmentDateControlContentProvider;
import ca.infodata.ofys.ui.appointment.control.IAppointmentMode;
import ca.infodata.ofys.ui.appointment.control.IAppointmentVisualStructureListener;
import ca.infodata.ofys.ui.appointment.control.PeriodDrawer;
import ca.infodata.ofys.ui.controls.BaseView;
import ca.infodata.ofys.ui.library.UI;
import ca.infodata.ofys.ui.library.log.Log;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.GestureEvent;
import org.eclipse.swt.events.GestureListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TouchEvent;
import org.eclipse.swt.events.TouchListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchPage;

public class AppointmentDateControl
extends Composite {
    private static final Logger logger = Logger.getLogger(AppointmentDateControl.class.getName());
    private Canvas appointmentCanvas;
    private AppointmentDrawer appointmentDrawer;
    private PeriodDrawer periodDrawer;
    private BaseDrawer currentDrawer;
    private Composite parent;
    private ScrollBar scroll;
    private AppointmentVisualStructure myAppointmentVisualStructure;
    private MyAppointmentVisualStructureListener visualStructureListener;
    private IAppointmentDateControlContentProvider contentProvider;
    private Integer thumb;
    protected final boolean usingTabletPerspective;
    private boolean isResizing;
    private boolean isMoving;
    private boolean isRefreshing;
    private int internal_nbLineByDay = -1;
    private KeyEvent lastKeyEvent;

    public AppointmentDateControl(Composite parent, int style, IAppointmentDateControlContentProvider contentProvider) {
        super(parent, 512);
        this.parent = parent;
        this.contentProvider = contentProvider;
        IWorkbenchPage page = BaseView.getPage();
        IPerspectiveDescriptor perspective = page.getPerspective();
        this.usingTabletPerspective = perspective != null && perspective.getId().equals("ca.infodata.ofys.ui.menu.EncounterPerspective");
        this.visualStructureListener = new MyAppointmentVisualStructureListener();
        this.setLayout((Layout)new FormLayout());
        this.appointmentCanvas = new Canvas((Composite)this, 264192);
        this.scroll = this.getVerticalBar();
        this.appointmentDrawer = new AppointmentDrawer(this.appointmentCanvas, this.scroll);
        this.periodDrawer = new PeriodDrawer(this.appointmentCanvas, this.scroll){

            @Override
            protected XAppointmentPeriod createNewPeriod(XAppointmentDateTemplate dateTemplate, int startTime, int endTime) {
                Log.log((Level)Level.FINE, (String)"", (String)"createNewPeriod", (String[])new String[]{"dateTemplate", "startTime", "endTime"}, (Object[])new Object[]{dateTemplate, startTime, endTime});
                return AppointmentDateControl.this.createNewPeriod(dateTemplate, startTime, endTime);
            }
        };
        this.currentDrawer = this.appointmentDrawer;
        this.periodDrawer.setVisualStructure(null);
        this.appointmentDrawer.setVisualStructure(null);
        FormData data = new FormData();
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.top = new FormAttachment(0);
        data.bottom = new FormAttachment(100);
        this.appointmentCanvas.setLayoutData((Object)data);
        if (this.usingTabletPerspective) {
            this.appointmentCanvas.addGestureListener(new GestureListener(){

                public void gesture(GestureEvent ge) {
                    if (ge.detail == 2) {
                        System.out.println("GESTURE_BEGIN:" + ge);
                    }
                    if (ge.detail == 8) {
                        System.out.println("GESTURE_ROTATE:" + ge);
                    }
                    if (ge.detail == 32) {
                        System.out.println("GESTURE_MAGNIFY:" + ge);
                    }
                    if (ge.detail == 16) {
                        System.out.println("GESTURE_SWIPE:" + ge);
                        AppointmentVisualStructure appointmentVisualStructure = AppointmentDateControl.this.getAppointmentVisualStructure();
                    }
                    if (ge.detail == 64) {
                        System.out.println("GESTURE_PAN:" + ge);
                    }
                    if (ge.detail == 4) {
                        System.out.println("GESTURE_END:" + ge);
                    }
                }
            });
        }
        this.appointmentCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                AppointmentDateControl.this.currentDrawer.drawControl(e.gc);
            }
        });
        this.scroll.addSelectionListener((SelectionListener)new SelectionAdapter(){
            int selection = -1;

            public void widgetSelected(SelectionEvent e) {
                if (AppointmentDateControl.this.scroll.getSelection() != this.selection) {
                    this.selection = AppointmentDateControl.this.scroll.getSelection();
                    AppointmentDateControl.this.appointmentCanvas.redraw();
                }
            }
        });
        this.appointmentCanvas.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                AppointmentDateControl.this.appointmentDrawer.dispose();
                AppointmentDateControl.this.periodDrawer.dispose();
            }
        });
        this.appointmentCanvas.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                AppointmentDateControl.this.mouseLocationChanged(e.x, e.y);
            }
        });
        this.appointmentCanvas.addTouchListener(new TouchListener(){

            public void touch(TouchEvent e) {
                AppointmentDateControl.this.appointmentCanvas.notifyListeners(8, UI.toEvent((TouchEvent)e));
            }
        });
        this.appointmentCanvas.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                AppointmentDateControl.this.mouseDoubleClicked(e);
            }

            public void mouseDown(MouseEvent e) {
                AppointmentDateControl.this.mouseClicked(e);
            }

            public void mouseUp(MouseEvent e) {
                if (AppointmentDateControl.this.usingTabletPerspective && !AppointmentDateControl.this.isResizing()) {
                    AppointmentDateControl.this.isMoving();
                }
                AppointmentDateControl.this.mouseReleased(e.x, e.y);
            }
        });
        this.appointmentCanvas.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                e.doit = true;
            }
        });
        this.appointmentCanvas.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent arg0) {
                AppointmentDateControl.this.currentDrawer.setFocus(true);
                AppointmentDateControl.this.appointmentCanvas.redraw();
            }

            public void focusLost(FocusEvent arg0) {
                AppointmentDateControl.this.currentDrawer.setFocus(false);
                AppointmentDateControl.this.appointmentCanvas.redraw();
            }
        });
        this.appointmentCanvas.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                AppointmentDateControl.this.keyboardAction(e);
            }

            public void keyReleased(KeyEvent e) {
                AppointmentDateControl.this.lastKeyEvent = null;
            }
        });
        this.appointmentCanvas.addMouseWheelListener(new MouseWheelListener(){

            public void mouseScrolled(MouseEvent e) {
                if (AppointmentDateControl.this.lastKeyEvent != null && UI.CTRL((KeyEvent)AppointmentDateControl.this.lastKeyEvent)) {
                    AppointmentDateControl.this.zoomOverride(e.count);
                }
            }
        });
    }

    public void zoomOverride(int count) {
        this.zoom(count);
    }

    public final void zoom(int count) {
        float h = this.getDrawer().lineHeight;
        h += (float)count;
        h = Math.min(h, 55.0f);
        this.getDrawer().lineHeight = h = Math.max(h, 30.0f);
        this.getDrawer().redraw();
    }

    public void reveal(IAppointment appointment, boolean center) {
        if (appointment == null) {
            throw new IllegalArgumentException();
        }
        AppointmentVisualStructure vs = this.getVisualStructure();
        if (vs != null) {
            this.reveal(new AppointmentVisualStructure.VsPoint(vs.getColumn((IVisualAppointment)appointment), vs.getLine((IVisualAppointment)appointment)), center);
        }
    }

    public int getTime(int line) {
        AppointmentVisualStructure vs = this.getAppointmentVisualStructure();
        return vs.getTime(line);
    }

    public int getFirstVisibleLine() {
        return this.getDrawer().firstVisibleLine;
    }

    public void reveal(int time, boolean center) {
        int line;
        AppointmentVisualStructure vs = this.getAppointmentVisualStructure();
        if (vs != null && (line = vs.getLine(time)) != -1) {
            this.reveal(new AppointmentVisualStructure.VsPoint(0, line), center);
        }
    }

    public void select(int time) {
        int line;
        AppointmentVisualStructure vs = this.getAppointmentVisualStructure();
        if (vs != null && (line = vs.getLine(time)) != -1) {
            vs.setSelection(new AppointmentVisualStructure.VsPoint(0, line));
        }
    }

    public void reveal(AppointmentVisualStructure.VsPoint point, boolean center) {
        float line = point.line;
        float nbLineByDay = this.getVisualStructure().getNbLineByDay();
        float ratio = line * 100.0f / nbLineByDay;
        float max = this.scroll.getMaximum();
        float selection = max * ratio / 100.0f;
        if (center) {
            if (this.thumb == null) {
                this.thumb = this.scroll.getThumb();
            }
            selection -= (float)(this.thumb / 2);
        }
        this.scroll.setSelection((int)selection);
    }

    public void reveal(boolean center) {
        AppointmentVisualStructure vs = this.getVisualStructure();
        if (vs != null) {
            this.reveal(vs.getSelection(), center);
        }
    }

    protected void scrollUp(boolean ifSelectionIsLowerThanThumb) {
        if (ifSelectionIsLowerThanThumb) {
            int vsSelectionLine = this.getVisualStructure().getSelection().line;
            int selection = this.scroll.getSelection();
            if (vsSelectionLine < selection) {
                this.scroll.setSelection(selection - this.scroll.getIncrement());
                if (selection != this.scroll.getSelection()) {
                    this.appointmentCanvas.redraw();
                }
            }
        } else {
            int selection = this.scroll.getSelection();
            this.scroll.setSelection(selection - this.scroll.getIncrement());
            if (selection != this.scroll.getSelection()) {
                this.appointmentCanvas.redraw();
            }
        }
    }

    protected void scrollDown(boolean ifSelectionIsHigherThanThumb) {
        if (ifSelectionIsHigherThanThumb) {
            int vsSelectionLine = this.getVisualStructure().getSelection().line;
            int selection = this.scroll.getSelection();
            if (vsSelectionLine + 2 >= selection + this.scroll.getThumb()) {
                this.scroll.setSelection(selection + this.scroll.getIncrement());
                if (selection != this.scroll.getSelection()) {
                    this.appointmentCanvas.redraw();
                }
            }
        } else {
            int selection = this.scroll.getSelection();
            this.scroll.setSelection(selection + this.scroll.getIncrement());
            if (selection != this.scroll.getSelection()) {
                this.appointmentCanvas.redraw();
            }
        }
    }

    protected void scrollPageUp() {
        int selection = this.scroll.getSelection();
        this.scroll.setSelection(selection - this.scroll.getPageIncrement());
        if (selection != this.scroll.getSelection()) {
            this.appointmentCanvas.redraw();
        }
    }

    protected void scrollPageDown() {
        int selection = this.scroll.getSelection();
        this.scroll.setSelection(selection + this.scroll.getPageIncrement());
        if (selection != this.scroll.getSelection()) {
            this.appointmentCanvas.redraw();
        }
    }

    protected void scrollHome() {
        int selection = this.scroll.getSelection();
        this.scroll.setSelection(this.scroll.getMinimum());
        if (selection != this.scroll.getSelection()) {
            this.appointmentCanvas.redraw();
        }
    }

    protected void scrollEnd() {
        int selection = this.scroll.getSelection();
        this.scroll.setSelection(this.scroll.getMaximum());
        if (selection != this.scroll.getSelection()) {
            this.appointmentCanvas.redraw();
        }
    }

    private IAppointmentMode.Mode getMode() {
        if (this.getVisualStructure() == null) {
            return null;
        }
        return this.getVisualStructure().getMode();
    }

    protected void keyboardAction(KeyEvent e) {
        this.lastKeyEvent = e;
    }

    protected void mouseClicked(MouseEvent e) {
        System.out.println("AppointmentDateControl.mouseClicked()");
        if (this.parent.getVerticalBar() != null) {
            this.parent.setFocus();
        } else {
            this.appointmentCanvas.setFocus();
        }
        this.currentDrawer.setSelection(e.x, e.y);
        this.appointmentCanvas.redraw();
        if (!UI.rightClick((MouseEvent)e)) {
            Cursor cursor = this.currentDrawer.getCursorForMouseLocation(e.x, e.y);
            if (cursor == this.currentDrawer.CURSOR_RESIZE) {
                if (this.contentProvider.canResize()) {
                    this.isResizing = true;
                    this.appointmentCanvas.setCursor(cursor);
                }
            } else if (cursor == this.currentDrawer.CURSOR_MOVE) {
                if (this.contentProvider.canMove()) {
                    this.isMoving = true;
                    this.appointmentCanvas.setCursor(cursor);
                }
            } else {
                this.appointmentCanvas.setCursor(cursor);
            }
        }
    }

    private final void mouseDoubleClicked(MouseEvent e) {
        this.mouseClicked(e);
        this.isMoving = false;
        this.isResizing = false;
        this.mouseDoubleClickedOverride(e);
    }

    protected void mouseDoubleClickedOverride(MouseEvent e) {
        System.out.println("AppointmentDateControl.mouseDoubleClicked()");
    }

    protected void mouseLocationChanged(int x, int y) {
        if (this.isResizing() && this.contentProvider.canResize()) {
            if (this.currentDrawer.resizeTo(x, y)) {
                this.appointmentCanvas.redraw();
            }
        } else if (this.isMoving() && this.contentProvider.canMove()) {
            if (this.currentDrawer.moveTo(x, y)) {
                this.appointmentCanvas.redraw();
            }
        } else {
            Cursor cursor = this.currentDrawer.getCursorForMouseLocation(x, y);
            if (cursor == this.currentDrawer.CURSOR_RESIZE) {
                if (this.contentProvider.canResize()) {
                    this.appointmentCanvas.setCursor(cursor);
                }
            } else if (cursor == this.currentDrawer.CURSOR_MOVE) {
                if (this.contentProvider.canMove()) {
                    this.appointmentCanvas.setCursor(cursor);
                }
            } else {
                this.appointmentCanvas.setCursor(cursor);
            }
        }
    }

    protected void mouseReleased(int x, int y) {
        this.isResizing = false;
        this.isMoving = false;
    }

    protected boolean isResizing() {
        return this.isResizing;
    }

    protected boolean isMoving() {
        return this.isMoving;
    }

    public void setVisualStructure(AppointmentVisualStructure visualStructure) {
        Log.log((Logger)logger, (String)"AppointmentDateControl.setVisualStructure", (String[])new String[]{"visualStructure"}, (Object[])new Object[]{visualStructure});
        if (this.myAppointmentVisualStructure != visualStructure) {
            if (this.myAppointmentVisualStructure != null) {
                this.myAppointmentVisualStructure.removeListener(this.visualStructureListener);
            }
            this.myAppointmentVisualStructure = visualStructure;
            if (this.myAppointmentVisualStructure != null) {
                this.myAppointmentVisualStructure.addListener(this.visualStructureListener);
            }
            if (this.myAppointmentVisualStructure == null || this.myAppointmentVisualStructure.isUnusable()) {
                this.periodDrawer.setVisualStructure(null);
                this.appointmentDrawer.setVisualStructure(null);
                this.visualStructureChanged(null);
                this.internal_nbLineByDay = -1;
            } else {
                this.periodDrawer.setVisualStructure(this.myAppointmentVisualStructure);
                this.appointmentDrawer.setVisualStructure(this.myAppointmentVisualStructure);
                this.visualStructureChanged(this.myAppointmentVisualStructure);
                this.myAppointmentVisualStructure.getScale();
                this.internal_nbLineByDay = this.myAppointmentVisualStructure.getNbLineByDay();
            }
        }
    }

    public boolean changeDateTemplateScale(XAppointmentDateTemplate template, int scale) {
        if (template == null) {
            throw new NullPointerException("template");
        }
        return template.changeScale(scale) == 1;
    }

    public boolean changePeriodDefaultAppointmentLength(XAppointmentPeriod period, int newDefaultLength) {
        if (period == null) {
            throw new IllegalArgumentException("period cant be null");
        }
        boolean modified = false;
        int periodLength = period.getEndTime() - period.getStartTime();
        if (newDefaultLength > periodLength) {
            MessageUtil.warningMsg((Shell)this.getShell(), (String)Messages.getString((String)"VOUS_NE_POUVEZ_ENTRER_UNE_DUREE_DE_RENDEZVOUS_PLUS_GRANDE_QUE_LA_DUREE_DE_LA_PERIOD", (String[])new String[0]));
        } else if (newDefaultLength > 0) {
            int modulo = periodLength % newDefaultLength;
            if (modulo != 0) {
                ObjectListenerManager.disable((Object)period);
                period.setEndTime(Integer.valueOf(period.getEndTime() - modulo));
                period.setDefaultLength(Integer.valueOf(newDefaultLength));
                ObjectListenerManager.enable((Object)period, (boolean)true);
                modified = true;
            } else if (period.getDefaultLength() != newDefaultLength) {
                period.setDefaultLength(Integer.valueOf(newDefaultLength));
                modified = true;
            }
        }
        return modified;
    }

    public boolean changePeriodTime(XAppointmentPeriod period, int startTime, int endTime) {
        if (period == null) {
            throw new IllegalArgumentException("period cant be null");
        }
        AppointmentVisualStructure visualStructure = this.getVisualStructure();
        if (visualStructure == null) {
            logger.warning("visualstructure is null");
            return false;
        }
        if (visualStructure.isUnusable()) {
            logger.warning("visualstructure is unusable");
            return false;
        }
        int result = visualStructure.changePeriodTime(period, startTime, endTime);
        switch (result) {
            case 0: {
                return true;
            }
            case -1: {
                return false;
            }
            case -2: {
                return false;
            }
            case -3: {
                MessageBox msg = new MessageBox(this.getShell(), 8);
                msg.setText(Messages.getString((String)"AVERTISSEMENT", (String[])new String[0]));
                msg.setMessage(Messages.getString((String)"UNE_PERIOD_EXISTE_DEJA_DANS_CET_INTERVALE_DE_TEMPS", (String[])new String[0]));
                msg.open();
                return false;
            }
        }
        logger.warning("no treated changePeriodTime result " + result);
        return false;
    }

    public boolean changePeriodType(XAppointmentPeriod period, XAppointmentPeriodType newType) {
        if (period != null && newType != null) {
            period.setAppointmentPeriodType(newType.getId());
            this.redraw();
            return true;
        }
        return false;
    }

    public XAppointmentPeriod createNewPeriod(XAppointmentDateTemplate dateTemplate, int startTime, int endTime) {
        return this.getContentProvider().createNewPeriod(dateTemplate, startTime, endTime);
    }

    public AppointmentVisualStructure getAppointmentVisualStructure() {
        return this.getDrawer().getVisualStructure();
    }

    public Canvas getCanvas() {
        return this.appointmentCanvas;
    }

    public BaseDrawer getDrawer() {
        return this.currentDrawer;
    }

    public ScrollBar getScroll() {
        return this.scroll;
    }

    public AppointmentVisualStructure getVisualStructure() {
        return this.currentDrawer == null ? null : this.currentDrawer.getVisualStructure();
    }

    public void redraw() {
        super.redraw();
        this.currentDrawer.redraw();
        this.appointmentCanvas.redraw();
    }

    public void refresh() {
        boolean refreshAlsoVisualStructure = true;
        this.refresh(refreshAlsoVisualStructure);
    }

    private void refresh(boolean refreshAlsoVisualStructure) {
        if (this.isRefreshing) {
            return;
        }
        Log.log((Logger)logger, (Level)Level.FINE, (String)"AppointmentDateControl.refresh", (String[])new String[]{"refreshAlsoVisualStructure"}, (Object[])new Object[]{refreshAlsoVisualStructure});
        this.isRefreshing = true;
        if (refreshAlsoVisualStructure && this.myAppointmentVisualStructure != null) {
            this.myAppointmentVisualStructure.refresh();
        }
        BaseDrawer oldDrawer = this.currentDrawer;
        this.currentDrawer = this.getMode() == IAppointmentMode.Mode.SCHEDULE ? this.periodDrawer : (this.getMode() == IAppointmentMode.Mode.APPOINTMENT ? this.appointmentDrawer : this.appointmentDrawer);
        if (this.getVisualStructure() != null && this.getVisualStructure().isUsable()) {
            int nbLineByDay;
            if (oldDrawer != this.currentDrawer) {
                this.getVisualStructure().setSelection(AppointmentVisualStructure.NULL_SELECTION);
            }
            if ((nbLineByDay = this.getVisualStructure().getNbLineByDay()) != this.internal_nbLineByDay) {
                this.thumb = this.scroll.getThumb();
                int oldSelection = this.scroll.getSelection();
                int selection = this.scroll.getSelection() * nbLineByDay / this.internal_nbLineByDay;
                float oldRatio = (float)this.thumb.intValue() * 100.0f / (float)this.internal_nbLineByDay;
                float ratio = (float)this.thumb.intValue() * 100.0f / (float)nbLineByDay;
                float adjust = (oldRatio - ratio) * (float)nbLineByDay / 100.0f;
                selection = (int)((float)selection + adjust);
                AppointmentVisualStructure.VsPoint oldSelection2 = this.myAppointmentVisualStructure.getOldSelection();
                if (oldSelection2 != null) {
                    int oldSelectionLine = oldSelection2.line;
                    int selectionLine = this.myAppointmentVisualStructure.getSelection().line;
                    if (selectionLine != -1) {
                        float oldRatio2 = (float)(oldSelectionLine - oldSelection) * 100.0f / (float)this.thumb.intValue();
                        float ratio2 = (float)(selectionLine - selection) * 100.0f / (float)this.thumb.intValue();
                        float adjust2 = (ratio2 - oldRatio2) * (float)this.thumb.intValue() / 100.0f;
                        selection = (int)((float)selection + adjust2);
                    }
                }
                this.scroll.setMaximum(nbLineByDay);
                this.scroll.setSelection(selection);
                this.internal_nbLineByDay = nbLineByDay;
            }
        }
        this.redraw();
        this.thumb = this.scroll.getThumb();
        this.isRefreshing = false;
    }

    public void setAppointmentHeight(int selection) {
        this.appointmentDrawer.setAppointmentHeight(selection);
        this.periodDrawer.setAppointmentHeight(selection);
        this.redraw();
    }

    protected IAppointmentDateControlContentProvider getContentProvider() {
        return this.contentProvider;
    }

    protected void selectionChanged(IVisualAppointment selectedAppointment, XAppointmentPeriod selectedPeriod, XAppointmentDateTemplate selectedDateTemplate, XAppointmentDate selectedDate, Integer startTime, Integer endTime) {
    }

    protected void visualStructureChanged(AppointmentVisualStructure visualStructure) {
    }

    public void dispose() {
        this.setVisualStructure(null);
        this.visualStructureListener = null;
        this.appointmentCanvas = null;
        this.appointmentDrawer.dispose();
        this.appointmentDrawer = null;
        this.periodDrawer.dispose();
        this.periodDrawer = null;
        this.currentDrawer = null;
        this.parent = null;
        this.scroll = null;
        this.contentProvider = null;
        this.thumb = null;
        super.dispose();
    }

    public class MyAppointmentVisualStructureListener
    implements IAppointmentVisualStructureListener {
        private final Runnable refresh = new Runnable(){

            @Override
            public void run() {
                if (!AppointmentDateControl.this.isDisposed()) {
                    boolean refreshAlsoVisualStructure = false;
                    AppointmentDateControl.this.refresh(refreshAlsoVisualStructure);
                }
            }
        };
        private final Runnable redraw = new Runnable(){

            @Override
            public void run() {
                if (!AppointmentDateControl.this.isDisposed()) {
                    AppointmentDateControl.this.redraw();
                }
            }
        };

        @Override
        public void mustRefresh() {
            Display.getDefault().asyncExec(this.refresh);
        }

        @Override
        public void unusableStateChanged(final boolean unusable) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    Log.log((Logger)logger, (String)"AC MyAppointmentVisualStructureListener.unusableStateChanged", (String[])new String[]{"unusable"}, (Object[])new Object[]{unusable});
                    if (AppointmentDateControl.this.myAppointmentVisualStructure == null || unusable) {
                        AppointmentDateControl.this.periodDrawer.setVisualStructure(null);
                        AppointmentDateControl.this.appointmentDrawer.setVisualStructure(null);
                        AppointmentDateControl.this.visualStructureChanged(null);
                    } else {
                        AppointmentDateControl.this.periodDrawer.setVisualStructure(AppointmentDateControl.this.myAppointmentVisualStructure);
                        AppointmentDateControl.this.appointmentDrawer.setVisualStructure(AppointmentDateControl.this.myAppointmentVisualStructure);
                        AppointmentDateControl.this.visualStructureChanged(AppointmentDateControl.this.myAppointmentVisualStructure);
                    }
                }
            });
        }

        @Override
        public void mustRedraw() {
            Display.getDefault().asyncExec(this.redraw);
        }

        @Override
        public void selectionChanged(AppointmentVisualStructure.VsPoint newSelection) {
            Display.getDefault().asyncExec(this.redraw);
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    AppointmentVisualStructure visualStructure = AppointmentDateControl.this.getVisualStructure();
                    if (visualStructure != null) {
                        XAppointmentPeriod selectedPeriod = visualStructure.getSelectedPeriod();
                        IVisualAppointment selectedAppointment = visualStructure.getSelectedAppointment();
                        XAppointmentDate selectedDate = visualStructure.getAppointmentDate();
                        XAppointmentDateTemplate selectedDateTemplate = visualStructure.getAppointmentDateTemplate();
                        int startTime = visualStructure.getSelectionStartTime();
                        int endTime = visualStructure.getSelectionEndTime();
                        AppointmentDateControl.this.selectionChanged(selectedAppointment, selectedPeriod, selectedDateTemplate, selectedDate, startTime, endTime);
                    }
                }
            });
        }
    }
}

